<?php

$error = 0;
$message = '';
$tplfile = 'secret.tpl';

$conf = parse_ini_file("/var/www/conf/config.ini");
if (empty($conf)) {
     $log->err(logformat("Can't read config.ini"));
     exit(1);
}

if (isset($_POST['secret'])) {
    $pin = null;
    $secret = $_POST['secret'];
    if (strlen($secret) != 16) {
        $error = 1;
        $message = USS_ERR_101;
    }
    if (isset($_POST['pin'])) {
       $pin = $_POST['pin'];
       if (strlen($pin) != 8 || preg_match('/[^0-9]/', $pin)) {
           $error = 1;
           $message = USS_ERR_103;
       }
    }
    if (!$error) {
        $info = array();
        if (isset($conf['keyfile'])) {
            $secret = encrypt($secret, $conf['keyfile']);
        }
        $info['seciossOtpInitSecret'] = $secret;
        if ($pin) {
            if (isset($conf['keyfile'])) {
                $pin = encrypt($pin, $conf['keyfile']);
            }
            $info['seciossOtpSecretPIN'] = $pin;
        }
        $rc = ldap_mod_replace($ldap, $_SESSION['userdn'], $info);
        if (!$rc) {
            $error = 1;
            $log->crit(logformat("Setting secret failed: ". ldap_error($ldap)));
            $message = USS_ERR_102;
        } else {
            $log->notice(logformat("Setting secret succeeded"));
            $message = USS_NML_101;
        }
    }
}

$input = array();
if (isset($conf['input'])) {
    foreach (preg_split('/, */', $conf['input']) as $key) {
        $input[$key] = true;
    }
}
$smarty = new Smarty();
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';

$smarty->assign('username', $_SESSION['username']);
$smarty->assign('error', $error);
$smarty->assign('message', $message);
$smarty->assign('uri', $_SERVER['SCRIPT_NAME'].'?app=secret');
$smarty->assign('input', $input);

$smarty->display($tplfile);
?>
