<?php
$path = ini_get('include_path');
$path =  dirname(__FILE__) . PATH_SEPARATOR . $path;
ini_set('include_path', $path);

define('SECRETKEY_DIRECTIVE', 'TKTAuthSecret');

require_once("Log.php");

if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    $log = &Log::singleton('syslog', LOG_LOCAL5, $logid);
} else {
    $opts = array('locking' => true, 'timeFormat' => '%Y/%m/%d %H:%M:%S');
    $log = &Log::singleton('file', '/secioss/var/log/auth.log', $logid, $opts);
}

function logformat($message)
{
    $ipaddr = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '-';
    $user = isset($_SESSION['username']) ? $_SESSION['username'] : '-';

    return "$ipaddr $user $message";
}

function getSecretKey($file)
{
    $matches = array();
    $secretKey = "";

    $content = file_get_contents($file);
    if( $content === false ){
        // Cannot read key file
        return null;
    }

    if(preg_match( "/^\s*".SECRETKEY_DIRECTIVE."\s+\"(.*?)\"/mi", $content, $matches)) {
        $secretKey = $matches[1];
    }

    return $secretKey;
}

function encrypt($string, $keyfile)
{
    if ($string === null || $string === '') {
        return $string;
    }

    $key = getSecretKey($keyfile);
    if (!$key) {
        return null;
    }

    srand((double) microtime() * 1000000);
    $key = md5($key);
    $string = $key.$string;

    $td = mcrypt_module_open('tripledes', '', 'cfb', '');
    $key = substr($key, 0, mcrypt_enc_get_key_size($td));
    $iv_size = mcrypt_enc_get_iv_size($td);
    $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);

    if (mcrypt_generic_init($td, $key, $iv) != -1) {
        $c_t = mcrypt_generic($td, $string);
        mcrypt_generic($td, $string);
        mcrypt_module_close($td);
        $c_t = $iv.$c_t;
        return base64_encode($c_t);
    }
}

?>
