<?php
/**
 *  Pwd/Pwmail.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php 387 2006-11-06 14:31:24Z cocoitiban $
 */

define('INITPWTMPL', BASEDIR.'/conf/mail/initpw.mail');
define('WARNTMPL', BASEDIR.'/conf/mail/warn.mail');
define('EXPTMPL', BASEDIR.'/conf/mail/exp.mail');
define('OTPPINTMPL', BASEDIR.'/conf/mail/otppin.mail');

/**
 *  Pwd_Pwmailフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_PwdPwmail extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'type' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'メールの種類',
            'option'        => 'type_select'
        ),
        'subject' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '件名',
            'required'      => true,
        ),
        'message' => array(
            'type'          => VAR_TYPE_STRING,    
            'form_type'     => FORM_TYPE_TEXT,  
            'name'          => '本文',      
            'required'      => true,            
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );
}

/**
 *  Pwd_Pwmailアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_PwdPwmail extends Secioss_ActionClass
{
    /**
     *  PwdPwmailアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        $conf = $this->config->get('secioss');
        $modules = $this->config->get('modules');

        $this->af->type_select = array(INITPWTMPL => _et('パスワード初期化'));
        if (isset($modules['Mail'])) {
            $this->af->type_select[WARNTMPL] = _et('パスワード期限警告');
            $this->af->type_select[EXPTMPL] = _et('パスワード期限切れ');
        }
        foreach ($conf['user']['objectclass'] as $oc) {
            if ($oc == 'seciossotpuser') {
                $this->af->type_select[OTPPINTMPL] = _et('ワンタイムパスワードのPIN通知');
            }
        }

        if ($this->af->get('operation') == 'update' && $this->af->validate() > 0) {
            $this->ae->add(null, $this->getInvalidValMsg($this->getErrorFormName()));

            return 'Pwd_Pwmail';
        }

        return null;
    }

    /**
     *  PwdPwmailアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $confmgr =& $this->backend->getManager('Config');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');

        // input value
        $template = $this->af->get('type');
        $subject = $this->af->get('subject');
        $message = $this->af->get('message');
        $op = $this->af->get('operation');

        $tenant = $this->session->get('tenant');
        $params = array();
        if ($template) {
            switch($template) {
              case INITPWTMPL:
              case EXPTMPL:
                $params['password'] = _et('パスワード');
                break;
              case WARNTMPL:
                $params['expiration'] = _et('期限日');
                break;
              case OTPPINTMPL:
                $params['pin'] = _et('PIN');
                break;
            }
            $this->af->setApp('params', $params);

            if ($tenant) {
                $template = "$template-$tenant";
            }
        }

        if ($op == 'update') {
            if (!file_put_contents($template, "Subject: $subject\n$message")) {
                $logger->log(LOG_ERR, "Updating mail template failed");
                $this->ae->add(null, _et(C_FILEWRITE_ERR_MSG));

                return 'Pwd_Pwmail';
            }
            $confmgr->_replicate($template);

            $this->af->setApp('message', _et(C_UPDATE_SUCCESS_MSG));
            $logger->log(LOG_INFO, "Succeeded to update password initialization mail");
        } else if ($op == 'search') {
            $subject = '';
            $message = '';
            if (file_exists($template)) {
                $message = file_get_contents($template);
                if ($message === false) {
                    $logger->log(LOG_ERR, "Reading mail template failed");
                    $this->ae->add(null, _et(C_FILEOPEN_ERR_MSG));

                    return 'Pwd_Pwmail';
                }
            }

            if (preg_match("/^Subject: *(.*)\n/i", $message, $matches)) {
                $subject = $matches[1];
                $message = preg_replace("/^Subject:.*\n/i", '', $message);
            }
            $this->af->set('subject', $subject);
            $this->af->set('message', $message);
        }

        return 'Pwd_Pwmail';
    }
}
?>
