<?php
/**
 *  User/Create.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  user_createフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_UserCreate extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'newid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ユーザID',
            'regexp'        => '/^[^@&<>" ]*$/',
            'required'      => true
        ),
        'id' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'newloginid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ログインID'
        ),
        'loginid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT
        ),
        'newsnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'required'      => true
        ),
        'snkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT
        ),
        'newgnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名',
            'required'      => true
        ),
        'gnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT
        ),
        'newsnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓'
        ),
        'snkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT
        ),
        'newgnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名'
        ),
        'gnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT
        ),
        'newsnen' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓'
        ),
        'snen' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT
        ),
        'newgnen' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名'
        ),
        'gnen' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT
        ),
        'newempnum' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '社員番号'
        ),
        'empnum' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'newmail' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'メールアドレス',
            'regexp'        => '/^[a-zA-Z0-9]+[a-zA-Z0-9\._-]*@[a-zA-Z0-9]+[a-zA-Z0-9\._-]+$/',
        ),
        'mail' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT
        ),
        'newpassword' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'パスワード',
            'min'           => 4,
            'max'           => 20,
            'required'      => true
        ),
        'password' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'min'           => 4,
            'max'           => 20
        ),
        'newstatus' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'ユーザ状態',
            'option'        => 'status_select'
        ),
        'status' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'option'        => 'status_select'
        ),
        'pwloduration' => array(
            'type'          => VAR_TYPE_INT,
            'form_type'     => FORM_TYPE_TEXT,
            'min'           => 0,
            'max'           => null,
            'default'       => 0,
            'regexp'        => '/^[0-9]+$/'
        ),
        'secretpin' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'ワンタイムパスワードのPIN',
            'min'           => 8,
            'max'           => 8,
            'regexp'        => '/^[0-9]+$/'
        ),
        'certificate' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_FILE,
        ),
        'newsync' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'name'          => '更新対象システム',
            'option'        => 'sync_select'
        ),
        'sync' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'option'        => 'sync_select'
        ),
        'newtenant' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'テナント',
            'option'        => 'tenant_select'
        ),
        'newunit' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => '所属',
            'option'        => 'unit_select'
        ),
        'newsystem' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'システム',
            'option'        => 'system_select'
        ),
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );

}

/**
 *  user_createアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_UserCreate extends Secioss_ActionClass
{
    /**
     *  user_createアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');
        $conf = $this->config->get('secioss');

        $this->af->status_select = array('active' => _et('有効'), 'inactive' => _et('無効'));

        if ($this->af->get('operation') != "create") {
            return 'user_create';
        }

        if (isset($conf['user']['userdefinedattr'])) {
            foreach ($conf['user']['userdefinedattr'] as $key => $param) {
                if (isset($_POST['attr_'.$key])) {
                    $value = $_POST['attr_'.$key];
                    $this->af->setApp($key, $value);
                }
            }
        }

        if ($this->af->validate() > 0) {
            $this->ae->add(null, $this->getInvalidValMsg($this->getErrorFormName()));
            return 'user_create';
        }

        return null;
    }

    /**
     *  user_createアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');
        $conf = $this->config->get('secioss');
        $modules = $this->config->get('modules');
        $ldapconf = $this->config->get('ldap');
        $ldaptype = $this->session->get('ldaptype');

        // input value
        $id = $this->af->get('newid');
        $loginid = $this->af->get('newloginid');
        $snkanji = $this->af->get('newsnkanji');
        $snkana = $this->af->get('newsnkana');
        $snen = $this->af->get('newsnen');
        $gnkanji = $this->af->get('newgnkanji');
        $gnkana = $this->af->get('newgnkana');
        $gnen = $this->af->get('newgnen');
        $empnum = $this->af->get('newempnum');
        $mail = $this->af->get('newmail');
        $password = $this->af->get('newpassword');
        $status = $this->af->get('newstatus');
        $tenant = $this->af->get('newtenant');
        $unit = $this->af->get('newunit');
        $system = $this->af->get('newsystem');
        $sync = $this->af->get('newsync');

        $role = $this->session->get('role');

        if ($role == 'tenant_admin') {
            $tenant = $this->session->get('tenant');
        }

        if ($tenant && isset($conf['tenant']) && $conf['tenant'] == 'multiple') {
            $id = $id.'@'.$tenant;
        }

        $option = array();
        foreach ($conf['user']['objectclass'] as $oc) {
            switch ($oc) {
              case 'seciossotpuser':
                $option['otp'] = true;
                break;
              case 'pwdpolicy':
                $option['pwpolicy'] = true;
                break;
              default:
            }
        }
        $this->af->setApp('option', $option);

        $prop = array(
            'sn' => $snkanji
        );

        if (!$ldaptype || $ldaptype != 'AD') {
            $prop['uid'] = $id;
            $prop['cn'] = $snkanji." ".$gnkanji;
        } else {
            $domain = preg_replace(array('/,dc=/i', '/^[^.]+\./'), array('.', ''), $ldapconf['binddn']);
            $prop['cn'] = $id;
            $prop['displayname'] = $snkanji." ".$gnkanji;
            $prop['samaccountname'] = $id;
            $prop['userprincipalname'] = $id.'@'.$domain;
            $prop['useraccountcontrol'] = 512;
        }
        if ($empnum) {
            $prop['employeenumber'] = $empnum;
        }
        if ($mail) {
            $prop['mail'] = $mail;
        }
        if ($gnkanji) {
            $prop['givenname'] = $gnkanji;
        }
        if ($snkana) {
            $prop['cn;lang-ja;phonetic'] = "$snkana $gnkana";
            $prop['sn;lang-ja;phonetic'] = $snkana;
        }
        if ($gnkana) {
            $prop['givenname;lang-ja;phonetic'] = $gnkana;
        }
        if (isset($conf['user']['enameoption'])) {
            if ($snen) {
                $prop['cn;'.$conf['user']['enameoption']] = "$snen $gnen";
                $prop['sn;'.$conf['user']['enameoption']] = $snen;
            }
            if ($gnen) {
                $prop['givenname;'.$conf['user']['enameoption']] = $gnen;
            }
        }
        if ($ldaptype == 'AD') {
            $prop['unicodepwd'] = Secioss_User::getLdapPasswd($password);
        } else if (isset($modules['System']) ||
            ($system && strcasecmp($system, 'Master'))) {
            $prop['userpassword'] = $password;
        }
        if (isset($conf['user']['loginidattr'])) {
            $prop[$conf['user']['loginidattr']] = $loginid;
        }
        if (isset($conf['user']['statusattr'])) {
            $prop[$conf['user']['statusattr']] = $status;
        }
        if (isset($option['pwpolicy'])) {
            $prop['pwdattribute'] = '2.5.4.35';
        }
        if ($tenant) {
            $prop['area'] = $tenant;
        }
        if ($unit) {
            $prop['parent'] = $unit;
        }
        if ($system) {
            $prop['system'] = $system;
        }
        if (isset($conf['sync'])) {
            $prop['seciossallowedservice'] = $sync;
        }
        if (isset($conf['user']['userdefinedattr'])) {
            foreach ($conf['user']['userdefinedattr'] as $key => $param) {
                if (isset($_POST['attr_'.$key])) {
                    $value = $_POST['attr_'.$key];
                    if (isset($param['regexp'])) {
                        $invalid_flag = false;
                        if (is_array($value)) {
                            for ($i = 0; $i < count($value); $i++) {
                                if ($value[$i] && !preg_match($param['regexp'], $value[$i])) {
                                    $invalid_flag = true;
                                }
                            }
                        } else {
                            if (!preg_match($param['regexp'], $value)) {
                                $invalid_flag = true;
                            }
                        }
                        if ($invalid_flag) {
                            $this->ae->add(null, $param['name'].$this->getInvalidValMsg(null));

                            return 'user_update';
                        }
                    }

                    if (is_array($value)) {
                        $prop[$key] = array();
                        for ($i = 0; $i < count($value); $i++) {
                            if ($value[$i]) {
                                $prop[$key][] = $value[$i];
                            }
                        }
                    } else {
                        if ($value) {
                            $prop[$key] = $value;
                        } elseif (array_key_exists('default', $param)) {
                            $prop[$key] = $param['default'];
                        }
                    }
                }
            }
        }

        // add user data
        $user = $auth->addObject('user', $prop);
        if (Ethna::isError($user)) {
            if ($user->getCode() == 4) {
                $this->ae->add(null, S_MAXUSERS_ERR_MSG);

                return 'user_create';
            } else {
                $logger->log(LOG_ERR, "$login_user failed to add the user($id): ".$user->getMessage());
                $this->ae->add(null, _et(O_ADD_ERR_MSG));

                return 'user_create';
            }
        }

        if ($ldaptype != 'AD' && !isset($modules['System']) &&
            (!$system || strcasecmp($system, 'Master'))) {
            $rc = $user->initPasswd($password);
            if (Ethna::isError($rc)) {
                $logger->log(LOG_ERR, "$login_user failed to set the password of the user($id): ".$rc->getMessage());
                $this->ae->add(null, _et(O_UPDATE_ERR_MSG));
            }
        }

        $this->af->set('dn', $user->getId());
        $this->af->set('id', $id);
        $this->af->set('empnum', $user->get('employeenumber'));
        $this->af->set('loginid', $loginid);
        $this->af->set('snkanji', $snkanji);
        $this->af->set('gnkanji', $gnkanji);
        $this->af->set('snkana', $snkana);
        $this->af->set('gnkana', $gnkana);
        $this->af->set('snen', $snen);
        $this->af->set('gnen', $gnen);
        $this->af->set('mail', $mail);
        $this->af->set('status', $status);
        $this->af->set('operation', null);

        if (isset($conf['sync'])) {
            $this->af->set('sync', $sync);
        }
        $this->session->set('user_name', $user->get('cn'));
        if ($role == 'system_admin') {
            $this->session->set('tenant', $tenant);
        }
        if (isset($conf['unit'])) {
            $this->session->set('unit', $auth->getAttrName('unit', $unit));
        }
        if (isset($conf['system'])) {
            $this->session->set('system', $system);
        }

        $this->af->set('operation', 'read');

        $this->af->setApp('message', _et(O_ADD_SUCCESS_MSG));
        $logger->log(LOG_INFO, "$login_user succeded to create the user(".$user->getId().")");

        return 'user_update';
    }
}
?>
