<?php
/**
 *  User/Update.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  user_updateフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_UserUpdate extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'id' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'ユーザID'
        ),
        'loginid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ログインID'
        ),
        'snkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'required'      => true
        ),
        'gnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名',
            'required'      => true
        ),
        'snkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'gnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'snen' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'gnen' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'empnum' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => '社員番号'
        ),
        'mail' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'メールアドレス',
            'min'           => null,
            'max'           => null,
            'regexp'        => '/^[a-zA-Z0-9]+[a-zA-Z0-9\._-]*@[a-zA-Z0-9]+[a-zA-Z0-9\._-]+$/',
        ),
        'password' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'パスワード',
            'min'           => 4,
            'max'           => 20
        ),
        'status' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'ユーザ状態',
            'option'        => 'status_select'
        ),
        'unlock' => array(
            'type'          => array(VAR_TYPE_BOOLEAN),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'option'        => 'unlock_check'
        ),
        'lockout' => array(
            'type'          => VAR_TYPE_BOOLEAN,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'pwloduration' => array(
            'type'          => VAR_TYPE_INT,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ロックアウトの解除時間（分）',
            'min'           => 0,
            'regexp'        => '/^[0-9]+$/'
        ),
        'secretpin' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'ワンタイムパスワードのPIN',
            'min'           => 8,
            'max'           => 8,
            'regexp'        => '/^[0-9]+$/'
        ),
        'certificate' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_FILE,
            'name'          => '証明書'
        ),
        'tenant' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'テナント',
            'option'        => 'tenant_select'
        ),
        'sync' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'name'          => '更新対象システム',
            'option'        => 'sync_select'
        ),
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'required'       => true
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );
}

/**
 *  user_updateアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_UserUpdate extends Secioss_ActionClass
{
    /**
     *  user_updateアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        $conf = $this->config->get('secioss');

        $this->af->status_select = array('active' => _et('有効'), 'inactive' => _et('無効'));
        $this->af->unlock_check = array(true => _et('ロックアウト解除'));

        if (isset($conf['user']['userdefinedattr'])) {
            foreach ($conf['user']['userdefinedattr'] as $key => $param) {
                if (isset($_POST['attr_'.$key])) {
                    $value = $_POST['attr_'.$key];
                    $this->af->setApp($key, $value);
                }
            }
        }

        if ($this->af->get('operation') == 'update' && $this->af->validate() > 0) {
            $this->ae->add(null, $this->getInvalidValMsg($this->getErrorFormName()));

            return 'user_update';
        }

        return null;
    }

    /**
     *  user_updateアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');
        $conf = $this->config->get('secioss');
        $ldapconf = $this->config->get('ldap');
        $ldaptype = $this->session->get('ldaptype');

        // input value
        $id = $this->af->get('id');
        $loginid = $this->af->get('loginid');
        $snkanji = $this->af->get('snkanji');
        $gnkanji = $this->af->get('gnkanji');
        $snkana = $this->af->get('snkana');
        $gnkana = $this->af->get('gnkana');
        $snen = $this->af->get('snen');
        $gnen = $this->af->get('gnen');
        $empnum = $this->af->get('empnum');
        $mail = $this->af->get('mail');
        $password = $this->af->get('password');
        $sync = $this->af->get('sync');
        $status = $this->af->get('status');
        $unlock = $this->af->get('unlock');
        $lockout = $this->af->get('lockout');
        $pwloduration = $this->af->get('pwloduration') * 60;
        $secretpin = $this->af->get('secretpin');
        $newtenant = $this->af->get('tenant');
        $dn = $this->af->get('dn');
        $cn = "$snkanji $gnkanji";

        $tenant = $this->session->get('tenant');
        $role = $this->session->get('role');
        $system = $this->session->get('system');

        $option = array();
        foreach ($conf['user']['objectclass'] as $oc) {
            switch ($oc) {
              case 'seciossotpuser':
                $option['otp'] = true;
                break;
              case 'pwdpolicy':
                $option['pwpolicy'] = true;
                break;
              default:
            }
        }
        $this->af->setApp('option', $option);

        if ($this->af->get('operation') == 'update') {
            // update user data
            $prop = array(
                'id' => $dn
            );

            if ($ldaptype != 'AD' || $mail) {
                $prop['mail'] = $mail;
            }
            if (!$ldaptype || $ldaptype != 'AD') {
                $prop['cn'] = $snkanji." ".$gnkanji;
            } else {
                $prop['displayname'] = $snkanji." ".$gnkanji;
            }
            $prop['sn'] = $snkanji;
            $prop['givenname'] = $gnkanji;
            if ($snkana) {
                $prop['cn;lang-ja;phonetic'] = "$snkana $gnkana";
                $prop['sn;lang-ja;phonetic'] = $snkana;
            }
            if ($gnkana) {
                $prop['givenname;lang-ja;phonetic'] = $gnkana;
            }
            if (isset($conf['user']['enameoption'])) {
                if ($snen) {
                    $prop['cn;'.$conf['user']['enameoption']] = "$snen $gnen";
                    $prop['sn;'.$conf['user']['enameoption']] = $snen;
                }
                if ($gnen) {
                    $prop['givenname;'.$conf['user']['enameoption']] = $gnen;
                }
            }
            if (isset($conf['user']['loginidattr'])) {
                $prop[$conf['user']['loginidattr']] = $loginid;
            }
            if (isset($conf['user']['statusattr'])) {
                $prop[$conf['user']['statusattr']] = $status;
            }
            if (isset($conf['user']['pwlockoutattr']) && $lockout) {
                if ($unlock) {
                    $prop[$conf['user']['pwlockoutattr']] = 'FALSE';
                    $this->af->set('lockout', false);
                }
            }
            if (isset($option['pwpolicy'])) {
                if ($pwloduration) {
                    $prop['pwdlockoutduration'] = $pwloduration;
                } else {
                    $prop['pwdlockoutduration'] = -1;
                }
            }
            if (isset($conf['user']['certificateattr']) && isset($_FILES['certificate']['name']) && $_FILES['certificate']['name']) {
                if ($_FILES['certificate']['size'] == 0) {
                     $this->ae->add(null, $this->getInvalidValMsg('certificate'));

                     return 'user_update';
                }

                $certificate = '';
                $begin_cert = false;
                $file = fopen($_FILES['certificate']['tmp_name'], 'r');
                while (!feof($file)) {
                    $line = chop(fgets($file));
                    if ($line == '-----BEGIN CERTIFICATE-----') {
                        $begin_cert = true;
                    } else if ($line == '-----END CERTIFICATE-----') {
                        break;
                    } else if ($begin_cert) {
                        $certificate .= $line;
                    }
                }
                fclose($file);

                $ldapconf = $this->config->get('ldap');
                if (preg_match('/;binary$/', $conf['user']['certificateattr'])) {
                    $prop[$conf['user']['certificateattr']] = base64_decode($certificate);
                } else {
                    $prop[$conf['user']['certificateattr']] = $certificate;
                }
            }
            if (isset($conf['sync'])) {
                $prop['seciossallowedservice'] = $sync ? $sync : ' ';
            }
            if ($tenant) {
                $prop['area'] = $tenant;
                if ($newtenant && $newtenant != $tenant) {
                    $prop['parent'] = $conf['user']['objectdn'].','.$conf['area']['id']."=$newtenant,".$conf['basedn'];
                }
            }
            if ($system) {
                $prop['system'] = $system;
            }
            if (isset($conf['user']['userdefinedattr'])) {
                foreach ($conf['user']['userdefinedattr'] as $key => $param) {
                    if (isset($_POST['attr_'.$key])) {
                        $value = $_POST['attr_'.$key];
                        if (isset($param['mode']) && ($param['mode'] == 'read' || $param['mode'] == 'readonly')) {
                            continue;
                        }

                        if (isset($param['regexp'])) {
                            $invalid_flag = false;
                            if (is_array($value)) {
                                for ($i = 0; $i < count($value); $i++) {
                                    if ($value[$i] && !preg_match($param['regexp'], $value[$i])) {
                                        $invalid_flag = true;
                                    }
                                }
                            } else {
                                if (!preg_match($param['regexp'], $value)) {
                                    $invalid_flag = true;
                                }
                            }
                            if ($invalid_flag) {
                                $this->ae->add(null, $param['name'].$this->getInvalidValMsg(null));

                                return 'user_update';
                            }
                        }

                        if (is_array($value)) {
                            $prop[$key] = array();
                            for ($i = 0; $i < count($value); $i++) {
                               if ($value[$i]) {
                                   $prop[$key][] = $value[$i];
                               }
                            }
                        } else {
                            if ($value) {
                                $prop[$key] = $value;
                            } elseif (array_key_exists('default', $param)) {
                                $prop[$key] = $param['default'];
                            }
                        }
                    }
                }
            }

            $user = $auth->updateObject('user', null, null, $prop);
            if (Ethna::isError($user)) {
                $logger->log(LOG_ERR, "$login_user failed to update the user($dn): ".$user->getMessage());
                $this->ae->add(null, _et(O_UPDATE_ERR_MSG));

                return 'user_update';
            }

            if ($password) {
                $rc = $user->initPasswd($password, $ldaptype != 'AD');
                if (Ethna::isError($rc)) {
                    $logger->log(LOG_ERR, "$login_user failed to set the password of the user($dn): ".$rc->getMessage());
                    $this->ae->add(null, _et(O_UPDATE_ERR_MSG));

                    return 'user_update';
                }
            }

            if (isset($option['otp']) && preg_match('/^[^=]+=([^,]+),/', $dn, $matches)) {
                $file = BASEDIR.'/tmp/pin-'.$matches[1].time();
                file_put_contents($file, $matches[1].",$secretpin");
                exec("/opt/secioss/sbin/otpadd add $file $file.fail", $out, $rc);
                unlink($file);
                unlink("$file.fail");
                if ($rc) {
                    $logger->log(LOG_ERR, "$login_user failed to set OTP PIN of the user($dn): $out");
                    $this->ae->add(null, _et(O_UPDATE_ERR_MSG));

                    return 'user_update';
                }
            }

            if ($newtenant && $newtenant != $tenant) {
                $this->af->set('dn', $user->getId());
                $this->session->set('tenant', $newtenant);
            }

            $this->af->setApp('message', _et(O_UPDATE_SUCCESS_MSG));
            $logger->log(LOG_INFO, "$login_user succeeded to update the user($dn)");
        } else {
            $r = $auth->getObjectList('user', array('id' => $dn));
            if (Ethna::isError($r)) {
                $logger->log(LOG_ERR, "$login_user failed to get the user($dn): ".$r->getMessage());
                $this->ae->add(null, _et(S_INTERNAL_ERR_MSG));

                return 'user_update';
            } else if ($r[0] != 1) {
                $logger->log(LOG_ERR, "$login_user gets no user($dn)");
                $this->ae->add(null, _et(O_NO_SUCH_OBJECT_MSG));

                return 'user_update';
            }

            $user = $r[1][0];

            if ($ldaptype != 'AD') {
                $id = $user->get('uid');
                $cn = $user->get('cn');
            } else {
                $id = $user->get('cn');
                $cn = $user->get('displayname');
            }
            $this->af->set('id', $id);
            $sn = $user->get('sn');
            $this->af->set('snkanji', $sn);
            $sn = preg_quote($sn);
            $this->af->set('gnkanji', $user->get('givenname'));
            $snkana = $user->get('sn;lang-ja;phonetic');
            $this->af->set('snkana', $snkana);
            $cnkana = $user->get('cn;lang-ja;phonetic');
            $snkana = preg_quote($snkana);
            $this->af->set('gnkana', $user->get('givenname;lang-ja;phonetic'));
            $this->af->set('empnum', $user->get('employeenumber'));
            $this->af->set('mail', $user->get('mail'));
            if (isset($conf['user']['enameoption'])) {
                $this->af->set('snen', $user->get('sn;'.$conf['user']['enameoption']));
                $this->af->set('gnen', $user->get('givenname;'.$conf['user']['enameoption']));
            }
            if (isset($conf['user']['loginidattr'])) {
                $this->af->set('loginid', $user->get($conf['user']['loginidattr']));
            }
            if (isset($conf['user']['statusattr'])) {
                $this->af->set('status', $user->get($conf['user']['statusattr']));
            }
            if (isset($conf['user']['pwlockoutattr'])) {
                if ($user->get($conf['user']['pwlockoutattr']) == 'TRUE') {
                   $this->af->set('lockout', true);
                }
            }
            if (isset($option['pwlodurationattr'])) {
                $pwloduration = $user->get('pwdlockoutduration');
                $pwloduration = $pwloduration < 0 ? 0 : $pwloduration / 60;
                $this->af->set('pwloduration', $pwloduration);
            }
            if (isset($conf['sync'])) {
                $this->af->set('sync', to_array($user->get('seciossallowedservice')));
            }
            if (isset($conf['unit'])) {
                $this->session->set('unit', $auth->getAttrName('unit', preg_replace('/^[^,]+,/', '', $dn)));
            }
            if (isset($conf['area']) && $role == 'system_admin') {
                $this->session->set('tenant', $user->get('area'));
                $this->af->set('tenant', $user->get('area'));
            }
            if (isset($conf['system'])) {
                $this->session->set('system', $user->get('system'));
            }
        }

        if (isset($conf['user']['userdefinedattr'])) {
            foreach ($conf['user']['userdefinedattr'] as $key => $param) {
                $values = $user->get($key);
                if (isset($conf['user']['userdefinedattr'][$key]['multi'])) {
                    $values = to_array($values);
                }
                if ($values) {
                    $this->af->setApp($key, $values);
                }
            }
        }

        $this->session->set('user_name', $cn);

        return 'user_update';
    }
}
?>
