/**
 * @file  Clipboard.h
 * @brief Nbv{[hNX`.
 *
 * @author JIN
 *
 * Copyright (C) 2008- JIN All rights reserved.
 */
#pragma once

#include <boost/noncopyable.hpp>
#include "GlobalAlloc.h"

namespace GenericUtility {

/**
 * Nbv{[h.
 */
class CClipboard : boost::noncopyable
{
public:
	CClipboard();
	~CClipboard();

	/**
	 * Nbv{[hJ.
	 */
	bool Open(bool bEmpty, CWnd* pWnd = NULL);
	/**
	 * Nbv{[h.
	 */
	void Close();

	/**
	 * ݐݒ肳Ăf[^̃tH[}bg擾.
	 * @see ::EnumClipboardFormats()
	 */
	std::vector<UINT> EnumFormats() const;
	/**
	 * ݐݒ肳Ăf[^ɑ΂āA擾łŏ̃tH[}bg擾.
	 * @see ::GetPriorityClipboardFormat()
	 */
	boost::optional<UINT> GetPriorityFormat(const UINT *paFormatPriorityList, int cFormats);

	/**
	 * w肵` HGLOBAL f[^擾.
	 */
	CGlobalLockPtr GetGlobalMemoryData(UINT uFormat) const;

	/**
	 * rbg}bvf[^ݒ肷.
	 * I[vƂɋɂĂȂ΂ȂȂ.
	 *  bitmap ͖ɂȂ.
	 */
	bool SetBitmapData(CBitmap& bitmap);

	/**
	 * eLXgf[^ݒ肷.
	 * I[vƂɋɂĂȂ΂ȂȂ.
	 */
	bool SetTextData(LPCTSTR lpszText);
	/**
	 * eLXgf[^擾.
	 */
	CString GetTextData() const;

	/**
	 * t@C CF_HDROP ƂĐݒ肷.
	 */
	bool SetFileNameData(const std::vector<CString>& fileNames) const;
	/**
	 * CF_HDROP ɑ΂āAׂẴt@C擾.
	 */
	std::vector<CString> GetFileNameData() const;

public:
	// utility
	/**
	 * rbg}bvf[^Nbv{[hɃRs[.
	 */
	static bool SetBitmap(CBitmap& bitmap, CWnd* pWnd = NULL);
	/**
	 * eLXgf[^Nbv{[hɃRs[.
	 */
	static bool SetText(LPCTSTR lpszText, CWnd* pWnd = NULL);
	/**
	 * eLXgf[^Nbv{[h擾.
	 * eLXgf[^^CvłȂꍇ́AKɃeLXgɕϊĎ擾.
	 * @param[in] retry I[ṽgC (WM_DRAWCLIPBOARD ɔƂA҂ȂƎs邱Ƃ)
	 */
	static CString GetText(CWnd* pWnd = NULL, size_t retry = 0);

	/**
	 * t@C CF_HDROP ƂĐݒ肷.
	 */
	static bool SetFileNames(const std::vector<CString>& fileNames, CWnd* pWnd = NULL);

private:
	/// Nbv{[hI[vĂ邩ǂ
	BOOL m_bOpen;
};

////////////////////////////////////////////////////////////////////////////////

/**
 * Nbv{[h`FC.
 * RXgN^Őݒ肵AfXgN^ŉ.
 * WM_CHANGECBCHAIN nh OnChangeCbChain() Ăяo.
 * Nbv{[hύXꂽ WM_DRAWCLIPBOARD .
 */
class CClipboardChain
{
public:
	CClipboardChain(CWnd* pWnd);
	~CClipboardChain();

	/**
	 * WM_DRAWCLIPBOARD ŁAsɌĂяo.
	 * (̃nhĂяo)
	 */
	void OnDrawClipboard();

	/**
	 * WM_CHANGECBCHAIN nhĂяo.
	 */
	void OnChangeCbChain(HWND hWndRemove, HWND hWndAfter);

private:
	/// Nbv{[hr[Aݒ肷EBhEnh
	CWnd* m_pWnd;
	/// Nbv{[hr[A`FC̎̃Gg
	HWND m_hNextCBChain;
};

}	// namespace GenericUtility
