
// ListPasteDlg.h : wb_[ t@C
//

#pragma once

/// ɒxs𗘗p
//#define LISTPASTEDLG_DELAYEDEXECUTION

#include "../GenericLib/Clipboard.h"
#ifdef LISTPASTEDLG_DELAYEDEXECUTION
#include "../GenericLib/DelayedExecutionDialog.h"
#endif	// #ifdef LISTPASTEDLG_DELAYEDEXECUTION
#include "../GenericLib/DialogPositionSaver.h"
#include "../GenericLib/DlgWithToolTip.h"
#include "../GenericLib/HighlightWindow.h"
#include "../GenericLib/ImeControl.h"
#include "../GenericLib/NCSimulateDialog.h"
#include "../GenericLib/ResizableDialog.h"
#include "../GenericLib/ShellContextMenu.h"

#include "ListPasteDoc.h"
#include "SystemSettings.h"

typedef
#ifdef LISTPASTEDLG_DELAYEDEXECUTION
	Dialog::CDlgWithToolTip<
		Dialog::CDelayedExecutionDialog<
			Dialog::CNCSimulateDialog<
				Dialog::CResizableDialog<CDialog, FALSE, FALSE, Dialog::CResizeGripper>,
				HTCAPTION>>>
#else	// #ifdef LISTPASTEDLG_DELAYEDEXECUTION
	Dialog::CDlgWithToolTip<
		Dialog::CNCSimulateDialog<
			Dialog::CResizableDialog<CDialog, FALSE, FALSE, Dialog::CResizeGripper>,
			HTCAPTION>>
#endif	// #ifdef LISTPASTEDLG_DELAYEDEXECUTION
	CListPasteDlgBase;

// CListPasteDlg _CAO
/**
 * ListPaste C_CAO.
 */
class CListPasteDlg : public CListPasteDlgBase
{
// RXgNV
public:
	CListPasteDlg(CWnd* pParent = NULL);	// WRXgN^

// _CAO f[^
	enum { IDD = IDD_LISTPASTE_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV T|[g
	virtual BOOL PreTranslateMessage(MSG* pMsg);

// 
protected:
	HICON m_hIcon;

	// ꂽAbZ[W蓖Ċ֐
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnClose();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg BOOL OnQueryEndSession();
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg LRESULT OnKickIdle(WPARAM wParam, LPARAM lParam);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnDrawClipboard();
	afx_msg void OnChangeCbChain(HWND hWndRemove, HWND hWndAfter);
	afx_msg void OnCbnSelchangeComboGroup();
	afx_msg void OnBnClickedButtonGroup();
	afx_msg void OnEnChangeEdtSearch();
	afx_msg void OnEnSetFocusEdtSearch();
	afx_msg void OnEnKillFocusEdtSearch();
	afx_msg void OnBnClickedChkMatchFirst();
	afx_msg void OnNMDblclkListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRclickListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnBegindragListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnBeginrdragListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnKeyDownListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnEndLabelEditListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnGetdispinfoListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnOdFindItemListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnItemChangedListTexts(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg LRESULT OnCompleteAsyncSearch(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()

private:
	/**
	 * @see CResizableDialog::OnInitializeDialogSizeHelper().
	 */
	virtual void OnInitializeDialogSizeHelper(DialogUtility::CDialogSizeHelper& dsh);

	/**
	 * O[vR{{bNXXV.
	 */
	void UpdateGroupCombo();

	/**
	 * ݂̃Xg̑IԂɏ]āARs[.
	 * (XgNbv{[hւ̃Rs[)
	 */
	void DoCopy();
	/**
	 * ݂̃Xg̑IԂɏ]āAy[Xg.
	 * (Nbv{[h烊Xgւ̃Rs[)
	 */
	void DoPaste();
	/**
	 * ݂̃Xg̑IԂɏ]āA폜.
	 */
	void DoDelete();

	/**
	 * Data Manager  Undo  (obNAbvƓւ).
	 *  Undo obt@͈Ȃ̂ŁARedo ͕sv (x Undo  Redo).
	 */
	void DoUndo();

	/**
	 * XĝׂĂ̍ڂI.
	 */
	void SelectAllItems();
	/**
	 * XĝׂĂ̑I.
	 */
	void UnselectAllItems();
	/**
	 * XgőIĂ鍀ڂ̃f[^CfbNXۑ.
	 */
	void SaveSelectedIndices();
	/**
	 * ۑĂf[^CfbNXAXg̑IԂ𕜌.
	 */
	void RestoreSelectedIndices();
	/**
	 * ۑĂf[^CfbNXNA.
	 */
	void ClearSelectedIndices();

	/**
	 * ݂̌ɏ]Č.
	 * (^C}[ݒ肷. ۂ̏ UpdateSearchFunc() ōs)
	 * Iׂ͂ĉ.
	 * @param[in] saveSelectedIndices OɁAݑIĂ郊Xgڂ̃f[^CfbNXۑ
	 */
	void UpdateSearch(bool saveSelectedIndices);
	/**
	 * ݂̌ɏ]Č.
	 * Iׂ͂ĉ.
	 */
	void UpdateSearchFunc();

	/**
	 * 񓯊̊R[obN֐.
	 * ʃXbhĂ΂.
	 * WM_COMPLETE_ASYNC_SEARCH |Xg (OnCompleteAsyncSearch() Ăяo).
	 * @param[in] cancelled LZꂽǂ.
	 */
	void OnCompleteAsyncNotifyFunc(bool cancelled);
	/**
	 * 񓯊̏s.
	 * OnCompleteAsyncSearch() Ăяo.
	 * @param[in] cancelled LZꂽǂ.
	 */
	void CompleteAsyncSearch(bool cancelled);

	/**
	 * Xgĕ`悷.
	 * @param[in] unselectAll            I
	 * @param[in] forceInvalidate        Kĕ`悷
	 * @param[in] restoreSelectedIndices ȑOIĂf[^CfbNXۑĂ΁AXg̑IԂ𕜌
	 */
	void RedrawTextList(bool unselectAll, bool forceInvalidate, bool restoreSelectedIndices);

	/**
	 * TopMost ݒKp.
	 */
	void SetupTopMost();
	/**
	 * WatchClipboard ݒKp.
	 */
	void SetupWatchClipboard();

	/**
	 * IvV_CAO\.
	 */
	void ShowOptionDlg();

private:
	/// "O[v" X^eBbNRg[
	CStatic m_stcGroup;
	/// O[vR{{bNX
	CComboBox m_cmbGroup;
	/// "" X^eBbNRg[
	CStatic m_stcSearch;
	/// GfBbgRg[
	CEdit m_edtSearch;
	/// ΏۃeLXgXgRg[
	CListCtrl m_listTexts;

	/// XgőIĂ邷ׂẴACẽf[^CfbNX (Xg̃CfbNXł͂Ȃ)
	/// (ʂςɁAf[^IȂ߂̂)
	std::vector<size_t> m_selectedDataIndices;
	/// XgvOŕύXǂ
	/// (UI ŕύXꂽ m_selectedDataIndices NA邪AvOɂύX̓NAȂ)
	GenericUtility::CFlag m_changingListByProgram;

	/// ListPaste hLg
	CListPasteDoc m_doc;

	/**
	 * hLgɐݒ肷邽߂̃XgRg[C^[tF[X̎.
	 */
	class CList : public CListPasteDoc::IList
	{
	public:
		CList() : m_list(NULL)
		{
		}

		void Initialize(CListCtrl* list)
		{
			m_list = list;
		}

		UINT GetSelectedCount() const
		{
			ASSERT(m_list);
			return m_list->GetSelectedCount();
		}
		POSITION GetFirstSelectedItemPosition() const
		{
			ASSERT(m_list);
			return m_list->GetFirstSelectedItemPosition();
		}
		int GetNextSelectedItem(POSITION& pos) const
		{
			ASSERT(m_list);
			return m_list->GetNextSelectedItem(pos);
		}

	private:
		CListCtrl* m_list;
	} m_list;

	/// ReLXgj[
	GenericUtility::CShellContextMenu m_contextMenu;

	////////////////////////////////////////////////////////////////////////////////
	// IvVݒ

	/// GfBbgRg[ IME Rg[
	boost::shared_ptr<GenericUtility::CImeControl> m_ImeControl;

	/// Nbv{[hr[A`FC
	boost::shared_ptr<GenericUtility::CClipboardChain> m_clipboardChain;

	////////////////////////////////////////////////////////////////////////////////
private:
	/**
	 * \(+ k\)[h.
	 */
	enum ETransparentMode {
		/// s (ʏ\)
		TM_None = 0x00,
		/// \̂ݔ
		TM_Display = 0x01,
		/// bZ[W𓧉߂
		TM_Message = 0x02,
		/// k\ (^Cgo[݂̂̊ȈՕ\)
		TM_Shrink = 0x04,

		TM_All = ~0,
	};

	/**
	 * \(+ k\).
	 */
	void InitTransparent();
	/**
	 * \(+ k\)ݒ肷.
	 */
	void SetTransparent(unsigned long /* ETransparentMode */ mode);

	/**
	 * ANeBu (邢̓}EXJ[\_CAOɂ) ǂ𒲂ׂāA\(+ k\)XV.
	 */
	void UpdateTransparent();
	/**
	 * \(+ k\)XV^C}[ݒ肷.
	 */
	void StartUpdateTransparent();
	/**
	 * \(+ k\)XV^C}[.
	 */
	void StopUpdateTransparent();

private:
	/// ݂̔\(+ k\)[h
	unsigned long /* ETransparentMode */ m_transparentMode;

	/// TM_Shrink  on ɂȂÕEBhEʒu
	/// TM_Shrink  off ɂƂɂ̈ʒuɖ߂
	DialogUtility::CDialogPositionSaver m_NormalDisplayPos;

	////////////////////////////////////////////////////////////////////////////////
	// Shift + Xg̕hbO
private:
	/**
	 * ڂhbOƂ̏s.
	 * OnLvnBegindragListTexts(), OnLvnBeginrdragListTexts() Ă΂.
	 */
	void OnBeginDragListTexts(NMHDR *pNMHDR, LRESULT *pResult, bool bLeftButton);

	/**
	 * }EXJ[\ʒuɂEBhE擾.
	 */
	CWnd* GetWindowFromPoint(CPoint pntCient);

	/**
	 * ΏۃEBhEɕ𑗂.
	 */
	void SendText(CPoint point);

	/**
	 * }EXLv`[I.
	 */
	void EndCapture();

private:
	/**
	 * }EXLv`[̏.
	 */
	enum ECaptureStatus {
		/// 
		ECS_None       = 0x00,
		/// Lv`[
		ECS_Capturing  = 0x01,
		/// {^
		ECS_LeftButton = 0x02,
	};
	/// }EXLv`[
	/// (XgeLXghbOhbvǂ)
	unsigned long /* ECaptureStatus */ m_nCaptureStatus;
	/// hbÕeLXg
	CString m_strDragText;
	/// hbOJñJ[\
	HCURSOR m_hDragCursor;
	/// EBhEnCCg
	DialogUtility::CHighlightWindow m_HighlightWindow;

private:
	/// _CAOʒu.
	DialogUtility::CDialogPositionSaver m_DialogPosition;
	/// Xg̃tHg.
	DialogUtility::CWndFontSaver m_ListFont;

	////////////////////////////////////////////////////////////////////////////////
private:
	/**
	 * ݒt@C.
	 * @param[in] forceDocument hLgɕύXȂĂhLg
	 */
	bool Save(bool forceDocument = false);
	/**
	 * ݒt@Cǂݍ.
	 */
	bool Load();

private:
	friend class boost::serialization::access;
	template<class Archive>
	void serialize(Archive& ar, const unsigned int version)
	{
		using boost::serialization::make_nvp;

		// HACK: System Settings ň
		ar & make_nvp("Settings", CSystemSettings::Instance());

		ar & make_nvp("DialogPosition", m_DialogPosition);
		ar & make_nvp("ListFont", m_ListFont);
	}
};
