#pragma once

#include "../GenericLib/CriticalSection.h"
#include "../GenericLib/WorkerThreadPool.h"

#include "../ListPasteLib/DataManager.h"

/**
 * ListPaste hLg.
 */
class CListPasteDoc
{
public:
	CListPasteDoc();
	~CListPasteDoc();

	/**
	 * XgRg[C^[tF[X.
	 */
	interface IList
	{
		virtual UINT GetSelectedCount() const = 0;
		virtual POSITION GetFirstSelectedItemPosition() const = 0;
		virtual int GetNextSelectedItem(POSITION& pos) const = 0;
	};

	/**
	 * .
	 */
	void Initialize(IList* list, CWnd* pWnd);

	////////////////////////////////////////////////////////////////////////////////
public:
	/**
	 * f[^O[v擾.
	 */
	size_t GetGroupCount() const;

	/**
	 * ݂̃f[^O[vݒ肷.
	 * @note 񓯊ȂLZ.
	 */
	bool SetCurrentGroup(size_t index);
	/**
	 * ݂̃f[^O[v擾.
	 */
	size_t GetCurrentGroupIndex() const;

	/**
	 * index Ԗڂ̃f[^O[v擾.
	 */
	CString GetGroupName(size_t index);
	/**
	 * index Ԗڂ̃f[^O[vݒ肷.
	 */
	bool SetGroupName(size_t index, const CString& strName);

	typedef std::vector<size_t> IndexVec;
	/**
	 * O[vwʒuɒǉ.
	 * @note 񓯊ȂLZ.
	 * @param[in] index ǉʒu (~0 : )
	 */
	bool AddGroup(size_t index, const CString& strName);
	/**
	 * ̃O[vړ.
	 * @note 񓯊ȂLZ.
	 */
	bool MoveGroups(const IndexVec& indices, INT_PTR move);
	/**
	 * index Ԗڂ̃O[v폜.
	 * @note 񓯊ȂLZ.
	 */
	bool DeleteGroup(size_t index);

private:
	/**
	 * ݂̃f[^O[v擾.
	 */
	const ListPasteLib::CDataGroup& GetCurrentGroup() const;
	/**
	 * ݂̃f[^O[v擾.
	 */
	ListPasteLib::CDataGroup& GetCurrentGroup();

	/**
	 * w肵O̍ŏ̃O[v擾.
	 * ȂΒǉ.
	 */
	ListPasteLib::CDataGroup& FindOrCreateGroupByName(const CString& strName);

	////////////////////////////////////////////////////////////////////////////////
public:
	/**
	 * ătB^O.
	 * @note 񓯊ȂLZ.
	 */
	void Search();
	/**
	 * tB^OʁA擾.
	 * @note 񓯊́AłɌÎԂ (㑝\)
	 */
	size_t GetSearchedCount() const;

	/// 񓯊̊m点R[obN
	typedef boost::function<void(bool /* LZꂽǂ */)> SearchAsyncNotifyFunc;
	/**
	 * 񓯊ŌEtB^OȂ.
	 * @param[in] func 񓯊̊m点R[obN (ʃXbhs)
	 * @return łɊĂ邩ǂ (łɊĂꍇAnotify func ͌Ă΂Ȃ)
	 * @note 񓯊ȂAݎŝ̂LZĐVɎs.
	 */
	bool SearchAsync(const SearchAsyncNotifyFunc& func);
	/**
	 * 񓯊ǂ擾.
	 */
	bool IsSearching() const;
#if 0
	/**
	 * 񓯊̃vOX擾.
	 * @return [0, GetCurrentTextCount())
	 */
	size_t GetAsyncSearchProgress() const;
#endif

	/**
	 * eLXg擾.
	 * @param[in] item Xg̃CfbNX.
	 */
	const std::wstring& GetText(int item) const;
	/**
	 * eLXgύX.
	 * @note 񓯊ȂLZ.
	 * @param[in] item Xg̃CfbNX.
	 */
	bool Modify(int item, const std::wstring& text);

	/**
	 * IĂACe擾.
	 */
	UINT GetSelectedCount() const;

	/**
	 * ݂̃Xg̑IԂɏ]āARs[.
	 * (XgNbv{[hւ̃Rs[)
	 */
	void Copy();
	/**
	 * ݂̃Xg̑IԂɏ]āAy[Xg.
	 * (Nbv{[h烊Xgւ̃Rs[)
	 * @note 񓯊ȂLZ.
	 */
	bool Paste();
	/**
	 * ݂̃Xg̑IԂɏ]āA폜.
	 * @note 񓯊ȂLZ.
	 */
	void Delete();
	/**
	 * Nbv{[h̓eXgɃRs[.
	 * (Paste() ɎĂ邪ANbv{[hĎ̓ꏈs)
	 * @param[out] currentGroupUpdated JgO[vXVꂽǂ
	 * @note 񓯊ȂLZ.
	 */
	bool PasteOnDrawClipboard(bool& currentGroupUpdated);

	/**
	 * obNAbv ID.
	 */
	enum EBackUpID
	{
		/// Undo p
		BU_Undo,
		/// XibvVbgp
		BU_Snapshot,

		BU_Size,
	};
	/**
	 * ݂ Data Manager ̃obNAbv.
	 */
	void BackUp(EBackUpID id = BU_Undo);
	/**
	 * obNAbvNA.
	 */
	void ClearBackUp(EBackUpID id = BU_Undo);
	/**
	 * obNAbvւ.
	 */
	void SwapBackUp(EBackUpID id1 = BU_Undo, EBackUpID id2 = BU_Snapshot);
	/**
	 * Data Manager  Undo  (obNAbvƓւ).
	 *  Undo obt@͈Ȃ̂ŁARedo ͕sv (x Undo  Redo).
	 * @note 񓯊ȂLZ.
	 */
	bool Undo(EBackUpID id = BU_Undo);
	/**
	 * Undo ł邩ǂ擾.
	 */
	bool CanUndo(EBackUpID id = BU_Undo) const;

	/**
	 * XgőIĂ邷ׂẴeLXg擾.
	 */
	std::vector<CString> GetSelectedTextVec() const;
	/**
	 * XgőIĂ邷ׂẴeLXg擾.
	 * IĂAsŋ؂.
	 */
	CString GetSelectedTexts() const;

	/**
	 * ݂̃f[^O[ṽeLXg擾.
	 */
	const ListPasteLib::CDataGroup::WStrings& GetCurrentTexts() const;
	/**
	 * ݂̃f[^O[ṽeLXg擾.
	 */
	size_t GetCurrentTextCount() const;

	/**
	 * Xgɕ\ĂeLXg.
	 * (擪}b`̂)
	 * @param[in] lpszStr 
	 * @param[in] start   Xg̊JnCfbNX
	 * @param[in] end     Xg̏ICfbNX (܂܂Ȃ; -1 ͍Ō܂)
	 */
	int FindItem(LPCWSTR lpszStr, int start = 0, int end = -1) const;

	/**
	 * m_dataManager ɂCfbNXAXg̃CfbNXɕϊ.
	 * ln(ACe) ̃I[_[̎Ԃ.
	 * @retval >=0 Xg̃CfbNX
	 * @retval -1  index ͌ʂɊ܂܂ĂȂAindex 傫̂܂܂Ă
	 * @retval -2  index ͌ʂɊ܂܂Ă炸A܂ index 傫̂܂܂ĂȂ
	 */
	int DataIndex2Item(size_t index) const;

	/**
	 * XgőIĂ邷ׂẴACéAm_dataManager ɂCfbNX擾.
	 */
	ListPasteLib::CDataGroup::IndexVec GetAllSelectedDataIndices() const;

	////////////////////////////////////////////////////////////////////////////////
private:
	/**
	 * 񓯊Jn.
	 */
	bool BeginAsyncSearch(const SearchAsyncNotifyFunc& func);
	/**
	 * 񓯊LZ.
	 */
	bool CancelAsyncSearch();

	/**
	 * XgőIĂŏ̃ACe擾.
	 */
	int GetSelectedItem() const;

	/**
	 * Xg̃CfbNXAm_dataManager ɂCfbNXɕϊ.
	 * @return ŶȂ ~0
	 */
	size_t Item2DataIndex(int item) const;

	/**
	 * XgőIĂŏ̃ACéAm_dataManager ɂCfbNX擾.
	 * @return IĂȂ ~0
	 */
	size_t GetSelectedDataIndex() const;

	/**
	 * Nbv{[h̃eLXgAsŕĎ擾.
	 * @param[in] maxTexts 擾ős (0: wȂ)
	 * @param[in] retry    gC (0: gCȂ)
	 */
	std::vector<std::wstring> GetTextsFromClipboard(size_t maxTexts = 0, size_t retry = 0);

private:
	/// XgRg[C^[tF[X
	IList* m_list;
	/// Nbv{[hANZXpEBhE
	CWnd* m_pWnd;

	/// f[^}l[W
	ListPasteLib::CDataManagerPtr m_dataManager;
	/// f[^}l[W (obNAbv)
	ListPasteLib::CDataManagerPtr m_dataManagerBak[BU_Size];
	/// ׂĕ\邩ǂ
	bool m_bShowAll;
	/// \Ώۃf[^CfbNX
	/// @note ANZXƂ́Am_csAsyncSearch bNKv
	ListPasteLib::CDataGroup::IndexVec m_dataIndices;
	/// 񓯊pNeBJZNV
	mutable GenericUtility::CCriticalSection m_csAsyncSearch;

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * 񓯊Wu.
	 */
	class CAsyncSearchJob : public GenericUtility::CWorkerThreadPool::IJob
	{
	public:
		CAsyncSearchJob(
			int nGroupID,
			ListPasteLib::CDataGroup::IndexVec& dataIndices,
			GenericUtility::CCriticalSection& csAsyncSearch);
		virtual ~CAsyncSearchJob();

		/**
		 * 񓯊Jn̂߂ɃZbgAbv.
		 * ̌A[J[Xbhv[ɓo^.
		 */
		void BeginAsyncSearch(
			ListPasteLib::CDataGroup* pDataGroup,
			const std::wstring& search, bool matchFirst,
			const SearchAsyncNotifyFunc& searchAsyncNotifyFunc);

		/**
		 * 񓯊ǂ擾.
		 */
		bool IsSearching() const;

		/**
		 * 񓯊̃LZtO𗧂Ă.
		 * ̌A҂Ă EndCancel() Ă.
		 */
		void BeginCancel();
		/**
		 * 񓯊̃LZ.
		 */
		void EndCancel();

	public:
		// IJob
		virtual bool Execute();
		virtual int GetGroupID();

	private:
		int m_nGroupID;

		// HACK: CListPasteDoc ̃oƓ (ςȂƑz肵Ă)
		/// \Ώۃf[^CfbNX
		/// 񓯊ł́AɒǉĂ
		/// @note ANZXƂ́Am_csAsyncSearch bNKv
		ListPasteLib::CDataGroup::IndexVec& m_dataIndices;
		/// 񓯊pNeBJZNV
		mutable GenericUtility::CCriticalSection& m_cs;

		/// Ώۃf[^O[v
		ListPasteLib::CDataGroup* m_pDataGroup;

		// HACK: Execute() ͕ʃXbhŎŝŁA̓CXbh̕ŎoĊoĂKv.
		/// 
		std::wstring m_search;
		/// eLXg̐擪Ƀ}b`邩ǂ
		bool m_matchFirst;

		/// 񓯊ǂ
		volatile bool m_bIsSearching;
		/// 񓯊LZ (CancelAsyncSearch() Őݒ肵āAAsyncSearchFunc() ŎQƂ)
		volatile bool m_bCancel;
		/// 񓯊̊m点R[obN
		SearchAsyncNotifyFunc m_notifyFunc;
	};
	typedef boost::shared_ptr<CAsyncSearchJob> CAsyncSearchJobPtr;
	/// 񓯊Wu
	/// (ɎsWu͈Ȃ̂ŁACX^Xł悢)
	CAsyncSearchJobPtr m_asyncSearchJob;

	// HACK: Xbhv[ CAsyncSearchJob ̒ɓ CAsyncSearchJob::Start(), CAsyncSearchJob::Cancel() ȂǂƂ
	// HACK: 肷邩ȂAꎞIɂXbhv[ƃWuƂ̊ԂŏzQƂ`̂ŁAƂ肠Ă

	typedef boost::scoped_ptr<GenericUtility::CWorkerThreadPool> CWorkerThreadPoolPtr;
	/// Xbhv[
	CWorkerThreadPoolPtr m_threadPool;

	////////////////////////////////////////////////////////////////////////////////
public:
	/**
	 * Data Manager ̓e.
	 * @param[in] force ύXȂĂ
	 */
	bool Save(bool force);
	/**
	 * Data Manager ̓eǂݍ.
	 */
	bool Load();
};
