/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.BitInputStream;

public class ByteOrderInputStream
extends BitInputStream
implements DataInput {
    protected boolean little;

    public ByteOrderInputStream(InputStream in) {
        this(in, false);
    }

    public ByteOrderInputStream(InputStream in, boolean littleEndian) {
        super(in);
        this.little = littleEndian;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public int skipBytes(int n) throws IOException {
        int total = 0;
        int cur = 0;
        while (total < n && (cur = (int)this.skip(n - total)) > 0) {
            total += cur;
        }
        return total;
    }

    public boolean readBoolean() throws IOException {
        int b = this.readUnsignedByte();
        return b != 0;
    }

    public char readChar() throws IOException {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        return this.little ? (char)((b1 << 8) + b2) : (char)((b2 << 8) + b1);
    }

    public byte readByte() throws IOException {
        this.byteAlign();
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public byte[] readByte(int n) throws IOException {
        this.byteAlign();
        byte[] bytes = new byte[n];
        int i = 0;
        while (i < n) {
            int b = this.read();
            if (b < 0) {
                throw new EOFException();
            }
            bytes[i] = (byte)b;
            ++i;
        }
        return bytes;
    }

    public int readUnsignedByte() throws IOException {
        this.byteAlign();
        int ub = this.read();
        if (ub < 0) {
            throw new EOFException();
        }
        return ub;
    }

    public int[] readUnsignedByte(int n) throws IOException {
        this.byteAlign();
        int[] bytes = new int[n];
        int i = 0;
        while (i < n) {
            int ub = this.read();
            if (ub < 0) {
                throw new EOFException();
            }
            bytes[i] = ub;
            ++i;
        }
        return bytes;
    }

    public short readShort() throws IOException {
        int i1 = this.readUnsignedByte();
        int i2 = this.readUnsignedByte();
        return this.little ? (short)((i2 << 8) + i1) : (short)((i1 << 8) + i2);
    }

    public short[] readShort(int n) throws IOException {
        short[] shorts = new short[n];
        int i = 0;
        while (i < n) {
            shorts[i] = this.readShort();
            ++i;
        }
        return shorts;
    }

    public int readUnsignedShort() throws IOException {
        this.byteAlign();
        int i1 = this.readUnsignedByte();
        int i2 = this.readUnsignedByte();
        return this.little ? (i2 << 8) + i1 : (i1 << 8) + i2;
    }

    public int[] readUnsignedShort(int n) throws IOException {
        int[] shorts = new int[n];
        int i = 0;
        while (i < n) {
            shorts[i] = this.readUnsignedShort();
            ++i;
        }
        return shorts;
    }

    public int readInt() throws IOException {
        int i1 = this.readUnsignedByte();
        int i2 = this.readUnsignedByte();
        int i3 = this.readUnsignedByte();
        int i4 = this.readUnsignedByte();
        return this.little ? (i4 << 24) + (i3 << 16) + (i2 << 8) + i1 : (i1 << 24) + (i2 << 16) + (i3 << 8) + i4;
    }

    public int[] readInt(int n) throws IOException {
        int[] ints = new int[n];
        int i = 0;
        while (i < n) {
            ints[i] = this.readInt();
            ++i;
        }
        return ints;
    }

    public long readUnsignedInt() throws IOException {
        long i1 = this.readUnsignedByte();
        long i2 = this.readUnsignedByte();
        long i3 = this.readUnsignedByte();
        long i4 = this.readUnsignedByte();
        return this.little ? (i4 << 24) + (i3 << 16) + (i2 << 8) + i1 : (i1 << 24) + (i2 << 16) + (i3 << 8) + i4;
    }

    public long[] readUnsignedInt(int n) throws IOException {
        long[] ints = new long[n];
        int i = 0;
        while (i < n) {
            ints[i] = this.readUnsignedInt();
            ++i;
        }
        return ints;
    }

    public long readLong() throws IOException {
        long i1 = this.readInt();
        long i2 = this.readInt();
        return this.little ? (i2 << 32) + (i1 & 0xFFFFFFFFL) : (i1 << 32) + (i2 & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new IOException("ByteOrderInputStream.readLine() is deprecated and not implemented.");
    }

    public String readString() throws IOException {
        return this.readUTF();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readAsciiZString() throws IOException {
        StringBuffer buffer = new StringBuffer();
        char c = (char)this.readUnsignedByte();
        while (c != '\u0000') {
            buffer.append(c);
            c = (char)this.readUnsignedByte();
        }
        return buffer.toString();
    }
}

