/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.freehep.util.io.BitOutputStream;

public class ByteOrderOutputStream
extends BitOutputStream
implements DataOutput {
    protected boolean little;
    protected int written;

    public ByteOrderOutputStream(OutputStream out) {
        this(out, false);
    }

    public ByteOrderOutputStream(OutputStream out, boolean littleEndian) {
        super(out);
        this.little = littleEndian;
        this.written = 0;
    }

    public int size() throws IOException {
        return this.written;
    }

    public synchronized void write(int b) throws IOException {
        super.write(b);
        ++this.written;
    }

    public void writeBoolean(boolean b) throws IOException {
        if (b) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeChar(int c) throws IOException {
        if (this.little) {
            this.write(c & 0xFF);
            this.write(c >>> 8 & 0xFF);
        } else {
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
        }
    }

    public void writeByte(int b) throws IOException {
        this.byteAlign();
        this.write(b);
    }

    public void writeByte(byte[] bytes) throws IOException {
        this.byteAlign();
        int i = 0;
        while (i < bytes.length) {
            this.write(bytes[i]);
            ++i;
        }
    }

    public void writeUnsignedByte(int ub) throws IOException {
        this.byteAlign();
        this.write(ub);
    }

    public void writeUnsignedByte(int[] bytes) throws IOException {
        this.byteAlign();
        int i = 0;
        while (i < bytes.length) {
            this.write(bytes[i]);
            ++i;
        }
    }

    public void writeShort(int s) throws IOException {
        this.byteAlign();
        if (this.little) {
            this.write(s & 0xFF);
            this.write(s >>> 8 & 0xFF);
        } else {
            this.write(s >>> 8 & 0xFF);
            this.write(s & 0xFF);
        }
    }

    public void writeShort(short[] shorts) throws IOException {
        int i = 0;
        while (i < shorts.length) {
            this.writeShort(shorts[i]);
            ++i;
        }
    }

    public void writeUnsignedShort(int s) throws IOException {
        this.byteAlign();
        if (this.little) {
            this.write(s & 0xFF);
            this.write(s >>> 8 & 0xFF);
        } else {
            this.write(s >>> 8 & 0xFF);
            this.write(s & 0xFF);
        }
    }

    public void writeUnsignedShort(int[] shorts) throws IOException {
        int i = 0;
        while (i < shorts.length) {
            this.writeUnsignedShort(shorts[i]);
            ++i;
        }
    }

    public void writeInt(int i) throws IOException {
        if (this.little) {
            this.write(i & 0xFF);
            this.write(i >>> 8 & 0xFF);
            this.write(i >>> 16 & 0xFF);
            this.write(i >>> 24 & 0xFF);
        } else {
            this.write(i >>> 24 & 0xFF);
            this.write(i >>> 16 & 0xFF);
            this.write(i >>> 8 & 0xFF);
            this.write(i & 0xFF);
        }
    }

    public void writeInt(int[] ints) throws IOException {
        int i = 0;
        while (i < ints.length) {
            this.writeInt(ints[i]);
            ++i;
        }
    }

    public void writeUnsignedInt(long i) throws IOException {
        if (this.little) {
            this.write((int)(i & 0xFFL));
            this.write((int)(i >>> 8 & 0xFFL));
            this.write((int)(i >>> 16 & 0xFFL));
            this.write((int)(i >>> 24 & 0xFFL));
        } else {
            this.write((int)(i >>> 24 & 0xFFL));
            this.write((int)(i >>> 16 & 0xFFL));
            this.write((int)(i >>> 8 & 0xFFL));
            this.write((int)(i & 0xFFL));
        }
    }

    public void writeUnsignedInt(long[] ints) throws IOException {
        int i = 0;
        while (i < ints.length) {
            this.writeUnsignedInt(ints[i]);
            ++i;
        }
    }

    public void writeLong(long l) throws IOException {
        if (this.little) {
            this.write((int)(l & 0xFFL));
            this.write((int)(l >>> 8 & 0xFFL));
            this.write((int)(l >>> 16 & 0xFFL));
            this.write((int)(l >>> 24 & 0xFFL));
            this.write((int)(l >>> 32 & 0xFFL));
            this.write((int)(l >>> 40 & 0xFFL));
            this.write((int)(l >>> 48 & 0xFFL));
            this.write((int)(l >>> 56 & 0xFFL));
        } else {
            this.write((int)(l >>> 56 & 0xFFL));
            this.write((int)(l >>> 48 & 0xFFL));
            this.write((int)(l >>> 40 & 0xFFL));
            this.write((int)(l >>> 32 & 0xFFL));
            this.write((int)(l >>> 24 & 0xFFL));
            this.write((int)(l >>> 16 & 0xFFL));
            this.write((int)(l >>> 8 & 0xFFL));
            this.write((int)(l & 0xFFL));
        }
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.writeByte(s.charAt(i));
            ++i;
        }
    }

    public void writeChars(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.writeChar(s.charAt(i));
            ++i;
        }
    }

    public void writeString(String s) throws IOException {
        this.writeUTF(s);
    }

    public void writeUTF(String s) throws IOException {
        ByteOrderOutputStream.writeUTF(s, this);
    }

    public void writeAsciiZString(String s) throws IOException {
        this.writeBytes(s);
        this.writeByte(0);
    }

    public static void writeUTF(String s, DataOutput dos) throws IOException {
        char c;
        int strlen = s.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        s.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = charr[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        dos.write(bytearr);
    }
}

