/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Constants;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidTimeoutException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSuspensionNotSupportedException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractPlatformTransactionManager
implements PlatformTransactionManager,
Serializable {
    public static final int SYNCHRONIZATION_ALWAYS = 0;
    public static final int SYNCHRONIZATION_ON_ACTUAL_TRANSACTION = 1;
    public static final int SYNCHRONIZATION_NEVER = 2;
    private static final Constants constants = new Constants(class$org$springframework$transaction$support$AbstractPlatformTransactionManager == null ? (class$org$springframework$transaction$support$AbstractPlatformTransactionManager = AbstractPlatformTransactionManager.class$("org.springframework.transaction.support.AbstractPlatformTransactionManager")) : class$org$springframework$transaction$support$AbstractPlatformTransactionManager);
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private int transactionSynchronization = 0;
    private boolean nestedTransactionAllowed = false;
    private boolean globalRollbackOnParticipationFailure = true;
    private boolean rollbackOnCommitFailure = false;
    static /* synthetic */ Class class$org$springframework$transaction$support$AbstractPlatformTransactionManager;

    public void setTransactionSynchronizationName(String constantName) {
        this.setTransactionSynchronization(constants.asNumber(constantName).intValue());
    }

    public void setTransactionSynchronization(int transactionSynchronization) {
        this.transactionSynchronization = transactionSynchronization;
    }

    public int getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    public void setNestedTransactionAllowed(boolean nestedTransactionAllowed) {
        this.nestedTransactionAllowed = nestedTransactionAllowed;
    }

    public boolean isNestedTransactionAllowed() {
        return this.nestedTransactionAllowed;
    }

    public void setGlobalRollbackOnParticipationFailure(boolean globalRollbackOnParticipationFailure) {
        this.globalRollbackOnParticipationFailure = globalRollbackOnParticipationFailure;
    }

    public boolean isGlobalRollbackOnParticipationFailure() {
        return this.globalRollbackOnParticipationFailure;
    }

    public void setRollbackOnCommitFailure(boolean rollbackOnCommitFailure) {
        this.rollbackOnCommitFailure = rollbackOnCommitFailure;
    }

    public boolean isRollbackOnCommitFailure() {
        return this.rollbackOnCommitFailure;
    }

    public final TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        Object transaction = this.doGetTransaction();
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug((Object)("Using transaction object [" + transaction + "]"));
        }
        if (definition == null) {
            definition = new DefaultTransactionDefinition();
        }
        if (this.isExistingTransaction(transaction)) {
            return this.handleExistingTransaction(definition, transaction, debugEnabled);
        }
        if (definition.getTimeout() < -1) {
            throw new InvalidTimeoutException("Invalid transaction timeout", definition.getTimeout());
        }
        if (definition.getPropagationBehavior() == 2) {
            throw new IllegalTransactionStateException("Transaction propagation 'mandatory' but no existing transaction found");
        }
        if (definition.getPropagationBehavior() == 0 || definition.getPropagationBehavior() == 3 || definition.getPropagationBehavior() == 6) {
            if (debugEnabled) {
                this.logger.debug((Object)("Creating new transaction with name [" + definition.getName() + "]"));
            }
            this.doBegin(transaction, definition);
            boolean newSynchronization = this.transactionSynchronization != 2;
            return this.newTransactionStatus(definition, transaction, true, newSynchronization, debugEnabled, null);
        }
        boolean newSynchronization = this.transactionSynchronization == 0;
        return this.newTransactionStatus(definition, null, false, newSynchronization, debugEnabled, null);
    }

    private TransactionStatus handleExistingTransaction(TransactionDefinition definition, Object transaction, boolean debugEnabled) throws TransactionException {
        if (definition.getPropagationBehavior() == 5) {
            throw new IllegalTransactionStateException("Transaction propagation 'never' but existing transaction found");
        }
        if (definition.getPropagationBehavior() == 4) {
            if (debugEnabled) {
                this.logger.debug((Object)"Suspending current transaction");
            }
            SuspendedResourcesHolder suspendedResources = this.suspend(transaction);
            boolean newSynchronization = this.transactionSynchronization == 0;
            return this.newTransactionStatus(definition, null, false, newSynchronization, debugEnabled, suspendedResources);
        }
        if (definition.getPropagationBehavior() == 3) {
            if (debugEnabled) {
                this.logger.debug((Object)("Suspending current transaction, creating new transaction with name [" + definition.getName() + "]"));
            }
            SuspendedResourcesHolder suspendedResources = this.suspend(transaction);
            this.doBegin(transaction, definition);
            boolean newSynchronization = this.transactionSynchronization != 2;
            return this.newTransactionStatus(definition, transaction, true, newSynchronization, debugEnabled, suspendedResources);
        }
        if (definition.getPropagationBehavior() == 6) {
            if (!this.isNestedTransactionAllowed()) {
                throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions by default - specify 'nestedTransactionAllowed' property with value 'true'");
            }
            if (debugEnabled) {
                this.logger.debug((Object)("Creating nested transaction with name [" + definition.getName() + "]"));
            }
            if (this.useSavepointForNestedTransaction()) {
                DefaultTransactionStatus status = this.newTransactionStatus(definition, transaction, false, false, debugEnabled, null);
                status.createAndHoldSavepoint();
                return status;
            }
            this.doBegin(transaction, definition);
            boolean newSynchronization = this.transactionSynchronization != 2;
            return this.newTransactionStatus(definition, transaction, true, newSynchronization, debugEnabled, null);
        }
        if (debugEnabled) {
            this.logger.debug((Object)"Participating in existing transaction");
        }
        boolean newSynchronization = this.transactionSynchronization != 2;
        return this.newTransactionStatus(definition, transaction, false, newSynchronization, debugEnabled, null);
    }

    private DefaultTransactionStatus newTransactionStatus(TransactionDefinition definition, Object transaction, boolean newTransaction, boolean newSynchronization, boolean debug, Object suspendedResources) {
        boolean actualNewSynchronization;
        boolean bl = actualNewSynchronization = newSynchronization && !TransactionSynchronizationManager.isSynchronizationActive();
        if (actualNewSynchronization) {
            if (newTransaction) {
                TransactionSynchronizationManager.setActualTransactionActive(true);
            }
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(definition.isReadOnly());
            TransactionSynchronizationManager.setCurrentTransactionName(definition.getName());
            TransactionSynchronizationManager.initSynchronization();
        }
        return new DefaultTransactionStatus(transaction, newTransaction, actualNewSynchronization, definition.isReadOnly(), debug, suspendedResources);
    }

    private SuspendedResourcesHolder suspend(Object transaction) throws TransactionException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            List suspendedSynchronizations = TransactionSynchronizationManager.getSynchronizations();
            Iterator it = suspendedSynchronizations.iterator();
            while (it.hasNext()) {
                ((TransactionSynchronization)it.next()).suspend();
            }
            TransactionSynchronizationManager.clearSynchronization();
            String name = TransactionSynchronizationManager.getCurrentTransactionName();
            TransactionSynchronizationManager.setCurrentTransactionName(null);
            boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(false);
            TransactionSynchronizationManager.setActualTransactionActive(false);
            Object holder = this.doSuspend(transaction);
            return new SuspendedResourcesHolder(holder, suspendedSynchronizations, name, readOnly);
        }
        Object holder = this.doSuspend(transaction);
        return new SuspendedResourcesHolder(holder, null, null, false);
    }

    private void resume(Object transaction, SuspendedResourcesHolder resourcesHolder) throws TransactionException {
        this.doResume(transaction, resourcesHolder.getSuspendedResources());
        if (resourcesHolder.getSuspendedSynchronizations() != null) {
            TransactionSynchronizationManager.setActualTransactionActive(true);
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(resourcesHolder.isReadOnly());
            TransactionSynchronizationManager.setCurrentTransactionName(resourcesHolder.getName());
            TransactionSynchronizationManager.initSynchronization();
            Iterator it = resourcesHolder.getSuspendedSynchronizations().iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                synchronization.resume();
                TransactionSynchronizationManager.registerSynchronization(synchronization);
            }
        }
    }

    public final void commit(TransactionStatus status) throws TransactionException {
        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)status;
        if (defStatus.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        if (defStatus.isLocalRollbackOnly()) {
            if (defStatus.isDebug()) {
                this.logger.debug((Object)"Transactional code has requested rollback");
            }
            this.processRollback(defStatus);
            return;
        }
        if (!this.shouldCommitOnGlobalRollbackOnly() && defStatus.isGlobalRollbackOnly()) {
            if (defStatus.isDebug()) {
                this.logger.debug((Object)"Global transaction is marked as rollback-only but transactional code requested commit");
            }
            this.processRollback(defStatus);
            throw new UnexpectedRollbackException("Transaction has been rolled back because it has been marked as rollback-only");
        }
        this.processCommit(defStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommit(DefaultTransactionStatus status) throws TransactionException {
        try {
            boolean beforeCompletionInvoked = false;
            try {
                this.triggerBeforeCommit(status);
                this.triggerBeforeCompletion(status);
                beforeCompletionInvoked = true;
                if (status.hasSavepoint()) {
                    if (status.isDebug()) {
                        this.logger.debug((Object)"Releasing transaction savepoint");
                    }
                    status.releaseHeldSavepoint();
                } else if (status.isNewTransaction()) {
                    if (status.isDebug()) {
                        this.logger.debug((Object)"Initiating transaction commit");
                    }
                    boolean globalRollbackOnly = status.isGlobalRollbackOnly();
                    this.doCommit(status);
                    if (globalRollbackOnly) {
                        throw new UnexpectedRollbackException("Transaction has been silently rolled back because it has been marked as rollback-only");
                    }
                }
            }
            catch (UnexpectedRollbackException ex) {
                this.triggerAfterCompletion(status, 1);
                throw ex;
            }
            catch (TransactionException ex) {
                if (this.isRollbackOnCommitFailure()) {
                    this.doRollbackOnCommitException(status, ex);
                } else {
                    this.triggerAfterCompletion(status, 2);
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (!beforeCompletionInvoked) {
                    this.triggerBeforeCompletion(status);
                }
                this.doRollbackOnCommitException(status, ex);
                throw ex;
            }
            catch (Error err) {
                if (!beforeCompletionInvoked) {
                    this.triggerBeforeCompletion(status);
                }
                this.doRollbackOnCommitException(status, err);
                throw err;
            }
            this.triggerAfterCompletion(status, 0);
        }
        finally {
            this.cleanupAfterCompletion(status);
        }
    }

    public final void rollback(TransactionStatus status) throws TransactionException {
        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)status;
        if (defStatus.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        this.processRollback(defStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRollback(DefaultTransactionStatus status) {
        try {
            try {
                this.triggerBeforeCompletion(status);
                if (status.hasSavepoint()) {
                    if (status.isDebug()) {
                        this.logger.debug((Object)"Rolling back transaction to savepoint");
                    }
                    status.rollbackToHeldSavepoint();
                } else if (status.isNewTransaction()) {
                    if (status.isDebug()) {
                        this.logger.debug((Object)"Initiating transaction rollback");
                    }
                    this.doRollback(status);
                } else if (status.hasTransaction()) {
                    if (status.isLocalRollbackOnly() || this.isGlobalRollbackOnParticipationFailure()) {
                        if (status.isDebug()) {
                            this.logger.debug((Object)"Participating transaction failed - marking existing transaction as rollback-only");
                        }
                        this.doSetRollbackOnly(status);
                    } else if (status.isDebug()) {
                        this.logger.debug((Object)"Participating transaction failed - letting transaction originator decide on rollback");
                    }
                } else {
                    this.logger.warn((Object)"Should roll back transaction but cannot - no transaction available");
                }
            }
            catch (RuntimeException ex) {
                this.triggerAfterCompletion(status, 2);
                throw ex;
            }
            catch (Error err) {
                this.triggerAfterCompletion(status, 2);
                throw err;
            }
            this.triggerAfterCompletion(status, 1);
        }
        finally {
            this.cleanupAfterCompletion(status);
        }
    }

    private void doRollbackOnCommitException(DefaultTransactionStatus status, Throwable ex) throws TransactionException {
        try {
            if (status.isNewTransaction()) {
                if (status.isDebug()) {
                    this.logger.debug((Object)"Initiating transaction rollback on commit exception", ex);
                }
                this.doRollback(status);
            }
        }
        catch (RuntimeException rbex) {
            this.logger.error((Object)"Commit exception overridden by rollback exception", ex);
            this.triggerAfterCompletion(status, 2);
            throw rbex;
        }
        catch (Error rberr) {
            this.logger.error((Object)"Commit exception overridden by rollback exception", ex);
            this.triggerAfterCompletion(status, 2);
            throw rberr;
        }
        this.triggerAfterCompletion(status, 1);
    }

    private void triggerBeforeCommit(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            if (status.isDebug()) {
                this.logger.debug((Object)"Triggering beforeCommit synchronization");
            }
            Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                synchronization.beforeCommit(status.isReadOnly());
            }
        }
    }

    private void triggerBeforeCompletion(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            if (status.isDebug()) {
                this.logger.debug((Object)"Triggering beforeCompletion synchronization");
            }
            Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                try {
                    synchronization.beforeCompletion();
                }
                catch (Throwable tsex) {
                    this.logger.error((Object)"TransactionSynchronization.beforeCompletion threw exception", tsex);
                }
            }
        }
    }

    private void triggerAfterCompletion(DefaultTransactionStatus status, int completionStatus) {
        if (status.isNewSynchronization()) {
            List synchronizations = TransactionSynchronizationManager.getSynchronizations();
            if (!status.hasTransaction() || status.isNewTransaction()) {
                if (status.isDebug()) {
                    this.logger.debug((Object)"Triggering afterCompletion synchronization");
                }
                this.invokeAfterCompletion(synchronizations, completionStatus);
            } else {
                this.registerAfterCompletionWithExistingTransaction(status.getTransaction(), synchronizations);
            }
        }
    }

    protected final void invokeAfterCompletion(List synchronizations, int completionStatus) {
        Iterator it = synchronizations.iterator();
        while (it.hasNext()) {
            TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
            try {
                synchronization.afterCompletion(completionStatus);
            }
            catch (Throwable tsex) {
                this.logger.error((Object)"TransactionSynchronization.afterCompletion threw exception", tsex);
            }
        }
    }

    private void cleanupAfterCompletion(DefaultTransactionStatus status) {
        status.setCompleted();
        if (status.isNewSynchronization()) {
            TransactionSynchronizationManager.clearSynchronization();
            TransactionSynchronizationManager.setCurrentTransactionName(null);
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(false);
            if (status.isNewTransaction()) {
                TransactionSynchronizationManager.setActualTransactionActive(false);
            }
        }
        if (status.isNewTransaction()) {
            this.doCleanupAfterCompletion(status.getTransaction());
        }
        if (status.getSuspendedResources() != null) {
            if (status.isDebug()) {
                this.logger.debug((Object)"Resuming suspended transaction");
            }
            this.resume(status.getTransaction(), (SuspendedResourcesHolder)status.getSuspendedResources());
        }
    }

    protected abstract Object doGetTransaction() throws TransactionException;

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return false;
    }

    protected boolean useSavepointForNestedTransaction() {
        return true;
    }

    protected abstract void doBegin(Object var1, TransactionDefinition var2) throws TransactionException;

    protected Object doSuspend(Object transaction) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    protected void doResume(Object transaction, Object suspendedResources) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return false;
    }

    protected abstract void doCommit(DefaultTransactionStatus var1) throws TransactionException;

    protected abstract void doRollback(DefaultTransactionStatus var1) throws TransactionException;

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        throw new IllegalTransactionStateException("Participating in existing transactions is not supported - when 'isExistingTransaction' returns true, appropriate 'doSetRollbackOnly' behavior must be provided");
    }

    protected void registerAfterCompletionWithExistingTransaction(Object transaction, List synchronizations) throws TransactionException {
        this.logger.debug((Object)"Cannot register Spring after-completion synchronization with existing transaction - performing Spring after-completion callbacks immediately, with outcome status 'unknown'");
        this.invokeAfterCompletion(synchronizations, 2);
    }

    protected void doCleanupAfterCompletion(Object transaction) {
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        try {
            ois.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Failed to deserialize [" + this.getClass().getName() + "] - " + "check that Spring transaction libraries are available on the client side: " + ex.getMessage());
        }
        this.logger = LogFactory.getLog(this.getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SuspendedResourcesHolder {
        private final Object suspendedResources;
        private final List suspendedSynchronizations;
        private final String name;
        private final boolean readOnly;

        public SuspendedResourcesHolder(Object suspendedResources, List suspendedSynchronizations, String name, boolean readOnly) {
            this.suspendedResources = suspendedResources;
            this.suspendedSynchronizations = suspendedSynchronizations;
            this.name = name;
            this.readOnly = readOnly;
        }

        public Object getSuspendedResources() {
            return this.suspendedResources;
        }

        public List getSuspendedSynchronizations() {
            return this.suspendedSynchronizations;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }
}

