/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.parameter;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMapping;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class InlineParameterMapParser {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final String PARAMETER_TOKEN = "#";
    private static final String PARAM_DELIM = ":";
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$DomTypeMarker;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;

    public SqlText parseInlineParameterMap(TypeHandlerFactory typeHandlerFactory, String sqlStatement) {
        return this.parseInlineParameterMap(typeHandlerFactory, sqlStatement, null);
    }

    public SqlText parseInlineParameterMap(TypeHandlerFactory typeHandlerFactory, String sqlStatement, Class parameterClass) {
        String newSql = sqlStatement;
        ArrayList<ParameterMapping> mappingList = new ArrayList<ParameterMapping>();
        StringTokenizer parser = new StringTokenizer(sqlStatement, PARAMETER_TOKEN, true);
        StringBuffer newSqlBuffer = new StringBuffer();
        String token = null;
        String lastToken = null;
        while (parser.hasMoreTokens()) {
            token = parser.nextToken();
            if (PARAMETER_TOKEN.equals(lastToken)) {
                if (PARAMETER_TOKEN.equals(token)) {
                    newSqlBuffer.append(PARAMETER_TOKEN);
                    token = null;
                } else {
                    ParameterMapping mapping = null;
                    mapping = token.indexOf(PARAM_DELIM) > -1 ? this.oldParseMapping(token, parameterClass, typeHandlerFactory) : this.newParseMapping(token, parameterClass, typeHandlerFactory);
                    mappingList.add(mapping);
                    newSqlBuffer.append("?");
                    token = parser.nextToken();
                    if (!PARAMETER_TOKEN.equals(token)) {
                        throw new SqlMapException("Unterminated inline parameter in mapped statement (statement.getId()).");
                    }
                    token = null;
                }
            } else if (!PARAMETER_TOKEN.equals(token)) {
                newSqlBuffer.append(token);
            }
            lastToken = token;
        }
        newSql = newSqlBuffer.toString();
        ParameterMapping[] mappingArray = mappingList.toArray(new ParameterMapping[mappingList.size()]);
        SqlText sqlText = new SqlText();
        sqlText.setText(newSql);
        sqlText.setParameterMappings(mappingArray);
        return sqlText;
    }

    private ParameterMapping newParseMapping(String token, Class parameterClass, TypeHandlerFactory typeHandlerFactory) {
        BasicParameterMapping mapping = new BasicParameterMapping();
        StringTokenizer paramParser = new StringTokenizer(token, "=,", false);
        mapping.setPropertyName(paramParser.nextToken());
        while (paramParser.hasMoreTokens()) {
            String field = paramParser.nextToken();
            if (paramParser.hasMoreTokens()) {
                String value = paramParser.nextToken();
                if ("javaType".equals(field)) {
                    value = typeHandlerFactory.resolveAlias(value);
                    mapping.setJavaTypeName(value);
                    continue;
                }
                if ("jdbcType".equals(field)) {
                    mapping.setJdbcTypeName(value);
                    continue;
                }
                if ("mode".equals(field)) {
                    mapping.setMode(value);
                    continue;
                }
                if ("nullValue".equals(field)) {
                    mapping.setNullValue(value);
                    continue;
                }
                if ("handler".equals(field)) {
                    try {
                        value = typeHandlerFactory.resolveAlias(value);
                        mapping.setTypeHandler(new CustomTypeHandler((TypeHandlerCallback)Resources.classForName((String)value).newInstance()));
                        continue;
                    }
                    catch (Exception e) {
                        throw new SqlMapException("Error loading class specified by handler field in " + token + ".  Cause: " + e, e);
                    }
                }
                throw new SqlMapException("Unrecognized parameter mapping field: '" + field + "' in " + token);
            }
            throw new SqlMapException("Incorrect inline parameter map format (missmatched name=value pairs): " + token);
        }
        if (mapping.getTypeHandler() == null) {
            TypeHandler handler = parameterClass == null ? typeHandlerFactory.getUnkownTypeHandler() : this.resolveTypeHandler(typeHandlerFactory, parameterClass, mapping.getPropertyName(), mapping.getJavaTypeName(), mapping.getJdbcTypeName());
            mapping.setTypeHandler(handler);
        }
        return mapping;
    }

    private ParameterMapping oldParseMapping(String token, Class parameterClass, TypeHandlerFactory typeHandlerFactory) {
        BasicParameterMapping mapping = new BasicParameterMapping();
        if (token.indexOf(PARAM_DELIM) > -1) {
            StringTokenizer paramParser = new StringTokenizer(token, PARAM_DELIM, true);
            int n1 = paramParser.countTokens();
            if (n1 == 3) {
                String name = paramParser.nextToken();
                paramParser.nextToken();
                String type = paramParser.nextToken();
                mapping.setPropertyName(name);
                mapping.setJdbcTypeName(type);
                TypeHandler handler = parameterClass == null ? typeHandlerFactory.getUnkownTypeHandler() : this.resolveTypeHandler(typeHandlerFactory, parameterClass, name, null, type);
                mapping.setTypeHandler(handler);
                return mapping;
            }
            if (n1 >= 5) {
                String name = paramParser.nextToken();
                paramParser.nextToken();
                String type = paramParser.nextToken();
                paramParser.nextToken();
                String nullValue = paramParser.nextToken();
                while (paramParser.hasMoreTokens()) {
                    nullValue = nullValue + paramParser.nextToken();
                }
                mapping.setPropertyName(name);
                mapping.setJdbcTypeName(type);
                mapping.setNullValue(nullValue);
                TypeHandler handler = parameterClass == null ? typeHandlerFactory.getUnkownTypeHandler() : this.resolveTypeHandler(typeHandlerFactory, parameterClass, name, null, type);
                mapping.setTypeHandler(handler);
                return mapping;
            }
            throw new SqlMapException("Incorrect inline parameter map format: " + token);
        }
        mapping.setPropertyName(token);
        TypeHandler handler = parameterClass == null ? typeHandlerFactory.getUnkownTypeHandler() : this.resolveTypeHandler(typeHandlerFactory, parameterClass, token, null, null);
        mapping.setTypeHandler(handler);
        return mapping;
    }

    private TypeHandler resolveTypeHandler(TypeHandlerFactory typeHandlerFactory, Class clazz, String propertyName, String javaType, String jdbcType) {
        TypeHandler handler = null;
        if (clazz == null) {
            handler = typeHandlerFactory.getUnkownTypeHandler();
        } else if ((class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomTypeMarker = InlineParameterMapParser.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomTypeMarker).isAssignableFrom(clazz)) {
            handler = typeHandlerFactory.getTypeHandler(class$java$lang$String == null ? (class$java$lang$String = InlineParameterMapParser.class$("java.lang.String")) : class$java$lang$String, jdbcType);
        } else if ((class$java$util$Map == null ? (class$java$util$Map = InlineParameterMapParser.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            if (javaType == null) {
                handler = typeHandlerFactory.getUnkownTypeHandler();
            } else {
                try {
                    javaType = typeHandlerFactory.resolveAlias(javaType);
                    Class javaClass = Resources.classForName((String)javaType);
                    handler = typeHandlerFactory.getTypeHandler(javaClass, jdbcType);
                }
                catch (Exception e) {
                    throw new SqlMapException("Error.  Could not set TypeHandler.  Cause: " + e, e);
                }
            }
        } else if (typeHandlerFactory.getTypeHandler(clazz, jdbcType) != null) {
            handler = typeHandlerFactory.getTypeHandler(clazz, jdbcType);
        } else if (javaType == null) {
            Class type = PROBE.getPropertyTypeForGetter((Object)clazz, propertyName);
            handler = typeHandlerFactory.getTypeHandler(type, jdbcType);
        } else {
            try {
                javaType = typeHandlerFactory.resolveAlias(javaType);
                Class javaClass = Resources.classForName((String)javaType);
                handler = typeHandlerFactory.getTypeHandler(javaClass, jdbcType);
            }
            catch (Exception e) {
                throw new SqlMapException("Error.  Could not set TypeHandler.  Cause: " + e, e);
            }
        }
        return handler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

