/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.protocol.MessageSet;
import java.util.Vector;
import javax.mail.Message;

public final class Utility {
    private Utility() {
    }

    public static MessageSet[] toMessageSet(Message[] msgs, Condition cond) {
        Vector<MessageSet> v = new Vector<MessageSet>(1);
        int i = 0;
        while (i < msgs.length) {
            IMAPMessage msg = (IMAPMessage)msgs[i];
            if (!msg.isExpunged()) {
                int current = msg.getSequenceNumber();
                if (cond == null || cond.test(msg)) {
                    MessageSet set = new MessageSet();
                    set.start = current;
                    ++i;
                    while (i < msgs.length) {
                        msg = (IMAPMessage)msgs[i];
                        if (!msg.isExpunged()) {
                            int next = msg.getSequenceNumber();
                            if (cond == null || cond.test(msg)) {
                                if (next == current + 1) {
                                    current = next;
                                } else {
                                    --i;
                                    break;
                                }
                            }
                        }
                        ++i;
                    }
                    set.end = current;
                    v.addElement(set);
                }
            }
            ++i;
        }
        if (v.isEmpty()) {
            return null;
        }
        Object[] sets = new MessageSet[v.size()];
        v.copyInto(sets);
        return sets;
    }

    public static interface Condition {
        public boolean test(IMAPMessage var1);
    }
}

