/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BASE64EncoderStream
extends FilterOutputStream {
    private byte[] buffer = new byte[3];
    private int bufsize = 0;
    private int count = 0;
    private int bytesPerLine;
    private int lineLimit;
    private boolean noCRLF = false;
    private static byte[] newline = new byte[]{13, 10};
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public BASE64EncoderStream(OutputStream out, int bytesPerLine) {
        super(out);
        if (bytesPerLine == Integer.MAX_VALUE || bytesPerLine < 4) {
            this.noCRLF = true;
            bytesPerLine = 76;
        }
        this.bytesPerLine = bytesPerLine / 4 * 4;
        this.lineLimit = bytesPerLine / 4 * 3;
    }

    public BASE64EncoderStream(OutputStream out) {
        this(out, 76);
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        byte[] bytes;
        while ((this.bufsize != 0 || this.count != 0) && len > 0) {
            this.write(b[off++]);
            --len;
        }
        if (this.noCRLF) {
            bytes = new byte[this.bytesPerLine];
        } else {
            bytes = new byte[this.bytesPerLine + 2];
            bytes[this.bytesPerLine] = 13;
            bytes[this.bytesPerLine + 1] = 10;
        }
        int i = 0;
        while (i + this.lineLimit < len) {
            this.out.write(BASE64EncoderStream.encode(b, off + i, this.lineLimit, bytes));
            i += this.lineLimit;
        }
        while (i < len) {
            this.write(b[off + i]);
            ++i;
        }
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void write(int c) throws IOException {
        this.buffer[this.bufsize++] = (byte)c;
        if (this.bufsize == 3) {
            this.encode();
            this.bufsize = 0;
        }
    }

    public final void flush() throws IOException {
        if (this.bufsize > 0) {
            this.encode();
            this.bufsize = 0;
        }
        this.out.flush();
    }

    public final void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void encode() throws IOException {
        if (this.count + 4 > this.bytesPerLine) {
            if (!this.noCRLF) {
                this.out.write(newline);
            }
            this.count = 0;
        }
        this.out.write(BASE64EncoderStream.encode(this.buffer, 0, this.bufsize, null));
        this.count += 4;
    }

    public static final byte[] encode(byte[] inbuf) {
        if (inbuf.length == 0) {
            return inbuf;
        }
        return BASE64EncoderStream.encode(inbuf, 0, inbuf.length, null);
    }

    private static byte[] encode(byte[] inbuf, int off, int len, byte[] outbuf) {
        if (outbuf == null) {
            outbuf = new byte[(len + 2) / 3 * 4];
        }
        int inpos = off;
        int outpos = 0;
        while (len >= 3) {
            int i1 = inbuf[inpos++] & 0xFF;
            i1 <<= 8;
            i1 |= inbuf[inpos++] & 0xFF;
            i1 <<= 8;
            outbuf[outpos + 3] = (byte)pem_array[(i1 |= inbuf[inpos++] & 0xFF) & 0x3F];
            outbuf[outpos + 2] = (byte)pem_array[(i1 >>= 6) & 0x3F];
            outbuf[outpos + 1] = (byte)pem_array[(i1 >>= 6) & 0x3F];
            outbuf[outpos] = (byte)pem_array[(i1 >>= 6) & 0x3F];
            len -= 3;
            outpos += 4;
        }
        if (len == 1) {
            int j1 = inbuf[inpos++] & 0xFF;
            outbuf[outpos + 3] = 61;
            outbuf[outpos + 2] = 61;
            outbuf[outpos + 1] = (byte)pem_array[(j1 <<= 4) & 0x3F];
            outbuf[outpos] = (byte)pem_array[(j1 >>= 6) & 0x3F];
        } else if (len == 2) {
            int k1 = inbuf[inpos++] & 0xFF;
            k1 <<= 8;
            k1 |= inbuf[inpos++] & 0xFF;
            outbuf[outpos + 3] = 61;
            outbuf[outpos + 2] = (byte)pem_array[(k1 <<= 2) & 0x3F];
            outbuf[outpos + 1] = (byte)pem_array[(k1 >>= 6) & 0x3F];
            outbuf[outpos] = (byte)pem_array[(k1 >>= 6) & 0x3F];
        }
        return outbuf;
    }
}

