/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;

public final class SocketFetcher
implements Runnable {
    private Socket socket;
    private String host;
    private int port;
    private Properties props;
    private String prefix;
    private int cto;
    private boolean useSSL;
    private IOException exception;
    private boolean aborted = false;
    private boolean done = false;
    private static final String SSL_SOCKET_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final String SSL_SOCKET = "javax.net.ssl.SSLSocket";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private SocketFetcher(String host, int port, Properties props, String prefix, int cto, boolean useSSL) {
        this.host = host;
        this.port = port;
        this.props = props;
        this.prefix = prefix;
        this.cto = cto;
        this.useSSL = useSSL;
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix, boolean useSSL) throws IOException {
        if (prefix == null) {
            prefix = "socket";
        }
        if (props == null) {
            props = new Properties();
        }
        String s = props.getProperty(String.valueOf(prefix) + ".connectiontimeout", null);
        int cto = -1;
        if (s != null) {
            try {
                cto = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (cto > 0) {
            SocketFetcher sf = new SocketFetcher(host, port, props, prefix, cto, useSSL);
            try {
                Thread t = new Thread((Runnable)sf, "Connection thread for host " + host);
                t.start();
            }
            catch (Exception ex) {
                return SocketFetcher.getSocket0(host, port, props, prefix, useSSL);
            }
            return sf.getSocket();
        }
        return SocketFetcher.getSocket0(host, port, props, prefix, useSSL);
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix) throws IOException {
        return SocketFetcher.getSocket(host, port, props, prefix, false);
    }

    public static Socket startTLS(Socket socket) throws IOException {
        InetAddress a = socket.getInetAddress();
        String host = a.getHostName();
        int port = socket.getPort();
        try {
            String sfClass;
            try {
                sfClass = System.getProperty("mail.SSLSocketFactory.class", SSL_SOCKET_FACTORY);
            }
            catch (SecurityException sex) {
                sfClass = SSL_SOCKET_FACTORY;
            }
            Class<?> clsSockFact = Class.forName(sfClass);
            Method mthGetDefault = clsSockFact.getMethod("getDefault", new Class[0]);
            Object o = mthGetDefault.invoke(new Object(), new Object[0]);
            Class[] classArray = new Class[4];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.net.Socket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            classArray[2] = Integer.TYPE;
            classArray[3] = Boolean.TYPE;
            Class[] mthArgs = classArray;
            Method mthCreateSocket = clsSockFact.getMethod("createSocket", mthArgs);
            Object[] crSockArgs = new Object[]{socket, host, new Integer(port), Boolean.TRUE};
            socket = (Socket)mthCreateSocket.invoke(o, crSockArgs);
            Class<?> clsSSLSocket = Class.forName(SSL_SOCKET);
            try {
                Class[] classArray2 = new Class[1];
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[0] = clazz3;
                Method mthSetEnabledProtocols = clsSSLSocket.getMethod("setEnabledProtocols", classArray2);
                if (mthSetEnabledProtocols != null) {
                    mthSetEnabledProtocols.invoke((Object)socket, new Object[]{new String[]{"TLSv1"}});
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Exception ex) {
            Throwable t;
            if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                ex = (Exception)t;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException("Exception in startTLS: host " + host + ", port " + port + "; Exception: " + ex);
        }
        return socket;
    }

    private static Socket getSocket0(String host, int port, Properties props, String prefix, boolean useSSL) throws IOException {
        String timeout;
        Socket socket;
        block34: {
            socket = null;
            String sfClass = props.getProperty(String.valueOf(prefix) + ".socketFactory.class", null);
            timeout = props.getProperty(String.valueOf(prefix) + ".timeout", null);
            String localaddrstr = props.getProperty(String.valueOf(prefix) + ".localaddress", null);
            InetAddress localaddr = null;
            if (localaddrstr != null) {
                localaddr = InetAddress.getByName(localaddrstr);
            }
            String localportstr = props.getProperty(String.valueOf(prefix) + ".localport", null);
            int localport = 0;
            if (localportstr != null) {
                try {
                    localport = Integer.parseInt(localportstr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean usingDefaultFactory = false;
            if ((sfClass == null || sfClass.length() <= 0) && useSSL) {
                try {
                    sfClass = System.getProperty("mail.SSLSocketFactory.class", SSL_SOCKET_FACTORY);
                }
                catch (SecurityException sex) {
                    sfClass = SSL_SOCKET_FACTORY;
                }
                usingDefaultFactory = true;
            }
            if (sfClass == null || sfClass.length() <= 0) {
                socket = new Socket(host, port, localaddr, localport);
            } else {
                int sfPort = -1;
                boolean fb = false;
                if (!usingDefaultFactory) {
                    String fallback = props.getProperty(String.valueOf(prefix) + ".socketFactory.fallback", null);
                    fb = fallback == null || !fallback.equalsIgnoreCase("false");
                    String sfPortStr = props.getProperty(String.valueOf(prefix) + ".socketFactory.port", null);
                    if (sfPortStr != null) {
                        try {
                            sfPort = Integer.parseInt(sfPortStr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Class<?> clsSockFact = Class.forName(sfClass);
                    Method mthGetDefault = clsSockFact.getMethod("getDefault", new Class[0]);
                    Object o = mthGetDefault.invoke(new Object(), new Object[0]);
                    Integer portInt = new Integer(sfPort != -1 ? sfPort : port);
                    if (localaddr != null) {
                        Class[] classArray = new Class[4];
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz;
                        classArray[1] = Integer.TYPE;
                        Class<?> clazz2 = class$3;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$3 = Class.forName("java.net.InetAddress");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[2] = clazz2;
                        classArray[3] = Integer.TYPE;
                        Class[] mthArgs = classArray;
                        Method mthCreateSocket = clsSockFact.getMethod("createSocket", mthArgs);
                        Object[] crSockArgs = new Object[]{host, portInt, localaddr, new Integer(localport)};
                        socket = (Socket)mthCreateSocket.invoke(o, crSockArgs);
                        break block34;
                    }
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    classArray[1] = Integer.TYPE;
                    Class[] mthArgs = classArray;
                    Method mthCreateSocket = clsSockFact.getMethod("createSocket", mthArgs);
                    Object[] crSockArgs = new Object[]{host, portInt};
                    socket = (Socket)mthCreateSocket.invoke(o, crSockArgs);
                }
                catch (Exception ex) {
                    Throwable t;
                    if (fb) {
                        socket = new Socket(host, port, localaddr, localport);
                    }
                    if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                        ex = (Exception)t;
                    }
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw new IOException("Couldn't connect using \"" + sfClass + "\" socket factory to host, port: " + host + ", " + sfPort + "; Exception: " + ex);
                }
            }
        }
        int to = -1;
        if (timeout != null) {
            try {
                to = Integer.parseInt(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (to >= 0) {
            socket.setSoTimeout(to);
        }
        return socket;
    }

    private synchronized Socket getSocket() throws IOException {
        if (!this.done) {
            try {
                long now = System.currentTimeMillis();
                long deadline = now + (long)this.cto;
                while (now < deadline) {
                    this.wait(deadline - now);
                    if (!this.done) {
                        now = System.currentTimeMillis();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                this.exception = new InterruptedIOException(ex.toString());
            }
        }
        if (this.exception != null) {
            this.aborted = true;
            throw this.exception;
        }
        if (this.socket == null) {
            this.aborted = true;
            throw new ConnectException("connection to " + this.host + " timed out");
        }
        Socket s = this.socket;
        this.socket = null;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Socket s = SocketFetcher.getSocket0(this.host, this.port, this.props, this.prefix, this.useSSL);
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                if (this.aborted) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.socket = s;
                }
                this.done = true;
                this.notify();
            }
        }
        catch (IOException ex) {
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                this.exception = ex;
                this.done = true;
                this.notify();
            }
        }
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

