/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimePartDataSource
implements DataSource,
MessageAware {
    private static boolean ignoreMultipartEncoding = true;
    private MimePart part;
    private MessageContext context;

    static {
        try {
            String s = System.getProperty("mail.mime.ignoremultipartencoding");
            ignoreMultipartEncoding = s == null || !s.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    public final InputStream getInputStream() throws IOException {
        try {
            InputStream is;
            if (this.part instanceof MimeBodyPart) {
                is = ((MimeBodyPart)this.part).getContentStream();
            } else if (this.part instanceof MimeMessage) {
                is = ((MimeMessage)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            String encoding = MimePartDataSource.restrictEncoding(this.part.getEncoding(), this.part);
            if (encoding != null) {
                return MimeUtility.decode(is, encoding);
            }
            return is;
        }
        catch (MessagingException mex) {
            throw new IOException(mex.getMessage());
        }
    }

    private static String restrictEncoding(String s, MimePart mimepart) throws MessagingException {
        if (!ignoreMultipartEncoding || s == null) {
            return s;
        }
        if (s.equalsIgnoreCase("7bit") || s.equalsIgnoreCase("8bit") || s.equalsIgnoreCase("binary")) {
            return s;
        }
        String s1 = mimepart.getContentType();
        if (s1 == null) {
            return s;
        }
        try {
            ContentType contenttype = new ContentType(s1);
            if (contenttype.match("multipart/*") || contenttype.match("message/*")) {
                return null;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return s;
    }

    public final OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public final String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException mex) {
            return null;
        }
    }

    public final String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return "";
    }

    public final synchronized MessageContext getMessageContext() {
        if (this.context == null) {
            this.context = new MessageContext(this.part);
        }
        return this.context;
    }
}

