/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.WebApplicationContext;

import jp.sourceforge.livez.brew.BrewService;
import jp.sourceforge.livez.ezweb.EZwebService;
import jp.sourceforge.livez.imode.ImodeService;
import jp.sourceforge.livez.vodafone.VodafoneService;

/**
 * HTTP NGXg񂩂gђʐMT[rX𔻒肵ēK؂Ȍgђ[gђ[NGXgԂt@Ng[NXłB
 * 
 * @author V _
 * @see Service
 */
public final class MobilePhoneFactory {

	/**
	 * T[rXpvoC_NẌꗗێ܂B
	 */
	private static final Service[] services =
		new Service[] {
			new ImodeService(),
			new EZwebService(),
			new VodafoneService(),
			new BrewService()
		};

	/**
	 * CX^XoȂ܂B
	 */
	private MobilePhoneFactory() {}

	/**
	 * HTTP NGXg񂩂gђʐMT[rX𔻒肵ēK؂Ȍgђ[Ԃ܂B
	 * 
	 * @param request HTTP NGXg
	 * @param context Spring Framework  WebApplicationContext
	 * @return gђ[
	 * @throws NullPointerException HTTP NGXg <code>null</code> ̏ꍇ
	 * @throws ServiceNotFoundException K؂ȃT[rXȂꍇ
	 */
	@SuppressWarnings("unchecked")
	public static MobilePhone getMobilePhone(
		final HttpServletRequest request,
		final WebApplicationContext context)
		throws NullPointerException, ServiceNotFoundException {

		return getMobilePhoneGenerator(request, context).create();
	}

	/**
	 * HTTP NGXg񂩂ʐMT[rX𔻒肵ēK؂Ȍgђ[WFl[^Ԃ܂B
	 * 
	 * @param request HTTP NGXg
	 * @param context Spring Framework  WebApplicationContext
	 * @return gђ[WFl[^
	 * @throws NullPointerException HTTP NGXg <code>null</code> ̏ꍇ
	 * @throws ServiceNotFoundException K؂ȃT[rXȂꍇ
	 */
	@SuppressWarnings("unchecked")
	private static MobilePhoneGenerator getMobilePhoneGenerator(
		final HttpServletRequest request,
		final WebApplicationContext context)
		throws NullPointerException, ServiceNotFoundException {

		for (int i = 0; i < services.length; i++) {
			Service service = services[i];
			try {
				MobilePhoneRequest r = service.getMobilePhoneRequest(request);
				MobilePhoneGenerator g = service.getMobilePhoneGenerator(context);
				g.setMobilePhoneRequest(r);
				return g;
			} catch (IllegalRequestException e) {}	// 
		}

		// Â̒[łȂƔfꂽꍇ(炭PCGbW)
		throw new ServiceNotFoundException();	// FIXME - G[bZ[WԂ
	}

	/**
	 * HTTP NGXg񂩂ʐMT[rX𔻒肵ēK؂Ȍgђ[NGXgԂ܂B
	 * 
	 * @param request HTTP NGXg
	 * @return gђ[NGXg
	 * @throws NullPointerException HTTP NGXg <code>null</code> ̏ꍇ
	 * @throws ServiceNotFoundException K؂ȃT[rXȂꍇ
	 */
	public static MobilePhoneRequest getMobilePhoneRequest(
		final HttpServletRequest request)
		throws NullPointerException, ServiceNotFoundException {

		for (int i = 0; i < services.length; i++) {
			Service service = services[i];
			try {
				return service.getMobilePhoneRequest(request);
			} catch (IllegalRequestException e) {}	// 
		}

		// Â̒[łȂƔfꂽꍇ(炭PCGbW)
		throw new ServiceNotFoundException();	// FIXME - G[bZ[WԂ
	}

}
