/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.brew;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.WebApplicationContext;

import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.MobilePhoneGenerator;

/**
 * BREW[𐶐gђ[WFl[^NXłB
 * 
 * @author V _
 */
public final class BrewGenerator extends MobilePhoneGenerator<BrewRequest, Brew> {

	/**
	 * BREWT[rX؃NXݒt@CQƂẴNX𐶐鎞ɎgpL[łB
	 * 
	 * @see BrewService#getMobilePhoneGenerator(WebApplicationContext)
	 */
	public static final String BEAN_ID = "brewGenerator";

	/**
	 * ftHgRXgN^łB
	 */
	public BrewGenerator() {}

	/**
	 * BREW[NGXg񂩂i[h[𐶐ĕԂ܂B
	 * 
	 * @param r BREW[NGXg
	 * @return BREW[
	 * @throws NullPointerException BREW[NGXg <code>null</code> ̏ꍇ
	 */
	@Override
	public Brew create(final BrewRequest r) throws NullPointerException {
		// ȍ~̏ubN\bh邱
		final BrewImpl result = new BrewImpl();
		result.setup(r.getUserAgent());
		return result;
	}

	/**
	 * HTTP NGXg񂩂BREW[𐶐ĕԂ܂B
	 * 
	 * @param request HTTPNGXg
	 * @return BREW[
	 * @throws NullPointerException HTTPNGXg <code>null</code> ̏ꍇ
	 * @throws IllegalRequestException HTTPNGXg񂪕sȏꍇ
	 */
	@Override
	public Brew create(final HttpServletRequest request) throws NullPointerException, IllegalRequestException {
		return create(new BrewRequestImpl(request));
	}

}
