/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.brew;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.IllegalRequestException;

/**
 * BrewRequest NXłB
 * 
 * @author V _
 */
final class BrewRequestImpl implements BrewRequest {

	/**
	 * RXgN^łB
	 * 
	 * @param request HTTP NGXg
	 * @throws IllegalRequestException sȃNGXg̏ꍇ
	 */
	public BrewRequestImpl(final HttpServletRequest request) throws IllegalRequestException {
		userAgent = new BrewUserAgentImpl(request);
		if (!"keep-alive".equalsIgnoreCase(request.getHeader("Connection")))
			throw new IllegalRequestException();
	}

	/**
	 * [UG[WFgێ܂B
	 */
	private BrewUserAgent userAgent = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhoneRequest#getUserAgent()
	 */
	public BrewUserAgent getUserAgent() {
		return userAgent;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
