/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.brew;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.livez.IllegalUserAgentException;
import jp.sourceforge.livez.UserAgentNotFoundException;

/**
 * BrewUserAgent ̎NXłB
 * 
 * @author V _
 */
final class BrewUserAgentImpl implements BrewUserAgent {

	/**
	 * w肳ꂽ HTTP NGXg񂩂炱̃NX\z܂B<p>
	 * 
	 * @param request HTTPNGXg
	 * @throws UserAgentNotFoundException [U[G[WFg݂Ȃꍇ
	 * @throws IllegalUserAgentException [UG[WFǧ`sȏꍇ
	 */
	public BrewUserAgentImpl(
		final HttpServletRequest request)
		throws UserAgentNotFoundException, IllegalUserAgentException {

		value = request.getHeader("User-Agent");

		if (value == null)
			throw new UserAgentNotFoundException();

		if (!value.matches("BREW/[0-9].+\\.[0-9].+\\.[0-9].+\\.[0-9].+ .+"))
			throw new IllegalUserAgentException();

		version = value.substring("BREW/".length(), value.indexOf(' '));
	}

	/**
	 * ̎ł͕K null Ԃ܂
	 */
	public String getId() {
		return null;
	}

	/**
	 * [UG[WFg̒lێ܂B
	 */
	private String value = null;

	public String getValue() {
		return value;
	}

	/**
	 * BREW ̃o[Wێ܂B
	 */
	private String version = null;

	public String getVersion() {
		return version;
	}

}
