/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.ezweb;

import java.util.List;

import jp.sourceforge.livez.CarrierType;
import jp.sourceforge.livez.MobilePhone;
import jp.sourceforge.livez.Screen;
import jp.sourceforge.livez.ServiceType;

/**
 * EZweb [̃C^[tF[XłB
 * 
 * @author V _
 */
public interface EZweb extends MobilePhone<EZwebBrowser, EZappli, SubscriberId> {

	/**
	 * [̒񋟂ʐMT[rX̎ނԂ܂B<p>
	 * K "EZweb" Ԃ܂B
	 * 
	 * @return EZweb
	 */
	public ServiceType getServiceType();

	/**
	 * LA̎ނԂ܂B<p>
	 * K "AU"  "Tu-Ka" Ԃ܂B
	 * 
	 * @return AU  Tu-Ka
	 */
	public CarrierType getCarrierType();

	/**
	 * KfoCX^CvԂ܂B<p>
	 * 
	 * @return foCX^Cv
	 */
	public String getId();

	public String getName();

	public String getProductName();

	/**
	 * V[YԂ܂B<p>
	 * V[YȂꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return V[Y
	 */
	public String getSeriesName();

	/**
	 * ʏԂ܂B<p>
	 * 
	 * @return tʏ
	 */
	public Screen getScreen();

	/**
	 * \tgL[̐Ԃ܂B<p>
	 * C202DE [̏ꍇA0 Ԃ܂B
	 * 
	 * @return \tgL[̐
	 */
	public int getSoftkeys();

	/**
	 * \tgL[̃xƂĎgp\ȕ̍ő包Ԃ܂B<p>
	 * 
	 * @return ő包
	 */
	public int getSoftkeyLabelLength();

	/**
	 * uEUԂ܂B<p>
	 * 
	 * @return uEU
	 */
	public EZwebBrowser getBrowser();

	/**
	 * EZAv(Java/BREW)sԂ܂B<p>
	 * EZAvɑΉĂȂꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return EZAvs
	 */
	public EZappli getAppli();

	/**
	 * ʐ^t[ΉԂ܂B<p>
	 * sȏꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return ʐ^t[Ή
	 */
	public List<Frame> getFrames();

	/**
	 * ʐ^X^vΉԂ܂B<p>
	 * sȏꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return ʐ^X^vΉ
	 */
	public Stamp getStamp();

	/**
	 * e EZweb T[rXւ̑Ή󋵂Ԃ܂B
	 * 
	 * @return e EZweb T[rXւ̑Ή
	 */
	public EZwebMultiMedia getDataFormat();

	/**
	 * EZԍ(TuXNCoID)Ԃ܂B<p>
	 * EZԍʒmݒ肪 "OFF" ̏ꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return EZԍ(TuXNCoID)
	 */
	public SubscriberId getUserId();

	/**
	 * ܂Ƃ߂auxΉ󋵂Ԃ܂B<p>
	 * C3XX V[YȑO̒[y Tu-Ka n[̏ꍇ <code>false</code> Ԃ܂B
	 * 
	 * @return ܂Ƃ߂auxΉ
	 */
	public boolean isPremiumEZ();

}
