/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.ezweb;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * Browser ̎NXłB
 * 
 * @author V _
 */
final class EZwebBrowserImpl implements EZwebBrowser {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 * 
	 * @param r EZweb [NGXg
	 */
	public EZwebBrowserImpl(final EZwebRequest r) {
		this.titlebar = r.isTitlebar();
		this.width = r.getBrowserWidth();
		this.height = r.getBrowserHeight();
		this.column = r.getCharacterColumn();
		this.row = r.getCharacterRow();
		this.cacheSize = r.getMaxDataSize();
		if (r.getUserAgent().isWap2())
			this.xhtmlVersion = new Float("1.0");
	}

	/**
	 * ^Cgo[\Lێ܂B
	 */
	private boolean titlebar = false;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebBrowser#isTitlebar()
	 */
	public boolean isTitlebar() {
		return titlebar;
	}

	private int width = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	private int height = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	private int column = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getColumn()
	 */
	public int getColumn() {
		return column;
	}

	private int row = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getRow()
	 */
	public int getRow() {
		return row;
	}

	private int cacheSize = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getCacheSize()
	 */
	public int getCacheSize() {
		return cacheSize;
	}

	private Float xhtmlVersion = null;

	/*
	 * @see jp.sourceforge.livez.Browser#getXhtmlVersion()
	 */
	public Float getXhtmlVersion() {
		return xhtmlVersion;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
