/*
 * Copyright (c) 2005 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.ezweb;

import javax.servlet.http.HttpServletRequest;

import org.springframework.dao.DataAccessException;

import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.MobilePhoneGenerator;
import jp.sourceforge.livez.dao.EZwebDAO;

/**
 * EZweb [𐶐gђ[WFl[^NXłB
 * 
 * @author V _
 */
public final class EZwebGenerator extends MobilePhoneGenerator<EZwebRequest, EZweb> {

	public static final String BEAN_ID = "ezwebGenerator";

	/**
	 * EZwebDAO ێ܂B
	 */
	private EZwebDAO ezwebDAO = null;

	/**
	 * EZwebDAO ݒ肵܂B
	 * 
	 * @param ezwebDAO EZwebDAO
	 */
	public void setEzwebDAO(final EZwebDAO ezwebDAO) {
		this.ezwebDAO = ezwebDAO;
	}

	/**
	 * ftHgRXgN^łB
	 */
	public EZwebGenerator() {}

	/**
	 * EZweb [NGXg񂩂 EZweb [𐶐ĕԂ܂B
	 * 
	 * @param r EZweb [NGXg
	 * @return EZweb [
	 * @throws NullPointerException EZweb [NGXg <code>null</code> ̏ꍇ
	 * @throws DataAccessException EZwebDAO ̑ŗOꍇ
	 */
	@Override
	public EZweb create(final EZwebRequest r) throws NullPointerException, DataAccessException {
		final EZwebImpl result = new EZwebImpl();

		if (this.ezwebDAO != null) {
			jp.sourceforge.livez.dao.EZweb ezweb = ezwebDAO.load(r.getUserAgent().getId());
			if (ezweb != null)
				result.setup(ezweb);
		}

		result.setup(r);

		return result;
	}

	/**
	 * HTTP NGXg񂩂 EZweb [𐶐ĕԂ܂B
	 * 
	 * @param request HTTPNGXg
	 * @return EZweb [
	 * @throws NullPointerException HTTPNGXg <code>null</code> ̏ꍇ
	 * @throws IllegalRequestException HTTPNGXg񂪕sȏꍇ
	 * @throws DataAccessException EZwebDAO ̑ŗOꍇ
	 */
	@Override
	public EZweb create(final HttpServletRequest request) throws NullPointerException, IllegalRequestException, DataAccessException {
		return create(new EZwebRequestImpl(request));
	}

}
