/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.ezweb;

import java.io.Serializable;

/**
 * e EZweb T[rX(f[^tH[}bg)ւ̑Ή̃C^[tF[XłB
 * 
 * @author V _
 */
public interface EZwebMultiMedia extends Serializable {

	public static final int UNSUPPORTED = 0;

	public static final int EZMOVIE_AMC_QCIF = 1;
	public static final int EZMOVIE_AMC_LIGHT = 2;
	public static final int EZMOVIE_AMC_SUBQCIF = 3;
	public static final int EZMOVIE_A1302SA = 4;

	/**
	 * EZ[r[Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - AMC tH[}bg (QCIF/Sub-QCIF/Light) Ή
	 * <li><code>2</code> - AMC tH[}bg (Light) Ή
	 * <li><code>3</code> - AMC tH[}bg (Sub-QCIF/Light) Ή
	 * <li><code>4</code> - A1302SA (dl)
	 * <li><code>5</code> - 3GPP2 tH[}bg (QCIF/Sub-QCIF/Light) ΉBAMC tH[}bg (QCIF/Sub-QCIF/Light) ΉBXg[~OĐ^CvΉ
	 * <li><code>6</code> - 3GPP2 tH[}bg (QCIF/Sub-QCIF/Light) ΉBAMC tH[}bg (QCIF/Sub-QCIF/Light) ΉBXg[~OĐ^CvΉ
	 * <li><code>7</code> - 3GPP2 tH[}bg (QCIF/Sub-QCIF/Light) ΉBXg[~OĐ^CvΉ
	 * <li><code>8</code> - 3GPP2 tH[}bg (QCIF/Sub-QCIF/Light) ΉBXg[~OĐ^CvΉ
	 * <li><code>9</code> - 3GPP2 tH[}bg (QVGA/240x180sNZ/QCIF/Sub-QCIF/Light) ΉBXg[~OĐ^CvΉ (QVGA/240x180sNZ)
	 * </ul>
	 * 
	 * @return EZ[r[Ή
	 */
	public int getEZmovieFormat();

	/**
	 * ʒuΉ󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - ȈՈʒuΉ
	 * <li><code>2</code> - EZir (MS-Assisted ) Ή
	 * <li><code>3</code> - EZir (MS-Based ) Ή
	 * </ul>
	 * 
	 * @return ʒuΉ
	 */
	public int getGps();

	public static final int EZAPPLI_PHASE_1		= 1;
	public static final int EZAPPLI_PHASE_2		= 2;
	public static final int EZAPPLI_PHASE_2_5_MA3	= 3;
	public static final int EZAPPLI_PHASE_2_5		= 4;
	public static final int EZAPPLI_PHASE_3_0		= 5;

	/**
	 * EZAv(Java)Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - Phase 1 Ή
	 * <li><code>2</code> - Phase 2 Ή
	 * <li><code>3</code> - Phase 2.5 (SMAF MA3 Phase f[^Đ@\̂) Ή
	 * <li><code>4</code> - Phase 2.5 Ή
	 * <li><code>5</code> - Phase 3.0 Ή
	 * </ul>
	 * 
	 * @return EZAv(Java)Ή
	 */
	public int getJava();

	public static final int CMIDI_1_0	= 1;
	public static final int CMIDI_2_0	= 2;
	public static final int CMIDI_3_0	= 3;

	/**
	 * C-MIDI Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - C-MIDI 1.0 Ή
	 * <li><code>2</code> - C-MIDI 2.0 Ή
	 * <li><code>3</code> - C-MIDI 3.0 Ή
	 * </ul>
	 * 
	 * @return C-MIDI Ή
	 */
	public int getMidi();

	public static final int SMAF_MA1		= 1;
	public static final int SMAF_MA2		= 2;
	public static final int SMAF_MA2_EX	= 3;
	public static final int SMAF_MA3		= 4;
	public static final int SMAF_MA3_EX	= 5;
	public static final int SMAF_MA5		= 6;
	public static final int SMAF_MA5_EX	= 7;

	/**
	 * SMAF Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - MA1 Ή
	 * <li><code>2</code> - MA2 (tn) Ή
	 * <li><code>3</code> - MA2 (tn/\n) Ή
	 * <li><code>4</code> - MA3 (tn) Ή
	 * <li><code>5</code> - MA3 (tn/\n) Ή
	 * <li><code>6</code> - MA5 (tn) Ή
	 * <li><code>7</code> - MA5 (tn/\n) Ή
	 * </ul>
	 * 
	 * @return SMAF Ή
	 */
	public int getSmaf();

	public static final int ATMAIL_PHASE_1 = 1;
	public static final int ATMAIL_PHASE_2 = 2;
	public static final int ATMAIL_PHASE_3 = 3;
	public static final int ATMAIL_PHASE_4 = 4;

	/**
	 * mail Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - Phase 1 Ή
	 * <li><code>2</code> - Phase 2 Ή (//{wΉ)
	 * <li><code>3</code> - Phase 3 Ή (M 500 Ή)
	 * <li><code>4</code> - Phase 4 Ή ([Ή)
	 * </ul>
	 * 
	 * @return mail Ή
	 */
	public int getAtMail();

	public static final int VCARD_3_0 = 1;

	/**
	 * vCard Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - vCard 3.0 Ή
	 * </ul>
	 * 
	 * @return vCard Ή
	 */
	public int getVCard();

	public static final int VCALENDAR_1_0 = 1;
	public static final int VCALENDAR_2_0 = 2;

	/**
	 * vCalendar Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - vCalendar 1.0 Ή
	 * <li><code>2</code> - vCalendar 2.0 Ή (iCalendar Ή)
	 * </ul>
	 * 
	 * @return vCalendar Ή
	 */
	public int getVCalendar();

	public static final int EMOJI_PHASE_1 = 0;
	public static final int EMOJI_PHASE_2 = 1;
	public static final int EMOJI_PHASE_3 = 2;

	/**
	 * GΉ󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Phase 1 (Gԍ 1`304) Ή
	 * <li><code>1</code> - Phase 2 (Gԍ 1`822) Ή
	 * <li><code>2</code> - Phase 3 (Gԍ 1`828) Ή
	 * </ul>
	 * 
	 * @return GΉ
	 */
	public int getEmoji();

	/**
	 * GΉ󋵂gp\ȊGԍ̍őlԂ܂B
	 * 
	 * @return gp\ȊGԍ̍ől
	 */
	public int getMaxEmojiNumber();

	public static final int BREW_2_0 = 1;
	public static final int BREW_2_1 = 2;
	public static final int BREW_3_1 = 3;

	/**
	 * EZAv(BREW) Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή (C3003P ܂)
	 * <li><code>1</code> - BREW 2.0
	 * <li><code>2</code> - BREW 2.1
	 * <li><code>3</code> - BREW 3.1
	 * </ul>
	 * 
	 * @return EZAv(BREW) Ή
	 */
	public int getBrew();

	public static final int SMAF_PHOTO_MIXER_M3F_EDITOR		= 1;
	public static final int SMAF_PHOTO_MIXER_M3F_PLAYER		= 2;
	public static final int SMAF_PHOTO_MIXER_M3F_MQF_EDITOR	= 3;
	public static final int SMAF_PHOTO_MIXER_M3F_MQF_PLAYER	= 4;

	/**
	 * SMAF tHg~LT[Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - 񓋍
	 * <li><code>1</code> - um3fv(ҏW/Đ) Ή
	 * <li><code>2</code> - um3fv(Đ) Ή
	 * <li><code>3</code> - um3fvumqfv(ҏW/Đ) Ή
	 * <li><code>4</code> - um3fvumqfv(Đ) Ή
	 * </ul>
	 * 
	 * @return SMAF tHg~LT[Ή
	 */
	public int getSmafPhotoMixer();

	public static final int VECTOR_FLASH = 1;

	/**
	 * Vector Ή󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - Flash Ή
	 * </ul>
	 * 
	 * @return Vector Ή
	 */
	public int getVector();

	public static final int EZCHANNEL_UNSUPPORTED = 0;
	public static final int EZCHANNEL_SUPPORTED = 1;

	/**
	 * EZ`lΉ󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - Ή
	 * <li><code>1</code> - Ή
	 * </ul>
	 * 
	 * @return EZ`lΉ
	 */
	public int getEZchannel();

	public static final int EXTERNAL_MEMORY_COPYRIGHT = 2;

	/**
	 * OۑΉ󋵂Ԃ܂B<p>
	 * <ul>
	 * <li><code>0</code> - OXbg񓋍
	 * <li><code>1</code> - 쌠tOtf[^̊Oۑ (Í) Ή
	 * <li><code>2</code> - 쌠tOtf[^̊Oۑ (Í) Ή
	 * </ul>
	 * 
	 * @return OۑΉ
	 */
	public int getExternalMemory();

}
