/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.ezweb;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * EZwebMultiMedia ̎NXłB
 * 
 * @author V _
 */
final class EZwebMultiMediaImpl implements EZwebMultiMedia {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 * 
	 * @param request HTTP NGXg
	 * @throws IllegalArgumentException p[^sȏꍇ
	 */
	public EZwebMultiMediaImpl(final HttpServletRequest request) throws IllegalArgumentException {
		this(request.getHeader("x-up-devcap-multimedia"));
	}

	/**
	 * RXgN^łB
	 * 
	 * @param s x-up-devcap-multimedia tB[h\
	 * @throws IllegalArgumentException p[^sȏꍇ
	 */
	public EZwebMultiMediaImpl(final String s) throws IllegalArgumentException {
		if (s == null)
			return;
		if (!s.matches("^[0-9]{16}$"))
			throw new IllegalArgumentException(s);

		this.ezmovie		= s.charAt(0) - 0x0030;
		this.gps			= s.charAt(1) - 0x0030;
		this.java			= s.charAt(2) - 0x0030;
		this.midi			= s.charAt(3) - 0x0030;
		this.smaf			= s.charAt(4) - 0x0030;
		this.atmail			= s.charAt(5) - 0x0030;
		this.vCard			= s.charAt(6) - 0x0030;
		this.vCalendar		= s.charAt(7) - 0x0030;
		this.emoji			= s.charAt(8) - 0x0030;
		this.brew			= s.charAt(9) - 0x0030;
		this.smafPhotoMixer	= s.charAt(10) - 0x0030;

		this.vector			= s.charAt(12) - 0x0030;
		this.ezchannel		= s.charAt(13) - 0x0030;
		this.externalMemory	= s.charAt(14) - 0x0030;
	}

	/**
	 * EZ[r[Ή󋵂ێ܂B
	 */
	private int ezmovie = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getEZmovieFormat()
	 */
	public int getEZmovieFormat() {
		return ezmovie;
	}

	/**
	 * ʒuΉ󋵂ێ܂B
	 */
	private int gps = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getGps()
	 */
	public int getGps() {
		return gps;
	}

	/**
	 * EZAv(Java)Ή󋵂ێ܂B
	 */
	private int java = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getJava()
	 */
	public int getJava() {
		return java;
	}

	/**
	 * C-MIDI Ή󋵂ێ܂B
	 */
	private int midi = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getMidi()
	 */
	public int getMidi() {
		return midi;
	}

	/**
	 * SMAF Ή󋵂ێ܂B
	 */
	private int smaf = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getSmaf()
	 */
	public int getSmaf() {
		return smaf;
	}

	/**
	 * mail Ή󋵂ێ܂B
	 */
	private int atmail = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getAtMail()
	 */
	public int getAtMail() {
		return atmail;
	}

	/**
	 * vCard Ή󋵂ێ܂B
	 */
	private int vCard = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getVCard()
	 */
	public int getVCard() {
		return vCard;
	}

	/**
	 * vCalendar Ή󋵂ێ܂B
	 */
	private int vCalendar = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getVCalendar()
	 */
	public int getVCalendar() {
		return vCalendar;
	}

	/**
	 * GΉ󋵂ێ܂B
	 */
	private int emoji = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getEmoji()
	 */
	public int getEmoji() {
		return emoji;
	}

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getMaxEmojiNumber()
	 */
	public int getMaxEmojiNumber() {
		switch (emoji) {
			case EMOJI_PHASE_1:
				return 304;
			case EMOJI_PHASE_2:
				return 822;
			case EMOJI_PHASE_3:
			default:
				return 828;
		}
	}

	/**
	 * EZAv(BREW) Ή󋵂ێ܂B
	 */
	private int brew = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getBrew()
	 */
	public int getBrew() {
		return brew;
	}

	/**
	 * SMAF tHg~LT[Ή󋵂ێ܂B
	 */
	private int smafPhotoMixer = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getSmafPhotoMixer()
	 */
	public int getSmafPhotoMixer() {
		return smafPhotoMixer;
	}

	/**
	 * Vector Ή󋵂ێ܂B
	 */
	private int vector = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getVector()
	 */
	public int getVector() {
		return vector;
	}

	/**
	 * EZ`lΉ󋵂ێ܂B
	 */
	private int ezchannel = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getEZchannel()
	 */
	public int getEZchannel() {
		return ezchannel;
	}

	/**
	 * OۑΉ󋵂ێ܂B
	 */
	private int externalMemory = 0;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebMultiMedia#getExternalMemory()
	 */
	public int getExternalMemory() {
		return externalMemory;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
