/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.ezweb;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.IllegalUserAgentException;
import jp.sourceforge.livez.UserAgentNotFoundException;

/**
 * EZwebUserAgent NXłB
 * 
 * @author V _
 */
final class EZwebUserAgentImpl implements EZwebUserAgent {

	/**
	 * foCX^Cṽp^[łB
	 */
	private static final String DEVICE_TYPE_PATTERN = "[A-Z]{2}[A-Z0-9]{2}";

	/**
	 * WAP (HDML) Ή[̃[UG[WFg̃p^[łB
	 */
	private static final String WAP_PATTERN = "^UP\\.Browser/.+-" + DEVICE_TYPE_PATTERN + " .+/.+$";

	/**
	 * WAP 2.0 (XHTML) Ή[̃[UG[WFg̃p^[łB
	 */
	private static final String WAP2_PATTERN = "^KDDI-" + DEVICE_TYPE_PATTERN + " UP\\.Browser/.+ \\(GUI\\) .+/.+$";

	/**
	 * HTTP NGXg񂩂NX\zRXgN^łB
	 * 
	 * @param request HTTP NGXg
	 * @throws UserAgentNotFoundException [U[G[WFg݂Ȃꍇ
	 * @throws IllegalUserAgentException [UG[WFǧ`sȏꍇ
	 */
	public EZwebUserAgentImpl(final HttpServletRequest request) throws UserAgentNotFoundException, IllegalUserAgentException {
		this(request.getHeader(HTTP_HEADER_KEY));
	}

	/**
	 * w肳ꂽ񂩂炱̃NX\z܂B
	 * 
	 * @param ua HTTP [U[G[WFg\
	 * @throws UserAgentNotFoundException [U[G[WFg null ̏ꍇ
	 * @throws IllegalUserAgentException [UG[WFǧ`sȏꍇ
	 */
	public EZwebUserAgentImpl(final String ua) throws UserAgentNotFoundException, IllegalUserAgentException {
		// [UG[WFg̑Ó؂܂B
		if (ua == null)
			throw new UserAgentNotFoundException();
		if (!ua.matches(WAP_PATTERN) && !ua.matches(WAP2_PATTERN))
			throw new IllegalUserAgentException(ua);

		this.value = ua;
		// foCX^Cvݒ肵܂B
		this.id = ua.substring(ua.indexOf('-') + 1, ua.indexOf(' '));
		this.wap2 = !ua.startsWith("UP.Browser");

		// uEŨo[Wݒ肵܂B
		int start = ua.indexOf('/');
		int end;

		if (!this.wap2)
			end = ua.indexOf('-', start + 1);
		else
			end = ua.indexOf('(', start + 1);

		this.browserVersion = ua.substring(start + 1, end);

		String[] s = ua.substring(ua.lastIndexOf(' ') + 1).split("/");
		this.serverName = s[0];
		this.serverVersion = s[1];
	}

	/**
	 * [UG[WFg̐lێ܂B
	 */
	private String value = null;

	/*
	 * @see jp.sourceforge.livez.UserAgent#getValue()
	 */
	public String getValue() {
		return value;
	}

	/**
	 * foCX^Cvێ܂B
	 */
	private String id = null;

	/*
	 * @see jp.sourceforge.livez.UserAgent#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * WAP2 (XHTML) Ή󋵂ێ܂B
	 */
	private boolean wap2 = false;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebUserAgent#isWap2()
	 */
	public boolean isWap2() {
		return wap2;
	}

	/**
	 * uEŨo[Wێ܂B
	 */
	private String browserVersion = null;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebUserAgent#getBrowserVersion()
	 */
	public String getBrowserVersion() {
		return browserVersion;
	}

	private String serverName = null;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebUserAgent#getServerName()
	 */
	public String getServerName() {
		return serverName;
	}

	private String serverVersion = null;

	/*
	 * @see jp.sourceforge.livez.ezweb.EZwebUserAgent#getServerVersion()
	 */
	public String getServerVersion() {
		return serverVersion;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
