/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.ezweb;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.Screen;

/**
 * Screen ̎NXłB
 * 
 * @author V _
 */
final class ScreenImpl implements Screen {

	private static final long serialVersionUID = 1L;

	/**
	 * ftHgRXgN^łB
	 */
	public ScreenImpl() {}

	void setup(final jp.sourceforge.livez.dao.EZweb ezweb) {
		if (ezweb.getScreenWidth() != null)
			this.width = ezweb.getScreenWidth();
		if (ezweb.getScreenHeight() != null)
			this.height = ezweb.getScreenHeight();
	}

	void setup(final EZwebRequest r) {
		this.monochrome = !r.isColorScreen();
		this.color = r.getColor();
		this.qvga = (r.getBrowserWidth() >= 200 && r.getBrowserHeight() >= 200) || "SN24".equals(r.getUserAgent().getId());
	}

	/**
	 * ێ܂B
	 */
	private int width = 0;

	/*
	 * @see jp.sourceforge.livez.Screen#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * ێ܂B
	 */
	private int height = 0;

	/*
	 * @see jp.sourceforge.livez.Screen#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * mNʂǂێ܂B
	 */
	private boolean monochrome = true;

	/*
	 * @see jp.sourceforge.livez.Screen#isMonochrome()
	 */
	public boolean isMonochrome() {
		return monochrome;
	}

	/**
	 * F/Kێ܂B
	 */
	private int color = 2;

	/*
	 * @see jp.sourceforge.livez.Screen#getColor()
	 */
	public int getColor() {
		return color;
	}

	/**
	 * QVGA t𓋍ڂĂ邩ǂێ܂B
	 */
	private boolean qvga = false;

	/*
	 * @see jp.sourceforge.livez.Screen#isQVGA()
	 */
	public boolean isQVGA() {
		return qvga;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
