/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.ezweb;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.IllegalUserIdException;

/**
 * SubscriberId ̎NXłB
 * 
 * @author V _
 */
final class SubscriberIdImpl implements SubscriberId {

	private static final long serialVersionUID = 1L;

	/**
	 * 񂩂炱̃NX\zRXgN^łB
	 * 
	 * @param subscriberId EZԍ\
	 * @throws NullPointerException EZԍ <code>null</code> ̏ꍇ
	 * @throws IllegalArgumentException EZԍsȏꍇ
	 */
	public SubscriberIdImpl(final String subscriberId) throws NullPointerException, IllegalUserIdException {
		if (!validate(subscriberId))
			throw new IllegalUserIdException();

		this.value = subscriberId;
	}

	/**
	 * HTTP NGXg񂩂炱̃NX\zRXgN^łB
	 * 
	 * @param request HTTPNGXg
	 * @throws NullPointerException EZԍȂꍇ
	 * @throws IllegalArgumentException EZԍsȏꍇ
	 */
	public SubscriberIdImpl(final HttpServletRequest request) throws NullPointerException, IllegalUserIdException {
		String subscriberId = request.getHeader("x-up-subno");

		if (!validate(subscriberId))
			throw new IllegalUserIdException();

		this.value = subscriberId;
	}

	private static boolean validate(final String subscriberId) throws NullPointerException {
		if (subscriberId == null)
			throw new NullPointerException(); 

		// ؗpK\
		String key = "^" +
			// Ǝ(n)ʃR[hꗗ
			"(" +
				"05[0-9]{2}0[0-9]{9,}" +
				"|(05[0-9]{2}[123456789](01|03|05)|(0700|0701|0702|0703|0704|0705|0706|0707|0800|0801|0802)[0-9]{3})[0-9]{7,}" +
			")" +
			// zXg/hCꗗ
			"_(((W[23456789]\\.ez[a-z])|w0\\.upa|fwswua01\\.upb)\\.ido|([a-z]([23456789]|[a-z])|x(23469)s?|x7.xx)\\.ezweb)\\.ne\\.jp" +
			"$";

		return subscriberId.matches(key) && (subscriberId.length() <= 40);
	}

	/**
	 * EZԍ̐lێ܂B
	 */
	private String value = null;

	/*
	 * @see jp.sourceforge.livez.UserId#getValue()
	 */
	public final String getValue() {
		return value;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
