/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

/**
 * X|Xy[W a vf form vfɑ΂āAHTTP ZbVID t^tB^[łB<p>
 * HTTP ZbVIDt^ĂꍇÃT[oւ URL ւ̓ZbVIDt^܂B
 * 
 * @author V _
 */
public final class EncodeUrlFilter implements Filter {

	/*
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(final FilterConfig filterConfig) {}

	/*
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(
		final ServletRequest request,
		final ServletResponse response,
		final FilterChain chain)
		throws IOException, ServletException {

		BufferedTextResponseWrapper r = new BufferedTextResponseWrapper(response);

		chain.doFilter(request, r);

		if (response.isCommitted())
			return;

		if (response.getContentType() != null && response.getContentType().startsWith("text/")) {
			String page = encodeAllURL(r, r.getBuffer());
			PrintWriter out = response.getWriter();
			out.print(page);
		}
	}

	/*
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {}

	private static final Pattern A_HREF = Pattern.compile("(<a(\\s+\\w+(=\"[^\"]*\")*)*(\\s+href=\"))([^\"]+)(\"(\\s+\\w+(=\"[^\"]*\")*)*\\s*/?\\s*>)", Pattern.CASE_INSENSITIVE);
	private static final Pattern FORM_ACTION = Pattern.compile("(<form(\\s+\\w+(=\"[^\"]*\")*)*?(\\s+action=\"))([^\"]+)(\"(\\s+\\w+(=\"[^\"]*\")*)*\\s*>)", Pattern.CASE_INSENSITIVE);

	private static String encodeAllURL(
		final HttpServletResponse response,
		final CharSequence cs) {

		StringBuffer sb;
		sb = encodeURL(A_HREF, cs, response);
		sb = encodeURL(FORM_ACTION, sb, response);
		return sb.toString();
	}

	private static StringBuffer encodeURL(final Pattern pattern, final CharSequence s, final HttpServletResponse response) {
		Matcher matcher = pattern.matcher(s);
		StringBuffer results = new StringBuffer();

		while (matcher.find()) {
			String url = matcher.group(5); //̌URL`FbN(K{)
			if (url.indexOf(':') == -1 && url.toLowerCase().indexOf(";jsessionid=") == -1)
				url = response.encodeURL(url);
			matcher.appendReplacement(results, matcher.group(1) + url + matcher.group(6));
		}
		matcher.appendTail(results);

		return results;
	}

}
