/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import jp.sourceforge.livez.MobilePhone;
import jp.sourceforge.livez.MobilePhoneFactory;
import jp.sourceforge.livez.ServiceNotFoundException;

/**
 * gђ[̐yєjǗT[ubgtB^NXłB<p>
 * tB^̏p[^Ɏw\ȃp[^ɂĂ͈ȉQƂĉB
 * <ul>
 * <li><b>url</b>&nbsp;-&nbsp;NGXggђ[ł͂Ȃꍇ̃_CNgw肵܂B
 * ̃p[^gpȂꍇ̓NCAgɕsȃNGXg (400) \ HTTP Xe[^XR[hԂ܂B</li>
 * </ul>
 * </p>
 * 
 * @author V _
 */
public final class MobilePhoneFilter implements Filter {

	/**
	 * ʃOCX^XłB
	 */
	private static final Log log = LogFactory.getLog(MobilePhoneFilter.class);

	private WebApplicationContext context;

	/**
	 * sȃfoCX̏ꍇ̃_CNgpXێ܂B
	 */
	private String url;

	/*
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(final FilterConfig filterConfig) {
		this.context = WebApplicationContextUtils.getWebApplicationContext(filterConfig.getServletContext());
		this.url = filterConfig.getInitParameter("url");
	}

	/*
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(
		final ServletRequest request,
		final ServletResponse response,
		final FilterChain chain)
		throws IOException, ServletException {

		try {
			request.setAttribute(MobilePhone.BEAN_KEY, MobilePhoneFactory.getMobilePhone((HttpServletRequest)request, this.context));
		} catch (ServiceNotFoundException e) {
			if (log.isDebugEnabled())
				log.debug(e.getMessage(), e);

			redirect(request, response);
			return;
		}

		if (response.isCommitted())
			return;

		chain.doFilter(request, response);
	}

	/*
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
		this.context = null;
		this.url = null;
	}

	private void redirect(final ServletRequest request, final ServletResponse response) throws IOException {
		HttpServletResponse res = (HttpServletResponse) response;

		if (url != null) {
			res.sendRedirect(url);
		} else
			res.sendError(HttpServletResponse.SC_BAD_REQUEST);
	}

}
