/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.images;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.apache.commons.io.FilenameUtils;

/**
 * ȈՂȉ摜ϊp[eBeBNXłB
 * 
 * @author V _
 */
public final class ImageConverter {

	/**
	 * CX^XoȂ܂B
	 */
	private ImageConverter() {}

	public static void converte(final String src, final ImageType type)
		throws IllegalArgumentException, IOException {

		String dist = getDistFilename(src, type);

		converte(new File(src), new File(dist), type);
	}

	public static void converte(final String src, final ImageType type, final double scale)
		throws IllegalArgumentException, IOException {

		String dist = getDistFilename(src, type);

		converte(new File(src), new File(dist), type, scale, scale);
	}

	public static void converte(final String src, final ImageType type, final double sx, final double sy)
		throws IllegalArgumentException, IOException {

		String dist = getDistFilename(src, type);

		converte(new File(src), new File(dist), type, sx, sy);
	}

	public static void converte(final String src, final ImageType type, final int width, final int height)
		throws IllegalArgumentException, IOException {

		String dist = getDistFilename(src, type);

		converte(new File(src), new File(dist), type, width, height);
	}

	/**
	 * w肳ꂽ̓t@CƏo̓t@C`̏o̓t@CԂ܂B
	 * 
	 * @param src ̓t@C
	 * @param type o̓t@C`
	 * @return ̏o̓t@C
	 * @throws IllegalArgumentException p[^sȏꍇ
	 */
	private static String getDistFilename(final String src, final ImageType type) throws IllegalArgumentException {
		if (src == null || src.length() <= 0)
			throw new IllegalArgumentException("src is null or blank.");
		if (type == null)
			throw new IllegalArgumentException("type is null.");
		
		return FilenameUtils.getFullPath(src) + FilenameUtils.getBaseName(src) + '.' + type.getSuffix();
	}


	public static void converte(
		final String src,
		final String dist,
		final ImageType type)
		throws IllegalArgumentException, IOException {

		converte(new File(src), new File(dist), type);
	}

	public static void converte(
		final String src,
		final String dist,
		final ImageType type,
		final double scale)
		throws IllegalArgumentException, IOException {

		converte(new File(src), new File(dist), type, scale, scale);
	}

	public static void converte(
		final String src,
		final String dist,
		final ImageType type,
		final double sx,
		final double sy)
		throws IllegalArgumentException, IOException {

		converte(new File(src), new File(dist), type, sx, sy);
	}

	public static void converte(
		final String src,
		final String dist,
		final ImageType type,
		final int width,
		final int height)
		throws IllegalArgumentException, IOException {

		converte(new File(src), new File(dist), type, width, height);
	}


	public static void converte(
		final File src,
		final File dist,
		final ImageType type)
		throws IllegalArgumentException, IOException {

		converte(src, dist, type, -1, -1);
	}

	public static void converte(
		final File src,
		final File dist,
		final ImageType type,
		final double scale)
		throws IllegalArgumentException, IOException {
	
		converte(src, dist, type, scale, scale);
	}

	public static void converte(
		final File src,
		final File dist,
		final ImageType type,
		final double sx,
		final double sy)
		throws IllegalArgumentException, IOException {
	
		BufferedImage in = ImageIO.read(src);
		BufferedImage out = converteBufferedImage(in, type, sx, sy);
		ImageIO.write(out, type.getFormatName(), dist);
	}

	public static void converte(
		final File src,
		final File dist,
		final ImageType type,
		final int width,
		final int height)
		throws IllegalArgumentException, IOException {

		BufferedImage in = ImageIO.read(src);
		BufferedImage out = converteBufferedImage(in, type,
			width > 0 ? width : in.getWidth(),
			height > 0 ? height : in.getHeight()
		);
		ImageIO.write(out, type.getFormatName(), dist);
	}

/*
	private static BufferedImage readJpegFile(final InputStream in) throws ImageFormatException, IOException {
		JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder(in); 
		return decoder.decodeAsBufferedImage(); 
	}
*/

	/**
	 * w肳ꂽ摜w肳ꂽϊ@ɂĕϊ摜̃Rs[Ԃ܂B
	 * 
	 * @param source 摜
	 * @param type 摜`
	 * @return ϊꂽ摜
	 * @throws IllegalArgumentException
	 */
	public static BufferedImage converteBufferedImage(
		final BufferedImage source,
		final ImageType type)
		throws IllegalArgumentException {

		return converteBufferedImage(source, type, source.getWidth(), source.getHeight());
	}

	/**
	 * w肳ꂽ摜w肳ꂽϊ@ɂĕϊ摜̃Rs[Ԃ܂B
	 * 
	 * @param source 摜
	 * @param scale {
	 * @param type 摜`
	 * @return ϊꂽ摜
	 * @throws IllegalArgumentException
	 */
	public static BufferedImage converteBufferedImage(
		final BufferedImage source,
		final ImageType type,
		final double scale)
		throws IllegalArgumentException {

		return converteBufferedImage(source, type, (int)(source.getWidth() * scale), (int)(source.getHeight() * scale));
	}

	/**
	 * w肳ꂽ摜w肳ꂽϊ@ɂĕϊ摜̃Rs[Ԃ܂B
	 * 
	 * @param source 摜
	 * @param sx {
	 * @param sy c{
	 * @param type 摜`
	 * @return ϊꂽ摜
	 * @throws IllegalArgumentException
	 */
	public static BufferedImage converteBufferedImage(
		final BufferedImage source,
		final ImageType type,
		final double sx,
		final double sy)
		throws IllegalArgumentException {

		return converteBufferedImage(source, type, (int)(source.getWidth() * sx), (int)(source.getHeight() * sy));
	}

	/**
	 * w肳ꂽ摜w肳ꂽϊ@ɂĕϊ摜̃Rs[Ԃ܂B
	 * 
	 * @param source 摜
	 * @param width (sNZ)
	 * @param height (rNZ)
	 * @param type 摜`
	 * @return ϊꂽ摜
	 * @throws IllegalArgumentException
	 */
	public static BufferedImage converteBufferedImage(
		final BufferedImage source,
		final ImageType type,
		final int width,
		final int height)
		throws IllegalArgumentException {

		if (type == null)
			throw new IllegalArgumentException();

		ImageFilter filter = new AreaAveragingScaleFilter(width, height);
		Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(source.getSource(), filter));

		int t = type.getBufferedImageType() == -1 ? source.getType() : type.getBufferedImageType();

		BufferedImage result;

		IndexColorModel indexColorModel = type.getIndexColorModel();
		if (indexColorModel == null)
			result = new BufferedImage(width, height, t);
		else {
			result = new BufferedImage(width, height, t, indexColorModel);
		}

		result.createGraphics().drawImage(image, 0, 0, null);

		return result;
	}

}
