/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.images;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

/**
 * 摜̎ނ\񋓌^łB
 * 
 * @author V _
 */
public enum ImageType {

	/**
	 * 1rbg(2K) GIF (Graphic Interchange Format) \܂B
	 */
	GIF_1BIT {
		@Override
		public String getFormatName() { return "gif"; }
		@Override
		public String getMimeType() { return "image/gif"; }
		@Override
		public String getSuffix() { return "gif"; }
		@Override
		public int getBufferedImageType() { return BufferedImage.TYPE_BYTE_BINARY; }
		@Override
		public IndexColorModel getIndexColorModel() { return null; }
	},

	/**
	 * 2rbg(4K) GIF (Graphic Interchange Format) \܂B
	 */
	GIF_2BIT {
		@Override
		public String getFormatName() { return "gif"; }
		@Override
		public String getMimeType() { return "image/gif"; }
		@Override
		public String getSuffix() { return "gif"; }
		@Override
		public int getBufferedImageType() { return BufferedImage.TYPE_BYTE_BINARY; }
		@Override
		public IndexColorModel getIndexColorModel() { return null; }
	},

	/**
	 * ʓI 8rbg(256F) GIF (Graphic Interchange Format) \܂B
	 */
	GIF_8BIT {
		@Override
		public String getFormatName() { return "gif"; }
		@Override
		public String getMimeType() { return "image/gif"; }
		@Override
		public String getSuffix() { return "gif"; }
		@Override
		public int getBufferedImageType() { return BufferedImage.TYPE_BYTE_INDEXED; }
		@Override
		public IndexColorModel getIndexColorModel() { return null; }
	},

	/**
	 * JPEG (Joint Photographic Experts Group) \܂B
	 */
	JPEG {
		@Override
		public String getFormatName() { return "jpeg"; }
		@Override
		public String getMimeType() { return "image/jpeg"; }
		@Override
		public String getSuffix() { return "jpg"; }
		@Override
		public int getBufferedImageType() { return -1; }
		@Override
		public IndexColorModel getIndexColorModel() { return null; }
	},

	/**
	 * 1rbg() BMP (rbg}bv) \܂B
	 */
	BMP_1BIT {
		@Override
		public String getFormatName() { return "bmp"; }
		@Override
		public String getMimeType() { return "image/bmp"; }
		@Override
		public String getSuffix() { return "bmp"; }
		@Override
		public int getBufferedImageType() { return BufferedImage.TYPE_BYTE_BINARY; }
		@Override
		public IndexColorModel getIndexColorModel() { return null; }
	},

	/**
	 * 2rbg(4F) BMP (rbg}bv) \܂B
	 */
	BMP_2BIT {
		@Override
		public String getFormatName() { return "bmp"; }
		@Override
		public String getMimeType() { return "image/bmp"; }
		@Override
		public String getSuffix() { return "bmp"; }
		@Override
		public int getBufferedImageType() { return BufferedImage.TYPE_BYTE_BINARY; }
		@Override
		public IndexColorModel getIndexColorModel() { return createIndexColorModel(2); }
	},

	/**
	 * 8rbg(256F) PNG (Portable Network Graphics) \܂B
	 */
	PNG_8BIT {
		@Override
		public String getFormatName() { return "png"; }
		@Override
		public String getMimeType() { return "image/png"; }
		@Override
		public String getSuffix() { return "png"; }
		@Override
		public int getBufferedImageType() { return BufferedImage.TYPE_BYTE_INDEXED; }
		@Override
		public IndexColorModel getIndexColorModel() { return null; }
	},

	/**
	 * PNG (Portable Network Graphics) \܂B
	 */
	PNG {
		@Override
		public String getFormatName() { return "png"; }
		@Override
		public String getMimeType() { return "image/png"; }
		@Override
		public String getSuffix() { return "png"; }
		@Override
		public int getBufferedImageType() { return -1; }
		@Override
		public IndexColorModel getIndexColorModel() { return null; }
	};

	/**
	 * 摜`ʂ "gif"  "jpeg" Ȃǂ̕Ԃ܂B
	 *  
	 * @return 摜`ʂ镶
	 */
	public abstract String getFormatName();

	/**
	 * ̉摜`gpWI MIME ^CvԂ܂B
	 *  
	 * @return MIME ^Cv
	 */
	public abstract String getMimeType();

	/**
	 * ̉摜`̕WIȐڔ(t@Cgq)Ԃ܂B
	 * 
	 * @return ڔ(t@Cgq)
	 */
	public abstract String getSuffix();

	/**
	 * ̗񋓌^ɑΉ BufferedImage NX̃C[W̌`Ԃ܂B
	 * ΉC[W̌`Ȃꍇ́A<code>-1</code> Ԃ܂B
	 * 
	 * @return ̗񋓌^ɑΉ BufferedImage NX̃C[W̌`B <code>-1</code>
	 * @see BufferedImage
	 */
	public abstract int getBufferedImageType();

	/**
	 * ̗񋓌^ɑΉƎ̃CfbNXJ[fԂ܂B
	 * Ǝ̃CfbNXJ[fȂꍇ́A<code>null</code> Ԃ܂B
	 * 
	 * @return ̗񋓌^ɑΉCfbNXJ[fB <code>null</code>
	 */
	public abstract IndexColorModel getIndexColorModel();

	private static IndexColorModel createIndexColorModel(final int bits) {
		final int size = 2 << (bits - 1);
		final int inc = 255 / (size - 1);
        byte[] bytes = new byte[size];
        bytes[0]		= (byte)   0;
        bytes[size - 1]	= (byte) 255;

        int value = inc;
        for (int i = 1; i < (size - 1); i++) {
       		bytes[i] = (byte) value;
       		value = value + inc;
        }

        return new IndexColorModel(bits, size, bytes, bytes, bytes);
	}

}
