/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.dao.ImodeFlash;

/**
 * Flash NXłB
 * 
 * @author V _
 */
final class FlashImpl implements Flash {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 * 
	 * @param flash
	 * @param screenWidth
	 */
	public FlashImpl(final ImodeFlash flash, final int screenWidth) {
		this.version		= flash.getVersion();
		this.screenWidth	= screenWidth;
		this.screenHeight	= flash.getScreenHeight();
		this.subScreen		= flash.isSubscreen();
	}

	/**
	 * Flash Lite Ήo[Wێ܂B
	 */
	private float version;

	/*
	 * @see jp.sourceforge.livez.imode.Flash#getVersion()
	 */
	public float getVersion() {
		return version;
	}

	/**
	 * Ҏʏŕ`\ȕێ܂B
	 */
	private int screenWidth = 0;

	/*
	 * @see jp.sourceforge.livez.imode.Flash#getScreenWidth()
	 */
	public int getScreenWidth() {
		return screenWidth;
	}

	/**
	 * Ҏʏŕ`\ȍێ܂B
	 */
	private int screenHeight;

	/*
	 * @see jp.sourceforge.livez.imode.Flash#getScreenHeight()
	 */
	public int getScreenHeight() {
		return screenHeight;
	}

	/**
	 * wʉʂ Flash Lite gp\ǂێ܂B
	 */
	private boolean subScreen;

	/*
	 * @see jp.sourceforge.livez.imode.Flash#isSubScreen()
	 */
	public boolean isSubScreen() {
		return subScreen;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
