/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.dao.ImodeIappli;

/**
 * Iappli NXłB
 * 
 * @author V _
 */
final class IappliImpl implements Iappli {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 * 
	 * @param iappli
	 */
	public IappliImpl(final ImodeIappli iappli) {
		this.version			= iappli.getDoja();
		this.edition			= iappli.isEdition();
		this.maxJarSize			= iappli.getJar() * 1024;
		this.maxScratchPadSize	= iappli.getSp() * 1024;
		this.width				= iappli.getWidth();
		this.height				= iappli.getHeight();
	}

	/**
	 * ΉĂ DoJa vt@C̃o[Wێ܂B<p>
	 */
	private float version;

	/*
	 * @see jp.sourceforge.livez.imode.Iappli#getVersion()
	 */
	public float getVersion() {
		return version;
	}

	/**
	 * 킩ǂێ܂B<p>
	 */
	private boolean edition;

	/*
	 * @see jp.sourceforge.livez.imode.Iappli#isEdition()
	 */
	public boolean isEdition() {
		return edition;
	}

	/**
	 * gp\ JAR TCYe(oCgP)ێ܂B<p>
	 */
	private int maxJarSize = 0;

	/*
	 * @see jp.sourceforge.livez.imode.Iappli#getMaxJarSize()
	 */
	public int getMaxJarSize() {
		return maxJarSize;
	}

	/**
	 * gp\ ScratchPad e(oCgP)ێ܂B<p>
	 */
	private int maxScratchPadSize = 0;

	/*
	 * @see jp.sourceforge.livez.imode.Iappli#getMaxScratchPadSize()
	 */
	public int getMaxScratchPadSize() {
		return maxScratchPadSize;
	}

	/**
	 * `\ȕێ܂B<p>
	 */
	private int width = 0;

	/*
	 * @see jp.sourceforge.livez.imode.Iappli#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * `\ȍێ܂B<p>
	 */
	private int height = 0;

	/*
	 * @see jp.sourceforge.livez.imode.Iappli#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
