/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * ImodeBrowser NXłB
 * 
 * @author V _
 */
final class ImodeBrowserImpl implements ImodeBrowser {

	private static final long serialVersionUID = 1L;

	/**
	 * ftHgRXgN^łB
	 */
	public ImodeBrowserImpl() {}

	void setup(final jp.sourceforge.livez.dao.Imode imode) {
		this.width	= imode.getBrowserWidth();
		this.height	= imode.getBrowserHeight();

		if (imode.getBrowserColumn() != null)
			this.column = imode.getBrowserColumn();
		if (imode.getBrowserRow() != null)
			this.row = imode.getBrowserRow();

		this.htmlVersion = imode.getHtml();

		if (imode.getXhtml() != null)
			this.xhtmlVersion = imode.getXhtml();
	}

	void setup(final ImodeUserAgent ua) {
		if (ua.getWidth() > 0)
			this.column = ua.getWidth();
		if (ua.getHeight() > 0)
			this.row = ua.getHeight();

		this.cacheSize = ua.getCacheSize() * 1024;

		if (ua.getHtmlVersion() != null)
			this.htmlVersion = ua.getHtmlVersion();
	}

	/**
	 * uEU̕ێ܂B
	 */
	private int width = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * uEU̍ێ܂B
	 */
	private int height = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * \ێ܂B
	 */
	private int column = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getColumn()
	 */
	public int getColumn() {
		return column;
	}

	/**
	 * \sێ܂B
	 */
	private int row = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getRow()
	 */
	public int getRow() {
		return row;
	}

	/**
	 * LbVTCYێ܂B
	 */
	private int cacheSize = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getCacheSize()
	 */
	public int getCacheSize() {
		return cacheSize;
	}

	/**
	 * Ή i-HTML o[Wԍێ܂B
	 */
	private float htmlVersion;

	/*
	 * @see jp.sourceforge.livez.imode.ImodeBrowser#getHtmlVersion()
	 */
	public float getHtmlVersion() {
		return htmlVersion;
	}

	/**
	 * Ή i-XHTML o[Wԍێ܂B
	 */
	private Float xhtmlVersion = null;

	/*
	 * @see jp.sourceforge.livez.Browser#getXhtmlVersion()
	 */
	public Float getXhtmlVersion() {
		return xhtmlVersion;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
