/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import javax.servlet.http.HttpServletRequest;

import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.MobilePhoneGenerator;
import jp.sourceforge.livez.dao.ImodeDAO;

/**
 * i[h[𐶐gђ[WFl[^NXłB
 * 
 * @author V _
 */
public final class ImodeGenerator extends MobilePhoneGenerator<ImodeRequest, Imode> {

	/**
	 * i[hT[rX؃NXݒt@CQƂẴNX𐶐鎞ɎgpL[łB
	 * 
	 * @see ImodeService#getMobilePhoneGenerator(WebApplicationContext)
	 */
	public static final String BEAN_ID = "imodeGenerator";

	/**
	 * ImodeDAO ێ܂B
	 */
	private ImodeDAO imodeDAO = null;

	/**
	 * ImodeDAO ݒ肵܂B
	 * 
	 * @param imodeDAO ImodeDAO
	 */
	public void setImodeDAO(final ImodeDAO imodeDAO) {
		this.imodeDAO = imodeDAO;
	}

	/**
	 * ftHgRXgN^łB
	 */
	public ImodeGenerator() {}

	/**
	 * i[h[NGXg񂩂i[h[𐶐ĕԂ܂B
	 * 
	 * @param r i[h[NGXg
	 * @return i[h[
	 * @throws NullPointerException i[h[NGXg <code>null</code> ̏ꍇ
	 * @throws DataAccessException ImodeDAO ̑ŗOꍇ
	 */
	@Override
	public Imode create(final ImodeRequest r) throws NullPointerException, DataAccessException {
		// ȍ~̏ubN\bh邱
		final ImodeImpl result = new ImodeImpl();

		if (imodeDAO != null) {
			jp.sourceforge.livez.dao.Imode imode = imodeDAO.load(r.getUserAgent().getName());
			if (imode != null)
				result.setup(imode);
		}

		result.setup(r);

		return result;
	}

	/**
	 * HTTP NGXg񂩂i[h[𐶐ĕԂ܂B
	 * 
	 * @param request HTTPNGXg
	 * @return i[h[
	 * @throws NullPointerException HTTPNGXg <code>null</code> ̏ꍇ
	 * @throws IllegalRequestException HTTPNGXg񂪕sȏꍇ
	 * @throws DataAccessException ImodeDAO ̑ŗOꍇ
	 */
	@Override
	public Imode create(final HttpServletRequest request) throws NullPointerException, IllegalRequestException, DataAccessException {
		return create(new ImodeRequestImpl(request));
	}

}
