/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.CarrierType;
import jp.sourceforge.livez.Screen;
import jp.sourceforge.livez.ServiceType;
import jp.sourceforge.livez.dao.ImodeFrame;
import jp.sourceforge.livez.images.ImageType;

/**
 * Imode NXłB
 * 
 * @author V _
 */
final class ImodeImpl implements Imode {

	private static final long serialVersionUID = 1L;

	/**
	 * ftHgRXgN^łB
	 */
	public ImodeImpl() {}

	void setup(final jp.sourceforge.livez.dao.Imode imode) {
		// ̌Qݒ肵܂
		this.name			= imode.getName();
		this.productName	= imode.getProductName();
		this.seriesName		= imode.getSeriesName();

		// ʏ\z܂
		this.screen = new ScreenImpl(imode);

		// wʉʏ񂪑݂ꍇ͍\z܂
		if (imode.getSubscreen() != null)
			this.subScreen = new SubScreenImpl(imode.getSubscreen());

		// uEUݒ肵܂
		this.browser.setup(imode);

		// iAv񂪑݂ꍇ͍\z܂
		if (imode.getIappli() != null)
			this.appli = new IappliImpl(imode.getIappli());

		// Flash 񂪑݂ꍇ͍\z܂
		if (imode.getFlash() != null)
			this.flash = new FlashImpl(imode.getFlash(), imode.getScreenWidth());

		if (imode.getImotion() != null)
			this.imotionType = ImotionType.valueOf(imode.getImotion());

		this.pdf = imode.isPdf();
		this.charaDen = imode.isCharaDen();

		if (imode.getDecomail() != null)
			this.decomail = new DecomailImpl(imode.getDecomail());

		this.toruca = imode.isToruca();
		this.ichannel = imode.isIchannel();

		if (this.browser.getHtmlVersion() >= 4.0)
			this.iemojiType = IemojiType.STANDARD_AND_EXTENSTION;

		// ʐ^t[摜񂪑݂ꍇ͍\z܂
		if (imode.getFrames() != null && imode.getFrames().size() > 0) {
			List<Frame> list = new ArrayList<Frame>(imode.getFrames().size());
			for (ImodeFrame frame : imode.getFrames())
				list.add(new FrameImpl(frame));

			this.frames = list;
		}

		this.menuIcon = imode.isMenuIcon();

		if (imode.getBarcode() != null)
			this.barcode = imode.getBarcode();

		this.ssl = imode.getSsl();

		if (imode.getColor() > 256)
			this.imageTypes.add(ImageType.GIF_8BIT);
		if (imode.getColor() > 4)
			this.imageTypes.add(ImageType.GIF_2BIT);
		if (imode.isJpeg())
			this.imageTypes.add(ImageType.JPEG);
	}

	void setup(final ImodeRequest r) {
		final ImodeUserAgent ua = r.getUserAgent();

		// ̌Qݒ肵܂
		this.id		= ua.getId();
		this.name	= ua.getName();

		if (this.seriesName != null)
			this.seriesName = ua.getSeriesName();

		this.vendorId = ua.getVendorId();

		// uEUݒ肵܂
		this.browser.setup(ua);

		// NGXgݒ肵܂
		this.type			= ua.getType();
		this.accessType		= ua.getAccessType();
		this.networkType	= ua.getNetworkType();
		this.geoCode		= r.getRoaming();
		this.ser			= ua.getSer();
		this.icc			= ua.getIcc();
		this.userId			= r.getUID();
		this.trustedId		= ua.getTrustedId();

		this.imageTypes.add(ImageType.GIF_1BIT);
	}



	// ---------------------------------------- ÓI

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getServiceType()
	 */
	public ServiceType getServiceType() {
		return ServiceType.IMODE;
	}

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getCarrierType()
	 */
	public CarrierType getCarrierType() {
		return CarrierType.NTT_DOCOMO;
	}

	/**
	 * [IDێ܂B<p>
	 */
	private String id = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * [ێ܂B<p>
	 */
	private String name = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getName()
	 */
	public String getName() {
		return name;
	}

	/**
	 * iێ܂B<p>
	 */
	private String productName = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getProductName()
	 */
	public String getProductName() {
		return productName;
	}

	/**
	 * V[Yێ܂B<p>
	 */
	private String seriesName = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getSeriesName()
	 */
	public String getSeriesName() {
		return seriesName;
	}

	/**
	 * x_[IDێ܂B<p>
	 */
	private String vendorId = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getVendorId()
	 */
	public String getVendorId() {
		return vendorId;
	}

	/**
	 * tʏێ܂B<p>
	 */
	private ScreenImpl screen = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getScreen()
	 */
	public Screen getScreen() {
		return screen;
	}

	/**
	 * wʉʏێ܂B<p>
	 */
	private SubScreenImpl subScreen = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getSubScreen()
	 */
	public SubScreen getSubScreen() {
		return subScreen;
	}

	/**
	 * uEUێ܂B<p>
	 */
	private ImodeBrowserImpl browser = new ImodeBrowserImpl();

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getBrowser()
	 */
	public ImodeBrowser getBrowser() {
		return browser;
	}

	/**
	 * iAvێ܂B<p>
	 */
	private IappliImpl appli = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getAppli()
	 */
	public Iappli getAppli() {
		return appli;
	}

	/**
	 * Flash Lite ێ܂B<p>
	 */
	private FlashImpl flash = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getFlash()
	 */
	public Flash getFlash() {
		return flash;
	}

	/**
	 * i[Vێ܂B<p>
	 */
	private ImotionType imotionType = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getImotionType()
	 */
	public ImotionType getImotionType() {
		return imotionType;
	}

	/**
	 * PDF Ή󋵂ێ܂B<p>
	 */
	private boolean pdf = false;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#isPdf()
	 */
	public boolean isPdf() {
		return pdf;
	}

	/**
	 * LdΉ󋵂ێ܂B<p>
	 */
	private boolean charaDen = false;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#isCharaDen()
	 */
	public boolean isCharaDen() {
		return charaDen;
	}

	/**
	 * fR[Ήێ܂B<p>
	 */
	private Decomail decomail = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getDecomail()
	 */
	public Decomail getDecomail() {
		return decomail;
	}

	/**
	 * gJΉ󋵂ێ܂B
	 */
	private boolean toruca = false;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#isToruca()
	 */
	public boolean isToruca() {
		return toruca;
	}

	/**
	 * i`lΉ󋵂ێ܂B
	 */
	private boolean ichannel = false;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#isIchannel()
	 */
	public boolean isIchannel() {
		return ichannel;
	}

	/**
	 * i[hΉG̎ނێ܂B
	 */
	private IemojiType iemojiType = IemojiType.STANDARD;
	/*
	 * @see jp.sourceforge.livez.imode.Imode#getIemojiType()
	 */
	public IemojiType getIemojiType() {
		return iemojiType;
	}

	/**
	 * ʐ^t[摜Ή̃Xgێ܂B
	 */
	private List<Frame> frames = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getFrames()
	 */
	public List<Frame> getFrames() {
		return frames;
	}

	/**
	 * j[ACRΉ󋵂ێ܂B
	 */
	private boolean menuIcon = false;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#isMenuIcon()
	 */
	public boolean isMenuIcon() {
		return menuIcon;
	}

	/**
	 * o[R[hΉo[Wێ܂B
	 */
	private Float barcode = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getBarcode()
	 */
	public Float getBarcode() {
		return barcode;
	}

	/**
	 * SSL Ήxێ܂B
	 */
	private Integer ssl = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getSsl()
	 */
	public Integer getSsl() {
		return ssl;
	}

	/**
	 * 摜`ւ̑Ή󋵂ێ܂B
	 */
	private List<ImageType> imageTypes = new ArrayList<ImageType>(4);

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getEnableImageTypes()
	 */
	public List<ImageType> getEnableImageTypes() {
		return imageTypes;
	}



	// ---------------------------------------- I

	/**
	 * [^Cvێ܂B<p>
	 */
	private ImodeType type = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getType()
	 */
	public ImodeType getType() {
		return type;
	}

	/**
	 * ԃR[hێ܂B<p>
	 */
	private AccessType accessType = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getAccessType()
	 */
	public AccessType getAccessType() {
		return accessType;
	}

	/**
	 * ʐM̎ނێ܂B<p>
	 */
	private NetworkType networkType = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getNetworkType()
	 */
	public NetworkType getNetworkType() {
		return networkType;
	}

	/**
	 * [UANZXĂ鍑ԍێ܂B<p>
	 */
	private int geoCode = -1;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getGeoCode()
	 */
	public int getGeoCode() {
		return geoCode;
	}

	/**
	 * ԍێ܂B<p>
	 */
	private String ser = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getSer()
	 */
	public String getSer() {
		return ser;
	}

	/**
	 * FOMAJ[hʔԍێ܂B<p>
	 */
	private String icc = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getIcc()
	 */
	public String getIcc() {
		return icc;
	}

	/**
	 * UID ێ܂B<p>
	 */
	private UID userId = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getUserId()
	 */
	public UID getUserId() {
		return userId;
	}

	/**
	 * gXebhAPID ێ܂B<p>
	 */
	private String trustedId = null;

	/*
	 * @see jp.sourceforge.livez.imode.Imode#getTrustedId()
	 */
	public String getTrustedId() {
		return trustedId;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
