/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.IllegalRequestException;

/**
 * ImodeRequest NXłB
 * 
 * @author V _
 */
final class ImodeRequestImpl implements ImodeRequest {

	/**
	 * RXgN^łB
	 * 
	 * @param ua
	 * @throws IllegalRequestException
	 */
	public ImodeRequestImpl(final String ua) throws IllegalRequestException {
		this(ua, null, -1);
	}

	/**
	 * RXgN^łB
	 * 
	 * @param ua
	 * @param uid
	 * @throws IllegalRequestException
	 */
	public ImodeRequestImpl(final String ua, final String uid) throws IllegalRequestException {
		this(ua, uid, -1);
	}

	/**
	 * RXgN^łB
	 * 
	 * @param ua
	 * @param uid
	 * @param dcmroaming
	 * @throws IllegalRequestException
	 */
	public ImodeRequestImpl(final String ua, final String uid, final int dcmroaming) throws IllegalRequestException {
		this.userAgent = new ImodeUserAgentImpl(ua);
		this.roaming = dcmroaming;

		if (uid != null)
			this.uid = new UIDImpl(uid);
	}

	/**
	 * RXgN^łB
	 * 
	 * @param request HTTP NGXg
	 * @throws IllegalRequestException sȃNGXg̏ꍇ
	 */
	public ImodeRequestImpl(final HttpServletRequest request) throws IllegalRequestException {
		this.userAgent = new ImodeUserAgentImpl(request);

		try {
			this.uid = new UIDImpl(request);
		} catch (NullPointerException e) {
			this.uid = null;
		}

		try {
			this.roaming = request.getIntHeader("X-DCMRoaming");
		} catch (NumberFormatException e) {
			throw new IllegalRequestException(e.getMessage(), e);
		}
	}

	/**
	 * [UG[WFgێ܂B
	 */
	private ImodeUserAgent userAgent = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhoneRequest#getUserAgent()
	 */
	public ImodeUserAgent getUserAgent() {
		return userAgent;
	}

	/**
	 * UID ێ܂B
	 */
	private UID uid = null;

	/*
	 * @see jp.sourceforge.livez.imode.ImodeRequest#getUID()
	 */
	public UID getUID() {
		return uid;
	}

	/**
	 * [UANZXĂ鍑ԍێ܂B
	 */
	private int roaming = -1;

	/*
	 * @see jp.sourceforge.livez.imode.ImodeRequest#getRoaming()
	 */
	public int getRoaming() {
		return roaming;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
