/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.Screen;

/**
 * Screen ̎NXłB
 * 
 * @author V _
 */
final class ScreenImpl implements Screen {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 * 
	 * @param imode i[h
	 */
	public ScreenImpl(final jp.sourceforge.livez.dao.Imode imode) {
		if (imode.getScreenWidth() != null)
			this.width = imode.getScreenWidth();
		if(imode.getScreenHeight() != null)
			this.height = imode.getScreenHeight();
		this.monochrome = imode.isMonochrome();
		this.color = imode.getColor();
	}

	/**
	 * ێ܂B
	 */
	private int width;

	/*
	 * @see jp.sourceforge.livez.Screen#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * ێ܂B
	 */
	private int height;

	/*
	 * @see jp.sourceforge.livez.Screen#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * mNʂǂێ܂B
	 */
	private boolean monochrome;

	/*
	 * @see jp.sourceforge.livez.Screen#isMonochrome()
	 */
	public boolean isMonochrome() {
		return monochrome;
	}

	/**
	 * F/Kێ܂B
	 */
	private int color;

	/*
	 * @see jp.sourceforge.livez.Screen#getColor()
	 */
	public int getColor() {
		return color;
	}

	/*
	 * @see jp.sourceforge.livez.Screen#isQVGA()
	 */
	public boolean isQVGA() {
		return width >= 240 && height >= 320;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
