/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.IllegalUserIdException;

/**
 * UID NXłB
 * 
 * @author V _
 */
final class UIDImpl implements UID {

	private static final long serialVersionUID = 1L;

	/**
	 * w肳ꂽ񂩂UID\zRXgN^łB
	 * 
	 * @param uid UID \
	 * @throws NullPointerException uid  null w肵ꍇ
	 * @throws IllegalUserIdException uid sȏꍇ
	 */
	public UIDImpl(final String uid) throws NullPointerException, IllegalUserIdException {
		parse(uid);
	}

	/**
	 * HTTPNGXg񂩂UID\zRXgN^łB
	 * 
	 * @param request HTTPNGXg
	 * @throws NullPointerException request  uid  null ̏ꍇ
	 * @throws IllegalUserIdException uid sȏꍇ
	 */
	public UIDImpl(final HttpServletRequest request) throws NullPointerException, IllegalUserIdException {
		parse(request.getParameter(KEY));
	}

	/**
	 * w肳ꂽ UID ͂tB[hݒ肵܂B
	 * 
	 * @param uid UID \
	 * @throws NullPointerException uid  null w肵ꍇ
	 * @throws IllegalUserIdException uid sȏꍇ
	 */
	private void parse(final String uid) throws NullPointerException, IllegalUserIdException {
//		if (uid.matches("^[0-9a-zA-Z]{12}$")) {
		if (uid.matches("^(00|01){1}[0-9a-zA-Z]{10}$")) {
			this.value = uid;
			this.member = true;

			try {
				this.type = UIDType.getUIDType(uid.substring(0, 2));
			} catch (IllegalArgumentException e) {
				throw new IllegalUserIdException(e.getMessage(), e);
			}

			this.userId	= uid.substring(2);
		} else if (DEFAULT.equals(uid)) {
			this.value = uid;
		} else
			throw new IllegalUserIdException(uid);
	}

	/**
	 * UID ̒lێ܂B
	 */
	private String value = null;

	/*
	 * @see jp.sourceforge.livez.UserId#getValue()
	 */
	public String getValue() {
		return value;
	}

	/**
	 * UID ̎ނێ܂B
	 */
	private UIDType type = null;

	/*
	 * @see jp.sourceforge.livez.imode.UID#getType()
	 */
	public UIDType getType() {
		return type;
	}

	/**
	 * [UIDێ܂B
	 */
	private String userId = null;

	/*
	 * @see jp.sourceforge.livez.imode.UID#getUserId()
	 */
	public String getUserId() {
		return userId;
	}

	/**
	 * Ԃێ܂B
	 */
	private boolean member = false;

	/*
	 * @see jp.sourceforge.livez.imode.UID#isMember()
	 */
	public boolean isMember() {
		return member;
	}

	/*
	 * @see jp.sourceforge.livez.imode.UID#isGuest()
	 */
	public boolean isGuest() {
		return !member;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
