/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. Ltd. All rights reserved.
 */

package jp.sourceforge.livez.lang;

/**
 * ASCII䕶̒萔񋟂܂B
 * 
 * @author V _
 */
public final class Ascii {

	/**
	 * ASCII䕶 NULL \܂B<p>
	 */
	public static final char NUL = '\u0000';

	/**
	 * ASCII䕶 START OF HEADING \܂B<p>
	 */
	public static final char SOH = '\u0001';

	/**
	 * ASCII䕶 START OF TEXT \܂B<p>
	 */
	public static final char STX = '\u0002';

	/**
	 * ASCII䕶 END OF TEXT \܂B<p>
	 */
	public static final char ETX = '\u0003';

	/**
	 * ASCII䕶 END OF TRANSMISSION \܂B<p>
	 */
	public static final char EOT = '\u0004';

	/**
	 * ASCII䕶 ENQURY \܂B<p>
	 */
	public static final char ENQ = '\u0005';

	/**
	 * ASCII䕶 Acknowledge \܂B<p>
	 */
	public static final char ACK = '\u0006';

	/**
	 * ASCII䕶 BELL \܂B<p>
	 */
	public static final char BEL = '\u0007';

	/**
	 * ASCII䕶 BACKSPACE \܂B<p>
	 */
	public static final char BS = '\u0008';

	/**
	 * ASCII䕶 CHARACTER TABULATION (HORIZONTAL TABULATION) \܂B<p>
	 */
	public static final char HT = '\u0009';	// '\t';

	/**
	 * ASCII䕶 CHARACTER TABULATION (HORIZONTAL TABULATION) \܂B<p>
	 * l HT ƓłB֐ׂ̈ɒ񋟂Ă܂B
	 */
	public static final char TAB = HT;

	/**
	 * ASCII䕶 LINE FEED (NEW LINE/END OF LINE) \܂B<p>
	 */
	public static final char LF = '\n';

	/**
	 * ASCII䕶 LINE FEED (NEW LINE/END OF LINE) \܂B<p>
	 * l LF ƓłB֐ׂ̈ɒ񋟂Ă܂B
	 */
	public static final char NL = LF;

	/**
	 * ASCII䕶 LINE FEED (NEW LINE/END OF LINE) \܂B<p>
	 * l LF ƓłB֐ׂ̈ɒ񋟂Ă܂B
	 */
	public static final char EOL = LF;

	/**
	 * ASCII䕶 LINE TABULATION (VARTICAL TABULATION) \܂B<p>
	 */
	public static final char VT = '\u000B';

	/**
	 * ASCII䕶 FORM FEED \܂B<p>
	 */
	public static final char FF = '\u000C';

	/**
	 * ASCII䕶 CARRIAGE RETURN \܂B<p>
	 */
	public static final char CR = '\r';

	/**
	 * ASCII䕶 SHIFT OUT \܂B<p>
	 */
	public static final char SO = '\u000E';

	/**
	 * ASCII䕶 SHIFT IN \܂B<p>
	 */
	public static final char SI = '\u000F';

	/**
	 * ASCII䕶 DATA LINK ESCAPE \܂B<p>
	 */
	public static final char DLE = '\u0010';

	/**
	 * ASCII䕶 DEVICE CONTROL ONE \܂B<p>
	 */
	public static final char DC1 = '\u0011';

	/**
	 * ASCII䕶 DEVICE CONTROL TWO \܂B<p>
	 */
	public static final char DC2 = '\u0012';

	/**
	 * ASCII䕶 DEVICE CONTROL THREE \܂B<p>
	 */
	public static final char DC3 = '\u0013';

	/**
	 * ASCII䕶 DEVICE CONTROL FOUR \܂B<p>
	 */
	public static final char DC4 = '\u0014';

	/**
	 * ASCII䕶 NEGATIVE Acknowledge \܂B<p>
	 */
	public static final char NAK = '\u0015';

	/**
	 * ASCII䕶 SYNCHRONOUS IDLE \܂B<p>
	 */
	public static final char SYN = '\u0016';

	/**
	 * ASCII䕶 END OF TRANSMISSION BLOCK \܂B<p>
	 */
	public static final char ETB = '\u0017';

	/**
	 * ASCII䕶 CANCEL \܂B<p>
	 */
	public static final char CAN = '\u0018';

	/**
	 * ASCII䕶 END OF MEDIUM \܂B<p>
	 */
	public static final char EM = '\u0019';

	/**
	 * ASCII䕶 SUBSTITUTE \܂B<p>
	 */
	public static final char SUB = '\u001A';

	/**
	 * ASCII䕶 ESCAPE \܂B<p>
	 */
	public static final char ESC = '\u001B';

	/**
	 * ASCII䕶 INFORMATION SEPARATOR FOUR (FILE SEPARATOR) \܂B<p>
	 */
	public static final char FS = '\u001C';

	/**
	 * ASCII䕶 INFORMATION SEPARATOR THREE (GROUP SEPARATOR) \܂B<p>
	 */
	public static final char GS = '\u001D';

	/**
	 * ASCII䕶 INFORMATION SEPARATOR TWO (RECORD SEPARATOR) \܂B<p>
	 */
	public static final char RS = '\u001E';

	/**
	 * ASCII䕶 INFORMATION SEPARATOR ONE (UNIT SEPARATOR) \܂B<p>
	 */
	public static final char US = '\u001F';

	/**
	 * pXy[X\B
	 */
	public static final char SP = '\u0020';

	/**
	 * ASCII䕶 DELETE \܂B<p>
	 */
	public static final char DEL = '\u007F';

	/**
	 * 䕄̃LbW^[yуCtB[h\B
	 */
	public static final String CRLF = "\r\n";

	/**
	 * CX^XłȂ܂B<p>
	 */
	private Ascii() {}

	/**
	 * w肳ꂽASCII䕶ł邩ǂԂ܂B<p>
	 * 
	 * @param c 
	 * @return ASCII䕶ł邩ǂ
	 */
	public static boolean isControlCharacter(final char c) {
		return c < SP || c == DEL;
	}

	/**
	 * w肳ꂽ񂩂琧䕶Ԃ܂B<p>
	 * 
	 * @param s 
	 * @return 䕶
	 */
	public static String removeControlCharacters(final String s) {
		if (s == null)
			return null;

		StringBuilder results = new StringBuilder(s.length());

		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);
			if (!isControlCharacter(c))
				results.append(c);
		}

		return results.toString();
	}

}
