/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.lang;

/**
 * i[hGɊւ郆[eBeBNXłB<p>
 * 
 * @author V _
 */
public final class ImodeEmojiUtils {

	/**
	 * CX^XłȂ܂B<p>
	 */
	private ImodeEmojiUtils() {}

	/**
	 * w肳ꂽi[h{GǂԂ܂B<p>
	 * 
	 * @param c 
	 * @return i[h{G̏ꍇ true AȊȌꍇ false Ԃ܂B
	 */
	public static boolean isStandardEmoji(final char c) {
		return (c >= 0xE63E && c <= 0xE70B);
	}

	/**
	 * w肳ꂽi[hgGǂԂ܂B<p>
	 * 
	 * @param c 
	 * @return i[hgG̏ꍇ true AȊȌꍇ false Ԃ܂B
	 */
	public static boolean isExtendedEmoji(final char c) {
		return (c >= 0xE70C && c <= 0xE757);
	}

	/**
	 * w肳ꂽi[hGǂԂ܂B<p>
	 * 
	 * @param c 
	 * @return i[hG̏ꍇ true AȊȌꍇ false Ԃ܂B
	 */
	public static boolean isEmoji(final char c) {
		return isStandardEmoji(c) || isExtendedEmoji(c);
	}

	/**
	 * w肳ꂽ񒆂i[h{G݂邩ǂԂ܂B<p>
	 * 
	 * @param s 
	 * @return i[h{G݂ꍇ true AȊȌꍇ false Ԃ܂B
	 */
	public static boolean isStandardEmoji(final String s) {
		if (s == null)
			return false;

		for (int i = 0; i < s.length(); i++) {
			if (isStandardEmoji(s.charAt(i)))
				return true;
		}

		return false;
	}

	/**
	 * w肳ꂽ񒆂i[hgG݂邩ǂԂ܂B<p>
	 * 
	 * @param s 
	 * @return i[hgG݂ꍇ true AȊȌꍇ false Ԃ܂B
	 */
	public static boolean isExtendedEmoji(final String s) {
		if (s == null)
			return false;

		for (int i = 0; i < s.length(); i++) {
			if (isExtendedEmoji(s.charAt(i)))
				return true;
		}

		return false;
	}

	/**
	 * w肳ꂽ񒆂i[hG݂邩ǂԂ܂B<p>
	 * 
	 * @param s 
	 * @return G݂ꍇ true AȊȌꍇ false Ԃ܂B
	 */
	public static boolean isEmoji(final String s) {
		if (s == null)
			return false;

		for (int i = 0; i < s.length(); i++) {
			if (isEmoji(s.charAt(i)))
				return true;
		}

		return false;
	}

	/**
	 * w肳ꂽ񂩂i[h{G폜ĕԂ܂B<p>
	 * w肳ꂽ <code>null</code> ̏ꍇ́A<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return i[h{G폜ꂽB null
	 */
	public static String removeStandardEmoji(final String s) {
		if (s == null)
			return null;

		StringBuilder result = new StringBuilder(s.length());

		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);
			if (!isStandardEmoji(c))
				result.append(c);
		}

		return result.toString();
	}

	/**
	 * w肳ꂽ񂩂i[hgG폜ĕԂ܂B<p>
	 * w肳ꂽ <code>null</code> ̏ꍇ́A<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return i[hgG폜ꂽB null
	 */
	public static String removeExtendedEmoji(final String s) {
		if (s == null)
			return null;

		StringBuilder result = new StringBuilder(s.length());

		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);
			if (!isExtendedEmoji(c))
				result.append(c);
		}

		return result.toString();
	}

	/**
	 * w肳ꂽ񂩂i[hG폜ĕԂ܂B<p>
	 * w肳ꂽ <code>null</code> ̏ꍇ́A<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return i[hG폜ꂽB null
	 */
	public static String removeEmoji(final String s) {
		if (s == null)
			return null;

		StringBuilder result = new StringBuilder(s.length());

		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);
			if (!isEmoji(c))
				result.append(c);
		}

		return result.toString();
	}

	/**
	 * w肳ꂽANZXL[ɑΉGԂ܂B<p>
	 * ΉG݂Ȃꍇ́A<code>null</code> Ԃ܂B
	 * 
	 * @param c ANZXL[(0`9A#A*)
	 * @return ANZXL[ɑΉG
	 */
	public static String renderAccesskeyEmoji(final char c) {
		switch (c) {
			case '1':
				return "\uE6E2";
			case '2':
				return "\uE6E3";
			case '3':
				return "\uE6E4";
			case '4':
				return "\uE6E5";
			case '5':
				return "\uE6E6";
			case '6':
				return "\uE6E7";
			case '7':
				return "\uE6E8";
			case '8':
				return "\uE6E9";
			case '9':
				return "\uE6EA";
			case '0':
				return "\uE6EB";
			case '#':
				return "\uE6E0";
			case '*':
				return "";
			default:
				return null;
		}
	}

}
