/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.lang;

import java.io.UnsupportedEncodingException;

import org.apache.commons.lang.StringUtils;

/**
 * {ꌗł̕񑀍ɂ悭gp@\񋟂郆[eBeBNXłB
 * 
 * @author V _
 */
public final class JaStringUtils {

	/**
	 * SpXy[X\B
	 */
	public static final char WIDE_SPACE = '\u3000';


	/**
	 * CX^XłȂ܂B<p>
	 */
	private JaStringUtils() {}

	////////////////////////////////////////////////////////////
	// `FbN֘A

	/**
	 * w肳ꂽ񂪂Ђ炪Ȃł邩ǂԂ܂B<p>
	 *  <code>null</code> 󕶎񂪎w肳ꂽꍇA<code>false</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return 񂪂Ђ炪Ȃ̏ꍇ true ȊȌꍇ false
	 * @see <a href="http://www.unicode.org/charts/PDF/U3040.pdf">Unicode Character Code Charts Hiragana</a>
	 */
	public static boolean isHiragana(final String s) {
		return validate(s, '\u3040', '\u309F');
	}

	/**
	 * w肳ꂽ񂪃J^Jił邩ǂԂ܂B<p>
	 *  <code>null</code> 󕶎񂪎w肳ꂽꍇA<code>false</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return 񂪃J^Jȉꍇ true ȊȌꍇ false
	 * @see <a href="http://www.unicode.org/charts/PDF/U30A0.pdf">Unicode Character Code Charts Katakana</a>
	 */
	public static boolean isKatakana(final String s) {
		return validate(s, '\u30A0', '\u30FF');
	}

	/**
	 * w肳ꂽ񂪃J^Ji\g(̃NVXgknqtwz)ł邩ǂԂ܂B<p>
	 *  <code>null</code> 󕶎񂪎w肳ꂽꍇA<code>false</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return 񂪃J^Ji\g̏ꍇ true ȊȌꍇ false
	 * @see <a href="http://www.unicode.org/charts/PDF/U31F0.pdf">Unicode Character Code Charts Katakana phonetic extensions</a>
	 */
	public static boolean isKatakanaPhoneticExtensions(final String s) {
		return validate(s, '\u31F0', '\u31FF');
	}

	/**
	 * w肳ꂽ񂪔pL()ł邩ǂԂ܂B<p>
	 *  <code>null</code> 󕶎񂪎w肳ꂽꍇA<code>false</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return 񂪔pL̏ꍇ true ȊȌꍇ false
	 * @see <a href="http://www.unicode.org/charts/PDF/UFF00.pdf">Unicode Character Code Charts Halfwidth Katakana</a>
	 */
	public static boolean isHalfwidthCJKPunctuation(final String s) {
		return validate(s, '\uFF61', '\uFF64');
	}

	/**
	 * w肳ꂽ񂪔pJ^Jił邩ǂԂ܂B<p>
	 *  <code>null</code> 󕶎񂪎w肳ꂽꍇA<code>false</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return 񂪔pJ^Jȉꍇ true ȊȌꍇ false
	 * @see <a href="http://www.unicode.org/charts/PDF/UFF00.pdf">Unicode Character Code Charts Halfwidth Katakana</a>
	 */
	public static boolean isHalfwidthKatakana(final String s) {
		return validate(s, '\uFF65', '\uFF9F');
	}

	/**
	 * w肳ꂽ񂪊(yъ؍܂)ł邩ǂԂ܂B<p>
	 *  <code>null</code> 󕶎񂪎w肳ꂽꍇA<code>false</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return 񂪊̏ꍇ true ȊȌꍇ false
	 * @see <a href="http://www.unicode.org/charts/PDF/U4E00.pdf">Unicode Character Code Charts Unified CJK Ideographs</a>
	 */
	public static boolean isCJKUnifiedIdeographs(final String s) {
		return validate(s, '\u4E00', '\u9FFF');
	}

	/**
	 * w肳ꂽ̑SĂ͈͓̕ɂ邩ǂԂ܂B<p>
	 *  <code>null</code> 󕶎񂪎w肳ꂽꍇA<code>false</code> Ԃ܂B
	 * 
	 * @param s 
	 * @param start Jn
	 * @param end I
	 * @return ͈͓ɂꍇ trueBȊȌꍇAfalse
	 */
	private static boolean validate(final String s, final char start, final char end) {
		if (StringUtils.isEmpty(s))
			return false;

		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);
			if (c < start || c > end)
				return false;
		}

		return true;
	}

	////////////////////////////////////////////////////////////
	// MS dl֘A

	/**
	 * MicrosoftdlUnicodeJavadlUnicode֕ϊĕԂ܂B<p>
	 * `|Ȃǂ̃R[h|CgC܂B<br>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊꂽ
	 */
	public static String microsoftUnicodeToUnicode(final String s) {
		if (s == null)
			return null;

		StringBuilder result = new StringBuilder(s.length());
		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);

			// |
			if (c == '\uFF0D')
				result.append('\u2212');
			// `
			else if (c == '\uFF5E')
				result.append('\u301C');
			// (cent)
			else if (c == '\uFFE0')
				result.append('\u00A2');
			// a(doubleverticalline)
			else if (c == '\u2225')
				result.append('\u2016');
			// (pound)
			else if (c == '\uFFE1')
				result.append('\u00A3');
			// (NOTSIGN)
			else if (c == '\uFFE2')
				result.append('\u00AC');
			// ̑
			else
				result.append(c);
		}

		return result.toString();
	}

	/**
	 * JavadlUnicodeMicrosoftdlUnicode֕ϊĕԂ܂B<p>
	 * `|Ȃǂ̃R[h|CgCWindowsgђ[ŕ\\ɂ܂B<br>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊꂽ
	 */
	public static String unicodeToMicrosoftUnicode(final String s) {
		if (s == null)
			return null;

		StringBuilder result = new StringBuilder(s.length());
		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);

			// |
			if (c == '\u2212')
				result.append('\uFF0D');
			// `
			else if (c == '\u301C')
				result.append('\uFF5E');
			// (cent)
			else if (c == '\u00A2')
				result.append('\uFFE0');
			// a(doubleverticalline)
			else if (c == '\u2016')
				result.append('\u2225');
			// (pound)
			else if (c == '\u00A3')
				result.append('\uFFE1');
			// (NOTSIGN)
			else if (c == '\u00AC')
				result.append('\uFFE2');
			// ̑
			else
				result.append(c);
		}

		return result.toString();
	}

	////////////////////////////////////////////////////////////
	// /֘A

	/**
	 * w肳ꂽ(VtgJISł)oCgԂ܂B<p>
	 *  <code>null</code> w肳ꂽꍇA<code>0</code> Ԃ܂B
	 * 
	 * <pre>
	 * JaStringUtils.getShiftJisLength(null)  = 0
	 * JaStringUtils.getShiftJisLength("")    = 0
	 * JaStringUtils.getShiftJisLength("a")   = 1
	 * JaStringUtils.getShiftJisLength("")  = 2
	 * JaStringUtils.getShiftJisLength("a") = 3
	 * </pre>
	 * 
	 * @param s 
	 * @return oCg
	 */
	public static int getShiftJISByteLength(final String s) {
		if (s == null)
			return 0;

		try {
			return s.getBytes(CharEncoding.SHIFT_JIS).length;
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}

	/**
	 * w肳ꂽ(VtgJISł)oCgԂ܂B<p>
	 * 
	 * <pre>
	 * JaStringUtils.getShiftJisLength(' ')  = 1
	 * JaStringUtils.getShiftJisLength('a')  = 1
	 * JaStringUtils.getShiftJisLength('@') = 2
	 * JaStringUtils.getShiftJisLength('') = 2
	 * </pre>
	 * 
	 * @param c 
	 * @return oCg
	 */
	public static int getShiftJISByteLength(final char c) {
		return getShiftJISByteLength(String.valueOf(c));
	}

	////////////////////////////////////////////////////////////
	// ؎֘A

	/**
	 * w肳ꂽ trim ɂďΏۂ̕ł邩ǂԂ܂B<p>
	 * 
	 * @param c 
	 * @return ASCII䕶ApXy[XASpXy[X̂Âꂩłꍇ trueBȊȌꍇ false
	 */
	private static boolean isTrimCharacter(final char c) {
		return Ascii.isControlCharacter(c) || c == Ascii.SP || c == WIDE_SPACE;
	}

	/**
	 * w肳ꂽ̍ŌォASCII䕶ApXy[XASpXy[X菜ĕԂ܂B<p>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * <pre>
	 * JaStringUtils.leftTrim(null)         = null
	 * JaStringUtils.leftTrim("")           = ""
	 * JaStringUtils.leftTrim(" ")          = ""
	 * JaStringUtils.leftTrim("@")         = ""
	 * JaStringUtils.leftTrim("")     = ""
	 * JaStringUtils.leftTrim("    ") = "  "
	 * </pre>
	 * 
	 * @param s 
	 * @return ꂽ
	 */
	public static String leftTrim(final String s) {
		if (s == null)
			return null;

		for (int i = 0; i < s.length(); i++) {
			if (!isTrimCharacter(s.charAt(i)))
				return s.substring(i);
		}

		return StringUtils.EMPTY;
	}

	/**
	 * w肳ꂽ̐擪ASCII䕶ApXy[XASpXy[X菜ĕԂ܂B<p>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * <pre>
	 * JaStringUtils.rightTrim(null)         = null
	 * JaStringUtils.rightTrim("")           = ""
	 * JaStringUtils.rightTrim(" ")          = ""
	 * JaStringUtils.rightTrim("@")         = ""
	 * JaStringUtils.rightTrim("")     = ""
	 * JaStringUtils.rightTrim("    ") = "  "
	 * </pre>
	 * 
	 * @param s 
	 * @return ꂽ
	 */
	public static String rightTrim(final String s) {
		if (s == null)
			return null;

		for (int i = s.length() - 1; i >= 0; i--) {
			if (!isTrimCharacter(s.charAt(i)))
				return s.substring(0, i + 1);
		}

		return StringUtils.EMPTY;
	}

	/**
	 * w肳ꂽ̐擪ƍŌォASCII䕶ApXy[XASpXy[X菜ĕԂ܂B<p>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * <pre>
	 * JaStringUtils.trim(null)         = null
	 * JaStringUtils.trim("")           = ""
	 * JaStringUtils.trim(" ")          = ""
	 * JaStringUtils.trim("@")         = ""
	 * JaStringUtils.trim("")     = ""
	 * JaStringUtils.trim("    ") = ""
	 * </pre>
	 * 
	 * @param s 
	 * @return ꂽ
	 */
	public static String trim(final String s) {
		return rightTrim(leftTrim(s));
	}

	/**
	 * {ꕶ(_Ȃ)CRLFȂǂrŐ؎鎖Ȃ left s܂B<p>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @param len oCg
	 * @return ꂽ
	 */
	public static String left(final String s, final int len) {
		if (s == null)
			return null;

		final StringBuilder results = new StringBuilder(len);
		int count = 0;

		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);
			final int n = count + getShiftJISByteLength(c);

			if (n > len)
				break;

			final int nextIndex = i + 1;
			if (n == len && nextIndex < s.length()) {
				final char next = s.charAt(nextIndex);
				if (c == Ascii.CR && next == Ascii.LF)
					break;
				if (next == '' || next == '')
					break;
			}

			results.append(c);
			count = n;
		}

		return results.toString();
	}

	/**
	 * {ꕶ(_Ȃ)CRLFȂǂrŐ؎鎖Ȃ right s܂B<p>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @param len oCg
	 * @return ꂽ
	 */
	public static String right(final String s, final int len) {
		if (s == null)
			return null;

		final StringBuilder results = new StringBuilder(len);
		int count = 0;

		for (int i = s.length() - 1; i >= 0; i--) {
			final char c = s.charAt(i);
			final int n = count + getShiftJISByteLength(c);

			if (n > len)
				break;

			final int j = i - 1;
			if (n == len && j < s.length()) {
				final char next = s.charAt(j);
				if (c == Ascii.LF && next == Ascii.CR)
					break;
				if (c == '' || c == '')
					break;
			}

			results.append(c);
			count = n;
		}

		return results.toString();
	}

/*
	public static String mid(final String s, final int pos, final int len) {
		if (s == null)
			return null;

		return null;
	}

	public static String mid(final String s, final int pos) {
		return mid(s, pos, -1);
	}
*/

	////////////////////////////////////////////////////////////
	// ϊ֘A

	/**
	 * p̐\B<p>
	 */
	private static final String NARROW_DIGIT = 
		// 0123456789
		"\u0030\u0031\u0032\u0033\u0034\u0035\u0036\u0037\u0038\u0039";

	/**
	 * Sp̐\B<p>
	 */
	private static final String WIDE_DIGIT =
		// OPQRSTUVWX
		"\uFF10\uFF11\uFF12\uFF13\uFF14\uFF15\uFF16\uFF17\uFF18\uFF19";

	/**
	 * w肵̔pSp֕ϊԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String toWideDigit(final String s) {
		return convert(s, NARROW_DIGIT, WIDE_DIGIT);
	}

	/**
	 * w肵̑Sp𔼊p֕ϊԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String toNarrowDigit(final String s) {
		return convert(s, WIDE_DIGIT, NARROW_DIGIT);
	}

	/**
	 * p̉p\B<p>
	 */
	private static final String NARROW_ALPHABET =
		// ABCDEFGHIJKLMNOPQRSTUVWXYZ
		"\u0041\u0042\u0043\u0044\u0045\u0046\u0047\u0048\u0049\u004A\u004B\u004C\u004D\u004E\u004F\u0050\u0051\u0052\u0053\u0054\u0055\u0056\u0057\u0058\u0059\u005A" +
		// abcdefghijklmnopqrstuvwxyz
		"\u0061\u0062\u0063\u0064\u0065\u0066\u0067\u0068\u0069\u006A\u006B\u006C\u006D\u006E\u006F\u0070\u0071\u0072\u0073\u0074\u0075\u0076\u0077\u0078\u0079\u007A";

	/**
	 * Sp̉p\B<p>
	 */
	private static final String WIDE_ALPHABET =
		// `abcdefghijklmnopqrstuvwxy
		"\uFF21\uFF22\uFF23\uFF24\uFF25\uFF26\uFF27\uFF28\uFF29\uFF2A\uFF2B\uFF2C\uFF2D\uFF2E\uFF2F\uFF30\uFF31\uFF32\uFF33\uFF34\uFF35\uFF36\uFF37\uFF38\uFF39\uFF3A" +
		// 
		"\uFF41\uFF42\uFF43\uFF44\uFF45\uFF46\uFF47\uFF48\uFF49\uFF4A\uFF4B\uFF4C\uFF4D\uFF4E\uFF4F\uFF50\uFF51\uFF52\uFF53\uFF54\uFF55\uFF56\uFF57\uFF58\uFF59\uFF5A";

	/**
	 * w肵̔ppSpp֕ϊԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String toWideAlphabet(final String s) {
		return convert(s, NARROW_ALPHABET, WIDE_ALPHABET);
	}

	/**
	 * w肵̑Spp𔼊pp֕ϊԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String toNarrowAlphabet(final String s) {
		return convert(s, WIDE_ALPHABET, NARROW_ALPHABET);
	}

	/**
	 * pASCII(ASCII䕶yу`_"~")\B<p>
	 */
	private static final String NARROW_ASCII = NARROW_DIGIT + NARROW_ALPHABET +
		" !\"#$%&'(*+,-./:;<=>?@[\\]^_`{|}";

	/**
	 * SpASCII\B<p>
	 */
	private static final String WIDE_ASCII = WIDE_DIGIT + WIDE_ALPHABET +
		"@Ihfi{C|D^FGHmnOQMobp";

	/**
	 * w肵̔pASCIISpASCII֕ϊԂ܂B<p>
	 * ASCII䕶yу`_"~"͕ϊ܂B<br>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String toWideAscii(final String s) {
		return convert(s, NARROW_ASCII, WIDE_ASCII);
	}

	/**
	 * w肵̑SpASCII𔼊pASCII֕ϊԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String toNarrowAscii(final String s) {
		return convert(s, WIDE_ASCII, NARROW_ASCII);
	}

	/**
	 * w肳ꂽɂ from y to Ŏw肳ꂽϊ\gpĕϊĕԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @param from ϊ̕\
	 * @param to ϊ̕\
	 * @return ϊ
	 */
	private static String convert(final String s, final String from, final String to) {
		if (s == null)
			return null;

		StringBuilder results = new StringBuilder(s.length());

		for (int i = 0; i < s.length(); i++) {
			final char c = s.charAt(i);
			final int n = from.indexOf(c);
			if (n != -1)
				results.append(to.charAt(n));
			else
				results.append(c);
		}

		return results.toString();
	}

	////////////////////////////////////////////////////////////
	// Ђ炪/J^Ji

	/**
	 * oϊp̂Ђ炪Ȉꗗ\\܂B<p>
	 */
	private static final String[] HIRAGANA = {
		// 
		"\u304C",	"\u304E",	"\u3050",	"\u3052",	"\u3054",	// GAs()
		"\u3056",	"\u3058",	"\u305A",	"\u305C",	"\u305E",	// ZAs()
		"\u3060",	"\u3062",	"\u3065",	"\u3067",	"\u3069",	// DAs(Âł)
		"\u3070",	"\u3073",	"\u3076",	"\u3079",	"\u307C",	// BAs(΂тԂׂ)
		"\u3071",	"\u3074",	"\u3077",	"\u307A",	"\u307D",	// PAs(ς҂Ղ؂)
//		null,		null,		"\u3094",	null,		null,		// VAs(       )
		null,		null,		null,		null,		null,		// VAs(       )

		"\u3042",	"\u3044",	"\u3046",	"\u3048",	"\u304A",	// s()
		"\u304B",	"\u304D",	"\u304F",	"\u3051",	"\u3053",	// s()
		"\u3055",	"\u3057",	"\u3059",	"\u305B",	"\u305D",	// s()
		"\u305F",	"\u3061",	"\u3064",	"\u3066",	"\u3068",	// s(Ă)
		"\u306A",	"\u306B",	"\u306C",	"\u306D",	"\u306E",	// ȍs(Ȃɂʂ˂)
		"\u306F",	"\u3072",	"\u3075",	"\u3078",	"\u307B",	// ͍s(͂Ђӂւ)
		"\u307E",	"\u307F",	"\u3080",	"\u3081",	"\u3082",	// ܍s(܂݂ނ߂)
		"\u3084",				"\u3086",				"\u3088",	// s(    )
		"\u3089",	"\u308A",	"\u308B",	"\u308C",	"\u308D",	// s()
		"\u308F",	"\u3090",	"\u3091",	"\u3092",	"\u3093",	// s()

		// 
		"\u3041",	"\u3043",	"\u3045",	"\u3047",	"\u3049",	// s()
		"\u3095",				null,		"\u3096",				// s(    )
					null,		null,								// s(      )
								"\u3063",				null,		// s(      )
								null,								// ȍs(        )
		null,		null,		null,		null,		null,		// ͍s(͂Ђӂւ)
								null,								// ܍s(        )
		"\u3083",				"\u3085",				"\u3087",	// s(    )
		null,		null,		null,		null,		null,		// s()
		"\u308E",													// s(        )

		// L
		"\u309B",	"\u309C",										// L(JK)
		"\u30FB",	"\u30FC",										// L(E[)
		"\u309D",	"\u309E",										// JԋL(TU)

		// Ǔ_
		"B",		"u",		"v",		"A"
	};

	/**
	 * oϊp̑SpJ^Jiꗗ\\܂B<p>
	 */
	private static final String[] WIDE_KATAKANA = {
		// 
		"\u30AC",	"\u30AE",	"\u30B0",	"\u30B2",	"\u30B4",	// Ks(KMOQS)
		"\u30B6",	"\u30B8",	"\u30BA",	"\u30BC",	"\u30BE",	// Us(UWY[])
		"\u30C0",	"\u30C2",	"\u30C5",	"\u30C7",	"\u30C9",	// _s(_adfh)
		"\u30D0",	"\u30D3",	"\u30D6",	"\u30D9",	"\u30DC",	// os(orux{)
		"\u30D1",	"\u30D4",	"\u30D7",	"\u30DA",	"\u30DD",	// ps(psvy|)
		"\u30F7",	"\u30F8",	"\u30F4",	"\u30F9",	"\u30FA",	// VAs

		"\u30A2",	"\u30A4",	"\u30A6",	"\u30A8",	"\u30AA",	// As(ACEGI)
		"\u30AB",	"\u30AD",	"\u30AF",	"\u30B1",	"\u30B3",	// Js(JLNPR)
		"\u30B5",	"\u30B7",	"\u30B9",	"\u30BB",	"\u30BD",	// Ts(TVXZ\)
		"\u30BF",	"\u30C1",	"\u30C4",	"\u30C6",	"\u30C8",	// ^s(^`ceg)
		"\u30CA",	"\u30CB",	"\u30CC",	"\u30CD",	"\u30CE",	// is(ijklm)
		"\u30CF",	"\u30D2",	"\u30D5",	"\u30D8",	"\u30DB",	// ns(nqtwz)
		"\u30DE",	"\u30DF",	"\u30E0",	"\u30E1",	"\u30E2",	// }s(}~)
		"\u30E4",				"\u30E6",				"\u30E8",	// s(    )
		"\u30E9",	"\u30EA",	"\u30EB",	"\u30EC",	"\u30ED",	// s()
		"\u30EF",	"\u30F0",	"\u30F1",	"\u30F2",	"\u30F3",	// s()

		// 
		"\u30A1",	"\u30A3",	"\u30A5",	"\u30A7",	"\u30A9",	// As(@BDFH)
		"\u30F5",				"\u31F0",	"\u30F6",				// Js(  N  )
					"\u31F1",	"\u31F2",							// Ts(  VX    )
								"\u30C3",				"\u31F3",	// ^s(    b  g)
								"\u31F4",							// is(    k    )
		"\u31F5",	"\u31F6",	"\u31F7",	"\u31F8",	"\u31F9",	// ns(nqtwz)
								"\u31FA",							// }s(        )
		"\u30E3",				"\u30E5",				"\u30E7",	// s(    )
		"\u31FB",	"\u31FC",	"\u31FD",	"\u31FE",	"\u31FF",	// s()
		"\u30EE",													// s(        )

		// L
		"\u309B",	"\u309C",										// L(JK)
		"\u30FB",	"\u30FC",										// L(E[)
		"\u30FD",	"\u30FE",										// JԋL(RS)

		// Ǔ_
		"B",		"u",		"v",		"A"
	};

	/**
	 * oϊp̔pJ^Jiꗗ\\܂B<p>
	 */
	private static final String[] NARROW_KATAKANA = {
		// 
		"",	"",	"",	"",	"",	// Ks(KMOQS)
		"",	"",	"",	"",	"",	// Us(UWY[])
		"",	"",	"",	"",	"",	// _s(_adfh)
		"",	"",	"",	"",	"",	// os(orux{)
		"",	"",	"",	"",	"",	// ps(psvy|)
		"",	null,	"",	null,	"",	// VAs

		"",	"",	"",	"",	"",	// As(ACEGI)
		"",	"",	"",	"",	"",	// Js(JLNPR)
		"",	"",	"",	"",	"",	// Ts(TVXZ\)
		"",	"",	"",	"",	"",	// ^s(^`ceg)
		"",	"",	"",	"",	"",	// is(ijklm)
		"",	"",	"",	"",	"",	// ns(nqtwz)
		"",	"",	"",	"",	"",	// }s(}~)
		"",			"",			"",	// s(    )
		"",	"",	"",	"",	"",	// s()
		"", 	null,	null,	"",	"",	// s()

		// 
		"",	"",	"",	"", 	"",	// As(@BDFH)
		null,			null,	null,			// Js(  N  )
				null,	null,					// Ts(  VX    )
						"",			null,	// ^s(    b  g)
						null,					// is(    k    )
		null,	null,	null,	null,	null,	// ns(nqtwz)
						null,					// }s(        )
		"",			"",			"",	// s(    )
		null,	null,	null,	null,	null,	// s()
		null,									// s(        )

		// L
		"",	"",							// L(JK)
		"",	"",							// L(E[)
		null,	null,							// JԋL

		// Ǔ_
		"",	"",	"",	""
	};

	/**
	 * w肵̂Ђ炪Ȃ𔼊pJ^Ji֕ϊԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String hiraganaToNarrowKana(final String s) {
		return convert(s, HIRAGANA, NARROW_KATAKANA);
	}

	/**
	 * w肳ꂽ𕽉SpJ^Ji֕ϊĕԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String hiraganaToWideKana(final String s) {
		return convert(s, HIRAGANA, WIDE_KATAKANA);
	}

	/**
	 * w肳ꂽ𔼊pJ^JiSpJ^Ji֕ϊĕԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String narrowKanaToWideKana(final String s) {
		return convert(s, NARROW_KATAKANA, WIDE_KATAKANA);
	}

	/**
	 * w肳ꂽ𔼊pJ^JiЂ炪Ȃ֕ϊĕԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String narrowKanaToHiragana(final String s) {
		return convert(s, NARROW_KATAKANA, HIRAGANA);
	}

	/**
	 * w肳ꂽSpJ^Ji甼pJ^Ji֕ϊĕԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String wideKanaToNarrowKana(final String s) {
		return convert(s, WIDE_KATAKANA, NARROW_KATAKANA);
	}

	/**
	 * w肳ꂽSpJ^JiЂ炪Ȃ֕ϊĕԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String wideKanaToHiragana(final String s) {
		return convert(s, WIDE_KATAKANA, HIRAGANA);
	}

	/**
	 * w肳ꂽ̑SpJ^JiƔpJ^JiЂ炪Ȃ֕ϊĕԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B<br>
	 * ̃\bh͗֐ׂ̈ɒ񋟂Ă܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String katakanaToHiragana(final String s) {
		String result = s;
		result = narrowKanaToHiragana(result);
		result = wideKanaToHiragana(result);
		return result;
	}

	/**
	 * w肳ꂽɂ from y to Ŏw肳ꂽϊ\gpĕϊĕԂ܂B<p>
	 *  <code>null</code> w肵ꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @param from ϊ̕\
	 * @param to ϊ̕\
	 * @return ϊ
	 */
	private static String convert(final String s, final String[] from, final String[] to) {
		if (s == null)
			return null;

		String result = s;

		for (int i = 0; i < from.length; i++) {
			if (from[i] != null && to[i] != null)
				result = StringUtils.replace(result, from[i], to[i]);
		}

		return result;
	}

	////////////////////////////////////////////////////////////
	// 

	/**
	 * w肳ꂽ̔pSp֕ϊĕԂ܂B<p>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String toWide(final String s) {
		return narrowKanaToWideKana(toWideAscii(s));
	}

	/**
	 * w肳ꂽ̑Sp𔼊p֕ϊĕԂ܂B<p>
	 *  <code>null</code> w肳ꂽꍇA<code>null</code> Ԃ܂B
	 * 
	 * @param s 
	 * @return ϊ
	 */
	public static String toNarrow(final String s) {
		return wideKanaToNarrowKana(toNarrowAscii(s));
	}

}
