/*
 * Copyright (C) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;

import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

/**
 * dq[bZ[W̃C^[tF[XłB
 * 
 * @author V _
 */
public interface MailMessage {

	/**
	 *  MimeMessage IuWFNgԂ܂B
	 * 
	 * @return MimeMessage IuWFNg
	 */
	public MimeMessage getMimeMessage();

	/**
	 * G␳@ݒ肵܂B<p>
	 * EZweb 358Ԉȍ~̊Glɂׂɂ́A"EZweb" w肷Kv܂B<br>
	 * {[_zŃpPbgΉ@pG({[_zGS`U)lɂׂɂ́A"Vodafone" w肷Kv܂B
	 * 
	 * @param type G␳@
	 */
	public void setEmojiType(EmojiType type);

	/**
	 * G␳@Ԃ܂B
	 * 
	 * @return G␳@
	 */
	public EmojiType getEmojiType();

	public Enumeration getAllHeaders();

	public String[] getHeader(String name);

	public String getHeader(String name, String delimiter);

	/**
	 * ̃bZ[W̃TCYoCgPʂŕԂ܂B
	 * 
	 * @return bZ[WTCY
	 */
	public int getSize();

	/**
	 * bZ[WIDԂ܂B
	 * 
	 * @return bZ[WID
	 */
	public String getMessageId();

	public Flags getFlags();

	public boolean isSet(Flags.Flag flag);

	/**
	 * dvxԂ܂B
	 * 
	 * @return dvx
	 */
	public int getPriority();

	/**
	 * ̃[𑗐M[̖Oo[W\Ԃ܂B
	 * 
	 * @return [
	 */
	public String getMailerName();

	public Address[] getReplyTo();

	/**
	 * ol̃AhX擾ĕԂ܂B
	 * AhX̎擾Ɏsꍇ null Ԃ܂B
	 * @return ol̃AhX
	 */
	public Address[] getFrom();

	/**
	 * ̃AhX擾ĕԂ܂B
	 * AhX̎擾Ɏsꍇ null Ԃ܂B
	 * @return ̃AhX
	 */
	public Address[] getTo();

	/**
	 * w肳ꂽOyуAhXɒǉ܂B
	 * 
	 * @param name O
	 * @param address [AhX
	 * @throws MessagingException ŗOꍇ
	 */
	public void addTo(String name, String address) throws MessagingException;

	/**
	 * CC̃AhX擾ĕԂ܂B
	 * AhX̎擾Ɏsꍇ null Ԃ܂B
	 * 
	 * @return CC̃AhX
	 */
	public Address[] getCc();

	/**
	 * w肳ꂽOyуAhXCCɒǉ܂B
	 * 
	 * @param name O
	 * @param address [AhX
	 * @throws MessagingException ŗOꍇ
	 */
	public void addCc(String name, String address) throws MessagingException;

	/**
	 * w肳ꂽOyуAhXBCCɒǉ܂B
	 * 
	 * @param name O
	 * @param address [AhX
	 * @throws MessagingException ŗOꍇ
	 */
	public void addBcc(String name, String address) throws MessagingException;

	/**
	 * Ԃ܂BȂꍇ͋󕶎Ԃ܂B
	 * Ō̃fR[hɎsꍇ͐̌̂܂ܕԂ܂B
	 * 
	 * @return 
	 */
	public String getSubject();

	/**
	 * ݒ肵܂B
	 * 
	 * @param subject 
	 * @throws MessagingException ŗOꍇ
	 */
	public void setSubject(String subject) throws MessagingException;

	/**
	 * M̓T[õbZ[WMԂ܂B
	 * sȏꍇ́ADate(0) ̒lԂ܂B
	 * 
	 * @return M
	 */
	public Date getSentDate();

	/**
	 * {Ԃ܂B
	 * @return {
	 */
	public String getText();

	/**
	 * {ݒ肵܂B
	 * @param text {
	 */
	public void setText(String text) throws MessagingException;

	/**
	 * HTML `̃[ł邩ǂԂ܂B
	 * 
	 * @return HTML `̃[ł邩ǂ
	 */
	public boolean isHtml();

	/**
	 * HTML `̃[ŃvCeLXg̈悪邩ǂԂ܂B
	 * 
	 * @return HTML `̃[ŃvCeLXg̈悪邩ǂ
	 */
	public boolean isHtmlOnly();

	/**
	 * HTML `̃[ŃvCeLXg̈悪邩ǂԂ܂B
	 * 
	 * @param trim uNs𖳎邩ǂw肵܂B
	 * @return HTML `̃[ŃvCeLXg̈悪邩ǂ
	 */
	public boolean isHtmlOnly(boolean trim);

	/**
	 * HTML Ԃ܂B
	 * 
	 * @return HTML
	 * @throws MessagingException
	 */
	public String getHtml();

	/**
	 * HTML ݒ肵܂B
	 * 
	 * @param text eLXg{
	 * @param html HTML {
	 * @throws MessagingException
	 */
	public void setHtml(String text, String html) throws MessagingException;

	/**
	 * Ytt@Cǉ܂B
	 * 
	 * @param filename Ytt@C
	 * @param data t@Cf[^
	 * @throws IOException o͗Oꍇ
	 * @throws MessagingException
	 */
	public void attachFile(String filename, byte[] data, final String contentType) throws IOException, MessagingException;

	/**
	 * w肳ꂽCfbNXɂYtt@C擾܂B
	 * 
	 * @param number CfbNX
	 * @return Ytt@C
	 */
	public Object getFile(final int number);

	public Address[] getAllRecipients();

	public void setFlag(Flags.Flag flag, final boolean set) throws MessagingException;

	public void setHeader(final String name, final String value) throws MessagingException;

}
