/*
 * Copyright (C) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;

import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

import jp.sourceforge.livez.lang.JaStringUtils;
import jp.sourceforge.livez.lang.VodafoneEmojiUtils;
import jp.sourceforge.livez.mail.util.ByteArrayDataSource;
import jp.sourceforge.livez.mail.util.EZwebJIS;

/**
 * MailMessage ̎NXłB
 * 
 * @author V _
 */
final class MailMessageImpl implements MailMessage {

	protected MimeMessage message = null;

	/**
	 * RXgN^łB
	 * @param message
	 */
	public MailMessageImpl(final MimeMessage message) {
		this.message = message;
	}

	/**
	 *  MimeMessage IuWFNgԂ܂B
	 * 
	 * @return MimeMessage IuWFNg
	 */
	public MimeMessage getMimeMessage() {
		return message;
	}

	/////////////////////////////////////////////////////////////////////////

	// G␳@ێ܂B
	private EmojiType emojiType = EmojiType.IMODE;

	public void setEmojiType(final EmojiType type) {
		emojiType = type;
	}

	public EmojiType getEmojiType() {
		return emojiType;
	}

	// MɊւvpeB\bh ///////////////////////////////////////

	public Enumeration getAllHeaders() {
		try {
			return message.getAllHeaders();
		} catch (MessagingException e) {
			return null;
		}
	}

	public String[] getHeader(final String name) {
		try {
			return message.getHeader(name);
		} catch (MessagingException e) {
			return new String[0];
		}
	}

	public String getHeader(final String name, final String delimiter) {
		try {
			return message.getHeader(name, delimiter);
		} catch (MessagingException e) {
			return "";
		}
	}

	/**
	 * ̃bZ[W̃TCYoCgPʂŕԂ܂B
	 * 
	 * @return bZ[WTCY
	 */
	public int getSize() {
		try {
			return message.getSize();
		} catch (MessagingException e) {
			return -1;
		}
	}

	public String getMessageId() {
		try {
			return message.getMessageID();
		} catch (MessagingException e) {
			return "";
		}
	}

	public Flags getFlags() {
		try {
			return message.getFlags();
		} catch (MessagingException e) {
			return null;
		}
	}

	public boolean isSet(Flags.Flag flag) {
		try {
			return message.isSet(flag);
		} catch (MessagingException e) {
			return false;
		}
	}

	public int getPriority() {
		int result = 3;
		try {
			result = NumberUtils.toInt(message.getHeader("X-Priority", null));
		} catch (MessagingException e) {}
		if (result <= 0) result = 3;
		return result;
	}

	public String getMailerName() {
		String mailer;
		try {
			mailer = StringUtils.defaultString(message.getHeader("X-Mailer", null));
			if (mailer.length() <= 0) {
				mailer = StringUtils.defaultString(message.getHeader("User-Agent", null));
			}
		} catch (MessagingException e) {
			return "";
		}

		return mailer;
	}

	public Address[] getReplyTo() {
		try {
			return incorrectIcons(message.getReplyTo());
		} catch (MessagingException e) {
			return null;
		}
	}

	public Address[] getFrom() {
		try {
			return incorrectIcons(message.getFrom());
		} catch (MessagingException e) {
			return null;
		}
	}

	public Address[] getTo() {
		try {
			return incorrectIcons(message.getRecipients(Message.RecipientType.TO));
		} catch (MessagingException e) {
			return null;
		}
	}

	public Address[] getCc() {
		try {
			return incorrectIcons(message.getRecipients(Message.RecipientType.CC));
		} catch (MessagingException e) {
			return null;
		}
	}

	public Address[] getAllRecipients() {
		try {
			return incorrectIcons(message.getAllRecipients());
		} catch (MessagingException e) {
			return null;//new Address[0];
		}
	}

	public String getSubject() {
		try {
			return StringUtils.defaultString(incorrectIcons(message.getSubject()));
		} catch (MessagingException e) {
			return "";
		}
	}

	public Date getSentDate() {
		try {
			Date date = message.getSentDate();
			if (date == null)
				date = message.getReceivedDate();
			if (date == null)
				return new Date(0);

			return date;
		} catch (MessagingException e) {
			return new Date(0);
		}
	}

	public String getText() {
		// ŏ text/plain p[g擾B
		// text/plain ̈ȑO multipart/* ȊÖ̗悪oꍇ͋󕶎Ԃ
		String text = "";
		try {
			text = StringUtils.defaultString(MailUtils.getFirstPlainText(message));
		} catch (MessagingException e) {
		} catch (IOException e) {
		}

		return incorrectIcons(text);
	}

	public boolean isHtml() {
		try {
			if (message.isMimeType("text/html")) {
				return true;
			// Ytt@CtHTML`̏ꍇ
			} else if (message.isMimeType("multipart/*")) {
				Multipart mp = (Multipart) message.getContent();
				// qp[g
				for (int index = 0; index < mp.getCount(); index++) {
					if (mp.getBodyPart(index).isMimeType("text/html"))
						return true;
				}
			}
		} catch (MessagingException e) {
		} catch (IOException e) {
		}

		return false;
	}

	public boolean isHtmlOnly() {
		return isHtmlOnly(true);
	}

	public boolean isHtmlOnly(final boolean trim) {
		if (!isHtml())
			return false;

		try {
			String text = MailUtils.getFirstPlainText(message);
			if (text != null && trim)
				text = JaStringUtils.trim(text);
			return StringUtils.isEmpty(text);
		} catch (MessagingException e) {
		} catch (IOException e) {}
		
		return false;
	}

	public String getHtml() {
		try {
			if (message.isMimeType("text/html")) {
				return (String) message.getContent();
			// Ytt@CtHTML`̏ꍇ
			} else if (message.isMimeType("multipart/*")) {
				Multipart mp = (Multipart) message.getContent();
				// qp[g
				for (int index = 0; index < mp.getCount(); index++) {
					Part part = mp.getBodyPart(index);
					if (part.isMimeType("text/html"))
						return (String) mp.getBodyPart(index).getContent();
				}
			}
		} catch (MessagingException e) {
		} catch (IOException e) {
		}
		return "";
	}

/*
	public ArrayList getFileNames() {
		ArrayList results = new ArrayList(5);

		try {
			// Ytt@CȂ
			if (message.isMimeType("text/plain")) {
				;
			// HTML [̂
			} else if (message.isMimeType("text/html")) {
				;
			// Ytt@Ct[͒ʏ` HTML [̏ꍇ
			} else if (message.isMimeType("multipart/*")) {
				Multipart mp = (Multipart) message.getContent();
				// qp[g
				for(int index = 0; index < mp.getCount(); index++) {
					Part part = mp.getBodyPart(index);
					// }`p[g̃eLXg
					if (part.isMimeType("text/plain")) {
						// Ȃ
					// HTML `HTML
					} else if (part.isMimeType("text/html")) {
//						return (String)mp.getBodyPart(index).getContent();
					} else if (part.isMimeType("multipart/*")) {
					// Ytt@CbZ[W̏ꍇ
					} else if (part.isMimeType("message/rfc822")) {
						MailMessage msg = new MailMessageImpl((MimeMessage)part.getContent());
						String name = incorrectIcons(msg.getSubject());
						String type = part.getContentType();
						int i = type.indexOf(';');
						if (i > -1)
							type = type.substring(0, i);
						results.add(new NameValueBean(name, type));
					// ̑
					} else {
						if (part.getFileName() != null) {
							String name = incorrectIcons(part.getFileName());
							String type = part.getContentType();
							int i = type.indexOf(';');
							if (i > -1)
								type = type.substring(0, i);
							results.add(new NameValueBean(name, type));
						}
					}
				}
			} else {
				if (message.getFileName() != null) {
					String name = incorrectIcons(message.getFileName());
					String type = message.getContentType();
					int i = type.indexOf(';');
					if (i > -1)
						type = type.substring(0, i);
					results.add(new NameValueBean(name, type));
				}
			}
		} catch (MessagingException e) {
		} catch (IOException e) {
		}

		return results;
	}
*/

	public boolean isMimeType(final int number, final String type) {
		int count = -1;

		try {
			// Ytt@CtHTML`̏ꍇ
			if (message.isMimeType("multipart/*")) {
				Multipart mp = (Multipart) message.getContent();
				// qp[g
				for(int index = 0; index < mp.getCount(); index++) {
					Part part = mp.getBodyPart(index);
					// }`p[g̃eLXg
					if (part.isMimeType("text/plain")) {
						;
					// HTML `HTML
					} else if (part.isMimeType("text/html")) {
						;
					} else if (part.isMimeType("multipart/*")) {
						;
					// Ytt@CbZ[W̏ꍇ
					} else if (part.isMimeType("message/rfc822")) {
						count = count + 1;
						if (count == number && part.isMimeType(type))
							return true;
					// ̑
					} else {
						if (part.getFileName() != null) {
							count = count + 1;
							if (count == number && part.isMimeType(type))
								return true;
						}
					}
				}
			}
		} catch (MessagingException e) {
		} catch (IOException e) {
		}

		return false;
	}

	public Object getFile(final int number) {
		int count = -1;

		try {
			// Ytt@CtHTML`̏ꍇ
			// Ytt@CȂ
			if (message.isMimeType("text/plain")) {
				;
			// HTML [̂
			} else if (message.isMimeType("text/html")) {
				;
			// Ytt@Ct[͒ʏ` HTML [̏ꍇ
			} else if (message.isMimeType("multipart/*")) {
				Multipart mp = (Multipart) message.getContent();
				// qp[g
				for(int index = 0; index < mp.getCount(); index++) {
					Part part = mp.getBodyPart(index);
					// }`p[g̃eLXg
					if (part.isMimeType("text/plain")) {
						// Ȃ
					// HTML `HTML
					} else if (part.isMimeType("text/html")) {
//						return (String)mp.getBodyPart(index).getContent();
					} else if (part.isMimeType("multipart/*")) {
					// Ytt@CbZ[W̏ꍇ
					} else if (part.isMimeType("message/rfc822")) {
						count = count + 1;
						MailMessage msg = new MailMessageImpl((MimeMessage)part.getContent());
						if (count == number)
							return msg;
					// ̑
					} else {
						if (part.getFileName() != null) {
							count = count + 1;
							if (count == number)
								return part.getInputStream();
						}
					}
				}
			} else {
				if (message.getFileName() != null) {
					count = count + 1;
					if (count == number)
						return message.getInputStream();
				}
			}

		} catch (MessagingException e) {
		} catch (IOException e) {
		}

		return null;
	}

	// MɊւvpeB\bh ////////////////////////////////////////

	public void addTo(final String name, final String address) throws MessagingException {
		addRecipient(Message.RecipientType.TO, name, address);
	}

	public void addCc(final String name, final String address) throws MessagingException {
		addRecipient(Message.RecipientType.CC, name, address);
	}

	public void addBcc(final String name, final String address) throws MessagingException {
		addRecipient(Message.RecipientType.BCC, name, address);
	}

	private void addRecipient(Message.RecipientType type, final String name, final String address) throws MessagingException {
		InternetAddress[] ia = new InternetAddress[1];

		ia[0] = MailUtils.createInternetAddress(
			StringUtils.defaultString(address).trim(),
			StringUtils.defaultString(correctIcons(name)).trim());

		message.addRecipients(type, ia);
	}

	public void setSubject(final String subject) throws MessagingException {
		try {
			message.setSubject(MimeUtility.encodeText(correctIcons(subject), "ISO-2022-JP", "B"));
		} catch (UnsupportedEncodingException e) {
			throw new MessagingException();
		}
	}

	public void setText(final String text) throws MessagingException {
		message.setText(correctIcons(text), "ISO-2022-JP");
	}

	public void setHtml(final String text, final String html) throws MessagingException {
		//ep[g̗p
		MimeBodyPart textPart = new MimeBodyPart();
		MimeBodyPart htmlPart = new MimeBodyPart();
		
		textPart.setText(correctIcons(text), "ISO-2022-JP");
/*
		StringBuffer html = new StringBuffer();
		html.append("<table width=\"100%\"><tr><td>");
		html.append(text);
		html.append("</td></tr></table>");
*/
		htmlPart.setText(correctIcons(html), "ISO-2022-JP");
		htmlPart.setHeader("Content-Type", "text/html");
		
		//}`p[gIuWFNg
		Multipart mp = new MimeMultipart("alternative");
		mp.addBodyPart(textPart);
		mp.addBodyPart(htmlPart);
		
		//}`p[gIuWFNgbZ[Wɐݒ
		message.setContent(mp);
		//message.setContent( mp, "multipart/alternative");

	}

	public void attachFile(final String filename, final byte[] data, final String contentType) throws IOException, MessagingException {
		String type;
		if (contentType == null || contentType.length() <= 0)
			type = "application/octet-stream";
		else
			type = contentType;

		Multipart mp;
		if (message.getContent() == null) {
			MimeBodyPart part = new MimeBodyPart();
			part.setText("", "ISO-2022-JP");
			mp = new MimeMultipart();
			mp.addBodyPart(part);
		} else if (message.getContent() instanceof String) {
			String text = (String) message.getContent();
			MimeBodyPart part = new MimeBodyPart();
			part.setText(text, "ISO-2022-JP");
			mp = new MimeMultipart();
			mp.addBodyPart(part);
		} else {
			mp = (MimeMultipart) message.getContent();
		}

		MimeBodyPart part = new MimeBodyPart();
		ByteArrayDataSource ds = new ByteArrayDataSource(data, type);
		part.setDataHandler(new DataHandler(ds));
//		part.setContent(data, "application/octet-stream");
		part.setFileName(MimeUtility.encodeText(filename, "ISO-2022-JP", "B"));
//		part.setContentID(filename);
		mp.addBodyPart(part);

		//}`p[gIuWFNgbZ[Wɐݒ
		message.setContent(mp);
	}

	public void setFlag(final Flags.Flag flag, final boolean set) throws MessagingException {
		message.setFlag(flag, set);
	}

	public void setHeader(final String name, final String value) throws MessagingException {
		message.setHeader(name, value);
	}

	private String correctIcons(final String text) {
		if (emojiType == EmojiType.EZWEB) {
			return EZwebJIS.correct(text);
		} else if (emojiType == EmojiType.VODAFONE) {
			return VodafoneEmojiUtils.escapeWebCode456(text);
		}
		return text;
	}

	private String incorrectIcons(final String text) {
		if (emojiType == EmojiType.EZWEB)
			return EZwebJIS.incorrect(text);
		return text;
	}

	private Address[] incorrectIcons(Address[] addresses) {
		if (addresses == null) return new Address[0];

		if (emojiType == EmojiType.EZWEB) {
			InternetAddress[] ia = new InternetAddress[addresses.length];
			for (int index = 0; index < addresses.length; index++) {
				InternetAddress addr = (InternetAddress)addresses[index];
				try {
					ia[index] = new InternetAddress(addr.getAddress(), incorrectIcons(addr.getPersonal()), "ISO-2022-JP");
				} catch (UnsupportedEncodingException e) {
					// 
				}
			}
			return ia;
		}
		return addresses;
	}

}
