/*
 * Copyright (C) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail;

import java.util.Properties;

import org.apache.commons.lang.BooleanUtils;

/**
 * dq[vt@C(AJEg)NXłB
 * 
 * @author V _
 */
public class MailProfile {

	/**
	 * [U(O)
	 */
	protected String username = "root";	// MAol(FROM)Ɏgp܂

	/**
	 * dq[AhX
	 */
	protected String address = "root@localhost";	// MAol(FROM)Ɏgp܂

	/**
	 * ԐMAhX
	 */
	protected String reply = "";	// MAreply-to Ɏgp܂

	/**
	 * [MɊւݒێ܂B
	 */
	protected MailProtocol send = new MailProtocol();

	/**
	 * [MɊւݒێ܂B
	 */
	protected MailProtocol receive = new MailProtocol();


////////////////////////////////////////////////////////////////////////////////

	/**
	 * ftHgRXgN^łB
	 */
	public MailProfile() {
		send.protocol		= SendProtocolType.SMTP.toString().toLowerCase();
		receive.protocol	= ReceiveProtocolType.POP3.toString().toLowerCase();
	}

////////////////////////////////////////////////////////////////////////////////

	/**
	 * [U(O)Ԃ܂B<p>
	 * ł "root" Ԃ܂B
	 * 
	 * @return [U(O)
	 */
	public final String getUsername() {
		return username;
	}

	/**
	 * [U(O)ݒ肵܂B
	 * 
	 * @param username [U(O)
	 */
	public final void setUsername(final String username) {
		this.username = username;
	}

	/**
	 * dq[AhXԂ܂B<p>
	 * ł "root@localhost" Ԃ܂B
	 * 
	 * @return dq[AhX
	 */
	public final String getAddress() {
		return address;
	}

	/**
	 * M҂̓dq[AhXݒ肵܂B
	 * 
	 * @param address dq[AhX
	 */
	public final void setAddress(final String address) {
		this.address = address;
	}

	/**
	 * M҂̕ԐMAhXԂ܂B
	 * 
	 * @return ԐMAhX
	 */
	public final String getReply() {
		return reply;
	}

	/**
	 * M҂̕ԐMAhXݒ肵܂B<p>
	 * ԐMʃAhXƂĎw肷ꍇɎgp܂B
	 * 
	 * @param reply ԐMAhX
	 */
	public final void setReply(final String reply) {
		this.reply = reply;
	}


////////////////////////////////////////////////////////////////////////////////
// MT[o̐ݒɊւvpeB

	/**
	 * MvgRԂ܂B
	 * <p>
	 * ̒l͕KA"smtp" Ԃ܂B<br>
	 * ÃvpeBɑ΂Zb^[\bh͒񋟂܂B
	 * </p>
	 * 
	 * @return MvgR
	 */
	public final SendProtocolType getSendProtocol() {
		return SendProtocolType.valueOf(send.protocol.toUpperCase());
	}

	// send.protocol ̃Zb^[͒񋟂Ȃ

	/**
	 * [MT[oԂ܂B
	 * 
	 * @return MT[o
	 */
	public final String getSendServer() {
		return send.hostname;
	}

	/**
	 * [MT[oݒ肵܂B
	 * 
	 * @param hostname MT[o
	 */
	public final void setSendServer(final String hostname) {
		send.hostname = hostname;
	}

	/**
	 * [MT[õ|[gԍԂ܂B
	 * <p>
	 * ł -1 Ԃ܂B
	 * </p>
	 * 
	 * @return MT[õ|[gԍ
	 */
	public final int getSendPort() {
		return send.port;
	}

	/**
	 * [MT[õ|[gԍݒ肵܂B
	 * <p>
	 * vgR̃|[gԍłȂ|[ggpꍇɎgp܂B
	 * </p>
	 * 
	 * @param port |[gԍ
	 */
	public final void setSendPort(final int port) {
		send.port = port;
	}

	/**
	 * [MT[o֔Fؐڑ邩ǂԂ܂B
	 * <p>
	 * ł false Ԃ܂B
	 * </p>
	 * 
	 * @return Fؐڑ
	 */
	public final boolean isSendAuth() {
		return send.auth;
	}

	/**
	 * [MT[o֔Fؐڑ邩ǂݒ肵܂B
	 * 
	 * @param auth Fؐڑ
	 */
	public final void setSendAuth(final boolean auth) {
		send.auth = auth;
	}

	/**
	 * [MT[o֔Fؐڑ SSL gp邩ǂԂ܂B
	 * 
	 * @return Fؐڑ SSL gp
	 * @deprecated 
	 */
	public final boolean isSendAuthSSL() {
		return send.authSSL;
	}

	/**
	 * [MT[o֔Fؐڑ SSL gp邩ǂݒ肵܂B
	 * 
	 * @param ssl Fؐڑ SSL gp
	 * @deprecated 
	 */
	public final void setSendAuthSSL(final boolean ssl) {
		send.authSSL = ssl;
	}

	/**
	 * [MT[o֔Fؐڑ̃AJEgԂ܂B
	 * 
	 * @return Fؐڑ̃AJEg
	 */
	public final String getSendAuthAccount() {
		return send.account;
	}

	/**
	 * [MT[o֔Fؐڑ̃AJEgݒ肵܂B
	 * 
	 * @param account Fؐڑ̃AJEg
	 */
	public final void setSendAuthAccount(final String account) {
		send.account = account;
	}

	/**
	 * [MT[o֔Fؐڑ̃pX[hԂ܂B
	 * 
	 * @return Fؐڑ̃pX[h
	 */
	public final String getSendAuthPassword() {
		return send.password;
	}

	/**
	 * [MT[o֔Fؐڑ̃pX[hݒ肵܂B
	 * 
	 * @param password Fؐڑ̃pX[h
	 */
	public final void setSendAuthPassword(final String password) {
		send.password = password;
	}

	/**
	 * [MT[o֔Fؐڑ̍ő҂(b)Ԃ܂B
	 * <p>
	 * ł 60 (b) Ԃ܂B
	 * </p>
	 * 
	 * @return MT[o֔Fؐڑ̍ő҂(b)
	 */
	public final int getSendAuthTimeout() {
		return send.connectionTimeout;
	}

	/**
	 * [MT[o֔Fؐڑ̍ő҂(b)ݒ肵܂B
	 * <p>
	 * ^CAEgȂꍇ́A-1 ݒ肵ĉB(񐄏)
	 * </p>
	 * 
	 * @param timeout MT[o֔Fؐڑ̍ő҂(b)
	 */
	public final void setSendAuthTimeout(final int timeout) {
		send.connectionTimeout = timeout;
	}

	/**
	 * M SSL gp邩ǂԂ܂B
	 * 
	 * @return M SSL gp
	 * @deprecated 
	 */
	public final boolean isSendSSL() {
		return send.SSL;
	}

	/**
	 * M SSL gp邩ǂݒ肵܂B
	 * 
	 * @param ssl M SSL gp
	 * @deprecated 
	 */
	public final void setSendSSL(final boolean ssl) {
		send.SSL = ssl;
	}

	/**
	 * Mł̍ő҂(b)Ԃ܂B
	 * <p>
	 * ł -1 Ԃ܂B
	 * </p>
	 * 
	 * @return M̍ő҂(b)
	 */
	public final int getSendTimeout() {
		return send.timeout;
	}

	/**
	 * Mł̍ő҂(b)ݒ肵܂B
	 * 
	 * @param timeout M̍ő҂(b)
	 */
	public final void setSendTimeout(final int timeout) {
		send.timeout = timeout;
	}

////////////////////////////////////////////////////////////////////////////////
// MT[o̐ݒɊւvpeB


	/**
	 * MvgRԂ܂B<p>
	 * "pop3"  "imap" ̂ÂꂩԂ܂B
	 * 
	 * @return MvgR
	 */
	public final ReceiveProtocolType getReceiveProtocol() {
		return ReceiveProtocolType.valueOf(receive.protocol.toUpperCase());
	}

	/**
	 * MvgRݒ肵܂B<p>
	 * "pop3"  "imap" ̂Âꂩw肵ĉB
	 * 
	 * @param protocol MvgR
	 */
	public final void setReceiveProtocol(ReceiveProtocolType protocol) {
		receive.protocol = protocol.toString().toLowerCase();
	}

	/**
	 * [MT[oԂ܂B
	 * 
	 * @return MT[o
	 */
	public final String getReceiveServer() {
		return receive.hostname;
	}

	/**
	 * [MT[oݒ肵܂B
	 * 
	 * @param hostname MT[o
	 */
	public final void setReceiveServer(final String hostname) {
		receive.hostname = hostname;
	}

	/**
	 * [MT[õ|[gԍԂ܂B
	 * 
	 * @return |[gԍ
	 */
	public final int getReceivePort() {
		return receive.port;
	}

	/**
	 * [MT[õ|[gԍݒ肵܂B
	 * 
	 * @param port |[gԍ
	 */
	public final void setReceivePort(final int port) {
		receive.port = port;
	}

	/**
	 * [MT[o֔Fؐڑ邩ǂԂ܂B
	 * <p>
	 * ̒l͕K true Ԃ܂B
	 * </p>
	 * 
	 * @return MT[o֔Fؐڑ
	 */
	public final boolean isReceiveAuth() {
		return true;
	}

	// receive.auth ̃Zb^[͒񋟂Ȃ

	/**
	 * [MT[oւ̔Fؐڑ SSL gp邩ǂԂ܂B
	 * 
	 * @return MT[oFؐڑ SSL gp
	 * @deprecated 
	 */
	public final boolean isReceiveAuthSSL() {
		return receive.authSSL;
	}

	/**
	 * [MT[oւ̔Fؐڑ SSL gp邩ǂݒ肵܂B
	 * 
	 * @param ssl MT[oFؐڑ SSL gp
	 * @deprecated 
	 */
	public final void setReceiveAuthSSL(final boolean ssl) {
		receive.authSSL = ssl;
	}

	/**
	 * [MT[oւ̔Fؐڑ̃AJEgԂ܂B
	 * 
	 * @return MT[oFؐڑ̃AJEg
	 */
	public final String getReceiveAuthAccount() {
		return receive.account;
	}

	/**
	 * [MT[oւ̔Fؐڑ̃AJEgݒ肵܂B
	 * 
	 * @param account MT[oFؐڑ̃AJEg
	 */
	public final void setReceiveAuthAccount(final String account) {
		receive.account = account;
	}

	/**
	 * [MT[oւ̔Fؐڑ̃pX[hԂ܂B
	 * 
	 * @return MT[oFؐڑ̃pX[h
	 */
	public final String getReceiveAuthPassword() {
		return receive.password;
	}

	/**
	 * [MT[oւ̔Fؐڑ̃pX[hݒ肵܂B
	 * 
	 * @param password MT[oFؐڑ̃pX[h
	 */
	public final void setReceiveAuthPassword(final String password) {
		receive.password = password;
	}

	/**
	 * [MT[oւ̔Fؐڑ̍ő҂(b)Ԃ܂B
	 * <p>
	 * ł 60 (b)Ԃ܂B
	 * </p>
	 * 
	 * @return [MT[oFؐڑ̍ő҂(b)
	 */
	public final int getReceiveAuthTimeout() {
		return receive.connectionTimeout;
	}

	/**
	 * [MT[oւ̔Fؐڑ̍ő҂(b)ݒ肵܂B
	 * 
	 * @param timeout [MT[oFؐڑ̍ő҂(b)
	 */
	public final void setReceiveAuthTimeout(final int timeout) {
		receive.connectionTimeout = timeout;
	}

	/**
	 * [M쎞 SSL gp邩ǂԂ܂B
	 * 
	 * @return [M쎞 SSL gp
	 * @deprecated 
	 */
	public final boolean isReceiveSSL() {
		return receive.SSL;
	}

	/**
	 * [M쎞 SSL gp邩ǂݒ肵܂B
	 * 
	 * @param ssl [M쎞 SSL gp
	 * @deprecated 
	 */
	public final void setReceiveSSL(final boolean ssl) {
		receive.SSL = ssl;
	}

	/**
	 * [M쎞̍ő҂(b)Ԃ܂B
	 * <p>
	 * ł -1 Ԃ܂B
	 * </p>
	 * 
	 * @return [M쎞̍ő҂(b)
	 */
	public final int getReceiveTimeout() {
		return receive.timeout;
	}

	/**
	 * [M쎞̍ő҂(b)ݒ肵܂B
	 * 
	 * @param timeout [M쎞̍ő҂(b)
	 */
	public final void setReceiveTimeout(final int timeout) {
		receive.timeout = timeout;
	}

////////////////////////////////////////////////////////////////////////////////
// ֐ׂ̈ɒ񋟂郁\bh

	/**
	 * MT[oyюMT[oւ̔Fؐڑ̃AJEgݒ肵܂B
	 * <p>
	 * ̃\bh͗֐ׂ̈ɒ񋟂Ă܂B
	 * </p>
	 * 
	 * @param account AJEg
	 */
	public final void setAccount(final String account) {
		setSendAuthAccount(account);
		setReceiveAuthAccount(account);
	}

	/**
	 * MT[oyюMT[oւ̔Fؐڑ̃pX[hݒ肵܂B
	 * <p>
	 * ̃\bh͗֐ׂ̈ɒ񋟂Ă܂B
	 * </p>
	 * 
	 * @param password pX[h
	 */
	public final void setPassword(final String password) {
		setSendAuthPassword(password);
		setReceiveAuthPassword(password);
	}

	/**
	 * MT[oyюMT[oւ̔Fؐڑ̍ő҂(b)ݒ肵܂B
	 * <p>
	 * ̃\bh͗֐ׂ̈ɒ񋟂Ă܂B
	 * </p>
	 * 
	 * @param timeout ő҂(b)
	 */
	public final void setTimeout(final int timeout) {
		setSendAuthTimeout(timeout);
		setReceiveAuthTimeout(timeout);
	}

////////////////////////////////////////////////////////////////////////////////
// NXƂ̘Agp\bh

	/**
	 * ̃NX̃vpeB JavaMail p Properties IuWFNg𐶐ĕԂ܂B
	 * 
	 * @return JavaMail p Properties IuWFNg
	 */
	public Properties getProperties() {
		Properties props = new Properties();

		// bZ[WID pɐݒ
		if (address != null && send.account != null) {
			int i = address.indexOf('@');
			if (i > -1 && address.length() > (i + 1)) {
				props.setProperty("mail.host", address.substring(i + 1));
				props.setProperty("mail.user", send.account);
				props.setProperty("mail.from", address);
			}
		}
		
		// MvgR̃vpeBݒ肵܂
		props.setProperty("mail.transport.protocol", send.protocol);
		props.setProperty("mail." + send.protocol + ".host", send.hostname);

		if (send.port > 0) {
			props.setProperty("mail." + send.protocol + ".port", String.valueOf(send.port));
		}

		props.setProperty("mail." + send.protocol + ".from", address);

		if (send.auth) {
			props.setProperty("mail." + send.protocol + ".user", send.account);
			props.setProperty("mail." + send.protocol + ".auth",
				BooleanUtils.toStringTrueFalse(send.auth));

			if (send.connectionTimeout > 0) {
				props.setProperty("mail." + send.protocol + ".connectiontimeout",
					String.valueOf(send.connectionTimeout * 1000));
			}
		}

		if (send.timeout > 0) {
			props.setProperty("mail." + send.protocol + ".timeout",
				String.valueOf(send.timeout * 1000));
		}

		// MvgR̃vpeBݒ肵܂
		props.setProperty("mail.store.protocol", receive.protocol);
		props.setProperty("mail." + receive.protocol + ".host", receive.hostname);

		if (receive.port > 0) {
			props.setProperty("mail." + receive.protocol + ".port", String.valueOf(receive.port));
		}

		props.setProperty("mail." + receive.protocol + ".user", receive.account);

		if (receive.connectionTimeout > 0) {
			props.setProperty("mail." + receive.protocol + ".connectiontimeout",
				String.valueOf(receive.connectionTimeout * 1000));
		}

		if (receive.timeout > 0) {
			props.setProperty("mail." + receive.protocol + ".timeout",
				String.valueOf(receive.timeout * 1000));
		}

		if (receive.authSSL)
			if (ReceiveProtocolType.POP3.toString().equalsIgnoreCase(receive.protocol))
				props.setProperty("mail." + receive.protocol + ".apop.enable", "true");

		// Meɂׂ̊gݒ
		props.setProperty("mail.mime.address.strict", "false");

		System.setProperty("mail.mime.base64.ignoreerrors", "true");

//		System.setProperty("mail.mime.decodetext.strict", "false");
		System.setProperty("mail.mime.charset", "ISO-2022-JP");

		// TODO: ɃvpeBݒp̃R[hǉ܂B

		return props;
	}

}
