/*
 * Copyright (C) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/**
 * [M@\񋟂NXłB
 * 
 * @author V _
 */
public final class MailSender {

	/**
	 * [vt@Cێ܂B
	 */
	private MailProfile profile = null;

	/**
	 * [ZbVێ܂B
	 */
	private Session session = null;

	private Transport transport = null;

	/**
	 * w肳ꂽ[vt@CgpăNX\zRXgN^łB
	 * 
	 * @param profile [vt@C
	 * @param debug fobO[h
	 * @throws NoSuchProviderException
	 */
	public MailSender(final MailProfile profile, final boolean debug) {
		this.profile = profile;
		Properties prop = profile.getProperties();
		if (debug)
			prop.put("mail.debug", "true");
		session = Session.getInstance(prop, null);
	}

	/**
	 * w肳ꂽ[vt@CgpăNX\zRXgN^łB
	 * 
	 * @param profile [vt@C
	 * @throws NoSuchProviderException
	 */
	public MailSender(final MailProfile profile) {
		this(profile, false);
	}

	/**
	 * vt@C̃AJEgƃpX[hgpă[MT[o֐ڑ܂B
	 * 
	 * @throws MessagingException
	 */
	public final void connect() throws MessagingException {
		connect(profile.send.account, profile.send.password);
	}

	/**
	 * [UƃpX[hpă[MT[o֐ڑ܂B
	 * <p>
	 * ̃\bh͔F؂KvȐڑ̎ɎgpĉB
	 * </p>
	 * 
	 * @param user [U
	 * @param password pX[h
	 * @throws MessagingException
	 */
	private final void connect(final String account, final String password) throws MessagingException {
		disconnect();
		transport = session.getTransport();
		transport.connect(profile.send.hostname, profile.send.port, account, password);
	}

	/**
	 * MT[oւ̐ڑԂԂ܂B
	 * 
	 * @return T[o֐ڑĂꍇ true AȊȌꍇ false Ԃ܂B
	 */
	public final boolean isConnected() {
		return ((transport != null) && transport.isConnected());
	}

	/**
	 * MT[oؒf܂B
	 */
	public final void disconnect() {
		if (isConnected()) {
			try {
				transport.close();
				transport = null;
			} catch (MessagingException e) {}
		}
	}

	/**
	 * ̃NXɊ֘AtĂ郁[ZbVA
	 * MimeMessage IuWFNg𐶐ĕԂ܂B
	 * 
	 * @return MimeMessage IuWFNg
	 */
	private final MimeMessage createMimeMessage() {
		return new MimeMessage(session);
	}

	/**
	 * ̃NXɊ֘AtĂ郁[ZbVA
	 * MailMessage IuWFNg𐶐ĕԂ܂B
	 * 
	 * @return MailMessage IuWFNg
	 */
	public final MailMessage createMailMessage() {
		return new MailMessageImpl(createMimeMessage());
	}

	public final MailMessage createReplyMailMessage(final String messageId) {
		return createReplyMailMessage(messageId, null, null);
	}

	public final MailMessage createReplyMailMessage(
		final String messageId,
		final String[] references,
		final String[] inReplyTo) {

		if (messageId == null)
			return createMailMessage();

		MimeMessage message = createMimeMessage();
		try {
			message.addHeader("In-Reply-To", messageId);

			StringBuffer buf = new StringBuffer();
			if (references != null && references.length > 0) {
				for (int index = 0; index < references.length; index++) {
					buf.append(references[index]);
					buf.append(' ');
				}
			} else if (inReplyTo != null && inReplyTo.length > 0) {
				for (int index = 0; index < inReplyTo.length; index++) {
					buf.append(inReplyTo[index]);
					buf.append(' ');
				}
			}
			buf.append(messageId);
			message.addHeader("References", buf.toString());

			message.setFlag(Flags.Flag.ANSWERED, true);
		} catch (MessagingException e) {}	// 
		return new MailMessageImpl(message);
	}

	public final MailMessage createReplyMailMessage(final MailMessage mail) {
		return createReplyMailMessage(mail.getMessageId(), mail.getHeader("References"), mail.getHeader("In-Reply-To"));
	}

	/**
	 * w肳ꂽ MimeMessage IuWFNgɁAw肳ꂽ "From"A"To"ݒ肷ȈՃ\bhłB
	 * 
	 * @param message
	 * @param from
	 * @param to
	 * @throws MessagingException
	 */
/*
	public final void setHeaders(MimeMessage message, final String from, final String to) throws MessagingException {
		message.setFrom(null);
		message.addFrom(InternetAddress.parse(from, true));
		message.addRecipients(MimeMessage.RecipientType.TO, InternetAddress.parse(to, true));
		message.setHeader("Content-Type", "text/plain");
	}
*/

	/**
	 * w肳ꂽp[^ƂɃ[bZ|W쐬đMȈՃ\bhłB
	 * 
	 * @param from
	 * @param to
	 * @param subject
	 * @param body
	 * @throws MessagingException
	 * @throws AddressException
	 */
/*
	public final void send(
		final String from, final String to,
		final String subject, final String body)
		throws MessagingException, AddressException {

			MimeMessage message = createMimeMessage();
			setHeaders(message, from, to);

			try {
				message.setSubject(MimeUtility.encodeText(subject, "ISO-2022-JP", "B"));
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}

			message.setText(body, "ISO-2022-JP");

			send(message);
	}
*/

/*
	public final void send(MimeMessage message, final String envelopeTo, final String envelopeFrom)
		throws MessagingException, AddressException {

			StringBuffer property = new StringBuffer();
			property.append("mail." + profile.send.protocol + ".from");
			session.getProperties().put(property.toString(), envelopeFrom);
			send(message, InternetAddress.parse(envelopeTo, true));
			session.getProperties().remove(property.toString());
	}
*/
/*
	public final void send(MimeMessage message) throws MessagingException {
		send(message, message.getAllRecipients());
	}
*/

	/**
	 * [𑗐M܂B
	 * <p>
	 * [bZ[WɎw肳Ă鑗MAhXSĂɑ΂M܂B
	 * </p>
	 * 
	 * @param message [bZ[W
	 * @throws MessagingException [ŗOꍇ
	 */
	public final void send(MailMessage message) throws MessagingException {
		MimeMessage msg = ((MailMessageImpl) message).message;
		send(msg, msg.getAllRecipients());
	}

	/**
	 * [𑗐M܂B
	 * 
	 * @param message [bZ[W
	 * @param recipients [MAhX̃Xg
	 * @throws MessagingException [ŗOꍇ
	 */
	public final void send(MailMessage message, Address[] recipients) throws MessagingException {
		send(((MailMessageImpl) message).message, recipients);
	}

	/**
	 * [𑗐M܂B
	 * 
	 * @param message Mime bZ[W
	 * @param recipients [MAhX̃Xg
	 * @throws MessagingException [ŗOꍇ
	 */
	public final void send(MimeMessage message, Address[] recipients) throws MessagingException {
		//session.getProperties().put("mail.smtp.from", profile.address);

		message.setFrom(null);
		Address[] address = new InternetAddress[1];
		try {
			address[0] = new InternetAddress(profile.address, profile.username, "ISO-2022-JP");
		} catch (UnsupportedEncodingException e) {
			throw new MessagingException();
		}
		message.addFrom(address);

		message.setSentDate(new Date());
		message.setHeader("Content-Transfer-Encoding", "7bit");//iG̏ꍇ8bit
		message.saveChanges();

		transport.sendMessage(message, recipients);
	}

}
