/*
 * Copyright (C) 2003-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.mail;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;

/**
 * @author V _
 */
final class MailUtils {

	public static final InternetAddress createInternetAddress(final String address) {
		return createInternetAddress(address, "");
	}

	public static final InternetAddress createInternetAddress(final String address, final String name) {
		try {
			return new InternetAddress(address, name, "ISO-2022-JP");
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}

	/**
	 * w肳ꂽp[gŏɏo text/plain ̈̕Ԃ܂B
	 * 
	 * @param part p[g
	 * @return
	 * @throws IOException
	 * @throws MessagingException
	 */
	static String getFirstPlainText(final Part part) throws IOException, MessagingException {
		if (part.isMimeType("text/plain")) {
			return (String) part.getContent();
		} else if (part.isMimeType("multipart/*")) {
				Multipart mp = (Multipart) part.getContent();
				if (mp.getCount() > 0) return getFirstPlainText(mp.getBodyPart(0));
				return null;
		} else
			return null;
	}

}
