/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.util;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;

/**
 * Live Z  Spring Framework p̃[eBeBNXłB
 * 
 * @author V _
 */
public final class SpringUtils {

	/**
	 * CX^XłȂ܂B
	 */
	private SpringUtils() {}

	/**
	 * w肳ꂽ BeanFactory w肳ꂽr[IDɈvIuWFNgԂ܂B
	 * BeanFactory  <code>null</code> ̏ꍇ <code>null</code> Ԃ܂B
	 * 
	 * @param factory BeanFactory
	 * @param id r[ID
	 * @return IuWFNg <code>null</code>
	 * @throws BeansException w肳ꂽr[IDȂꍇ
	 */
	public static Object getRequiredBean(final BeanFactory factory, final String id) throws BeansException {
		if (factory == null)
			return null;

		return factory.getBean(id);
	}

	/**
	 * w肳ꂽ BeanFactory w肳ꂽr[IDɈvIuWFNgԂ܂B
	 * BeanFactory  <code>null</code> ̏ꍇw肳ꂽr[IDȂꍇ <code>null</code> Ԃ܂B
	 * 
	 * @param factory BeanFactory
	 * @param id r[ID
	 * @return IuWFNg <code>null</code>
	 */
	public static Object getBean(final BeanFactory factory, final String id) {
		try {
			return getRequiredBean(factory, id);
		} catch (BeansException e) {
			return null;
		}
	}

}
