/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.util;

import java.io.UnsupportedEncodingException;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;

import jp.sourceforge.livez.lang.CharEncoding;

/**
 * HTML `𕄍/ׂ̃[eBeBNXłB
 * 
 * @author V _
 */
public final class URLUtils {

	/**
	 * CX^XłȂ܂B
	 */
	private URLUtils() {}

	/**
	 * x-www-form-urlencoded 𕜍܂B
	 * VtgJIS̕gpāAu%xyv̌`̘AV[PX\肵܂B
	 * 
	 * @param s Ώۂ̕
	 * @return Vꂽ
	 * @throws IllegalArgumentException
	 */
	public static final String decode(final String s) throws IllegalArgumentException {
		if (s == null)
			return null;

		// org.apache.commons.httpclient.util.URIUtil#decode ł
		URLCodec codec = new URLCodec();
		try {
			return codec.decode(s, CharEncoding.SHIFT_JIS);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e.getMessage(), e);
		} catch (DecoderException e) {
			throw new IllegalArgumentException(e.getMessage(), e);
		}
	}

	/**
	 *  application/x-www-form-urlencoded `ɕϊ܂B
	 * ̃\bh́AVtgJIS̕𕄍ƂĎgpāAO𔭐邱ƂȂ܂B
	 * 
	 * @param s ϊΏۂ̕
	 * @return ϊ̕
	 */
	public static final String encode(final String s) {
		if (s == null)
			return null;

		// org.apache.commons.httpclient.util.URIUtil#encode ł
		URLCodec codec = new URLCodec();
		try {
			return codec.encode(s, CharEncoding.SHIFT_JIS);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}

}
